#============================================================================================================
#
#	gIPCIDR`FbN
#	cidr_list.pl
#
#	by 낿˂vX
#	http://zerochplus.sourceforge.jp/
#
#	---------------------------------------------------------------------------
#
#	2011.01.01 start
#
#	2011.11.28 last up
#
#============================================================================================================

package ZP_CIDR;

use strict;
#use warnings;

our $cidr = ();

#------------------------------------------------------------------------------------------------------------
#
#	CIDRXg
#	-------------------------------------------------------------------------------------
#	䕐җɎW߂Ĕz񉻂
#	ǂg͂Ȃ悾
#
#------------------------------------------------------------------------------------------------------------
{
	
	# NTT docomo [ docomo.ne.jp ]
	my @docomo = (
		
		# http://www.nttdocomo.co.jp/service/developer/make/content/ip/
		'210.153.84.0/24',		'210.136.161.0/24',		'210.153.86.0/24',		'124.146.174.0/24',
		'124.146.175.0/24',		'202.229.176.0/24',		'202.229.177.0/24',		'202.229.178.0/24',
		
		# 폜ς݁H
		#'202.229.179.0/24',		'111.89.188.0/24',
		#'111.89.189.0/24',		'111.89.190.0/24',	'111.89.191.0/24',
		
	);
	$cidr->{'docomo'} = \@docomo;
	
	# i[htuEU(docomo)
	my @docomo_pc = (
		
		'210.153.87.0/24',
		
	);
	$cidr->{'docomo_pc'} = \@docomo_pc;
	
	# Vodafone Ƃ SoftBank Ƃ J-PHONE Ƃc [ jp-[a-z].jp, softbank.ne.jp, vodafone.ne.jp ]
	my @vodafone = (
		
		# http://creation.mb.softbank.jp/web/web_ip.html
		'210.146.7.192/26',		'202.253.96.224/27',	'123.108.237.0/27',
		
		# \g 2012N03ȍ~
		#'123.108.237.112/28',	'123.108.239.224/28',	'202.253.96.144/28',	'202.253.99.144/28',
		#'210.228.189.188/30',
		
		# 폜ς݁H
		#'123.108.236.0/24',	'202.179.204.0/24',		'210.146.60.192/26',	'210.151.9.128/26',
		#'211.8.159.128/25',	'210.175.1.128/25',
		
		
	);
	$cidr->{'vodafone'} = \@vodafone;
	
	# PCTCguEU(Softbank)
	my @vodafone_pc = (
		
		# http://creation.mb.softbank.jp/web/web_ip.html
		'123.108.237.224/27',	'202.253.96.0/27',
		
		# \g 2012N03ȍ~
		'123.108.237.128/28',	'123.108.239.240/28',	'202.253.96.160/28',	'202.253.99.160/28',
		'210.228.189.196/30',
		
	);
	$cidr->{'vodafone_pc'} = \@vodafone_pc;
	
	# au by KDDI [ ezweb.ne.jp ]
	my @ezweb = (
		
		# http://www.au.kddi.com/ezfactory/tec/spec/ezsava_ip.html
		'210.230.128.224/28',	'121.111.227.160/27',	'61.117.1.0/28',		'219.108.158.0/27',
		'219.125.146.0/28',		'61.117.2.32/29',		'61.117.2.40/29',		'219.108.158.40/29',
		'219.125.148.0/25',		'222.5.63.0/25',		'222.5.63.128/25',		'222.5.62.128/25',
		'59.135.38.128/25',		'219.108.157.0/25',		'219.125.145.0/25',		'121.111.231.0/25',
		'121.111.227.0/25',		'118.152.214.192/26',	'118.159.131.0/25',		'118.159.133.0/25',
		'118.159.132.160/27',	'111.86.142.0/26',		'111.86.141.64/26',		'111.86.141.128/26',
		'111.86.141.192/26',	'118.159.133.192/26',	'111.86.143.192/27',	'111.86.143.224/27',
		'111.86.147.0/27',		'111.86.142.128/27',	'111.86.142.160/27',	'111.86.142.192/27',
		'111.86.142.224/27',	'111.86.143.0/27',		'111.86.143.32/27',		'111.86.147.32/27',
		'111.86.147.64/27',		'111.86.147.96/27',		'111.86.147.128/27',	'111.86.147.160/27',
		'111.86.147.192/27',	'111.86.147.224/27',
		
		# 2011NH~fȍ~̈ꕔ@EZT[o
		'111.107.116.0/26',		'111.107.116.64/26',	'111.107.116.192/28',
		
	);
	$cidr->{'ezweb'} = \@ezweb;
	
	# PCTCgr[A(ezweb)
	my @ezweb_pc = (
		
		# http://www.au.kddi.com/ezfactory/tec/spec/pcsv.html
		'222.15.68.192/26',		'59.135.39.128/27',		'118.152.214.160/27',	'118.152.214.128/27',
		'222.1.136.96/27',		'222.1.136.64/27',		'59.128.128.0/20',		'111.86.140.40/30',
		'111.86.140.44/30',		'111.86.140.48/30',		'111.86.140.52/30',		'111.86.140.56/30',
		'111.86.140.60/30',
		
	);
	$cidr->{'ezweb_pc'} = \@ezweb_pc;
	
	# C[EoC [ emobile.ad.jp ]
	my @emobile = (
		
		# http://developer.emnet.ne.jp/ipaddress.html
		'117.55.1.224/27'
		
	);
	$cidr->{'emobile'} = \@emobile;
	
	# WILLCOM [ prin.ne.jp ]
	my @willcom = (
		
		# http://www.willcom-inc.com/ja/service/contents_service/create/center_info/
		'61.198.128.0/24',		'61.198.129.0/24',		'61.198.130.0/24',		'61.198.131.0/24',
		'61.198.132.0/24',		'61.198.133.0/24',		'61.198.134.0/24',		'61.198.135.0/24',
		'61.198.136.0/24',		'61.198.137.0/24',		'61.198.138.100/32',	'61.198.138.101/32',
		'61.198.138.102/32',	'61.198.138.103/32',	'61.198.139.0/29',		'61.198.139.128/27',
		'61.198.139.160/28',	'61.198.140.0/24',		'61.198.141.0/24',		'61.198.142.0/24',
		'61.198.143.0/24',		'61.198.160.0/24',		'61.198.161.0/24',		'61.198.162.0/24',
		'61.198.163.0/24',		'61.198.164.0/24',		'61.198.165.0/24',		'61.198.166.0/24',
		'61.198.168.0/24',		'61.198.169.0/24',		'61.198.170.0/24',		'61.198.171.0/24',
		'61.198.172.0/24',		'61.198.173.0/24',		'61.198.174.0/24',		'61.198.175.0/24',
		'61.198.248.0/24',		'61.198.249.0/24',		'61.198.250.0/24',		'61.198.251.0/24',
		'61.198.252.0/24',		'61.198.253.0/24',		'61.198.254.0/24',		'61.198.255.0/24',
		'61.204.0.0/24',		'61.204.2.0/24',		'61.204.3.0/25',		'61.204.3.128/25',
		'61.204.4.0/24',		'61.204.5.0/24',		'61.204.6.0/25',		'61.204.6.128/25',
		'61.204.7.0/25',		'61.204.92.0/24',		'61.204.93.0/24',		'61.204.94.0/24',
		'61.204.95.0/24',		'114.20.49.0/24',		'114.20.50.0/24',		'114.20.51.0/24',
		'114.20.52.0/24',		'114.20.53.0/24',		'114.20.54.0/24',		'114.20.55.0/24',
		'114.20.56.0/24',		'114.20.57.0/24',		'114.20.58.0/24',		'114.20.59.0/24',
		'114.20.60.0/24',		'114.20.61.0/24',		'114.20.62.0/24',		'114.20.63.0/24',
		'114.20.64.0/24',		'114.20.65.0/24',		'114.20.66.0/24',		'114.20.67.0/24',
		'114.21.255.0/27',		'125.28.0.0/24',		'125.28.1.0/24',		'125.28.15.0/24',
		'125.28.16.0/24',		'125.28.17.0/24',		'125.28.2.0/24',		'125.28.3.0/24',
		'125.28.4.0/24',		'125.28.5.0/24',		'125.28.8.0/24',		'210.168.246.0/24',
		'210.168.247.0/24',		'210.169.92.0/24',		'210.169.93.0/24',		'210.169.94.0/24',
		'210.169.95.0/24',		'210.169.96.0/24',		'210.169.97.0/24',		'210.169.98.0/24',
		'210.169.99.0/24',		'211.126.192.128/25',	'211.18.232.0/24',		'211.18.233.0/24',
		'211.18.234.0/24',		'211.18.235.0/24',		'211.18.236.0/24',		'211.18.237.0/24',
		'219.108.10.0/24',		'219.108.11.0/24',		'219.108.12.0/24',		'219.108.13.0/24',
		'219.108.14.0/24',		'219.108.15.0/24',		'219.108.7.0/24',		'219.108.8.0/24',
		'219.108.9.0/24',		'221.119.0.0/24',		'221.119.1.0/24',		'221.119.2.0/24',
		'221.119.3.0/24',		'221.119.4.0/24',		'221.119.6.0/24',		'221.119.7.0/24',
		'221.119.8.0/24',		'221.119.9.0/24',		'114.20.49.0/24',		'114.20.50.0/24',
		'114.20.51.0/24',		'114.20.52.0/24',		'114.20.53.0/24',		'114.20.54.0/24',
		'114.20.55.0/24',		'114.20.56.0/24',		'114.20.57.0/24',		'114.20.58.0/24',
		'114.20.59.0/24',		'114.20.60.0/24',		'114.20.61.0/24',		'114.20.62.0/24',
		'114.20.63.0/24',		'114.20.64.0/24',		'114.20.65.0/24',		'114.20.66.0/24',
		'114.20.67.0/24',
		
		# 폜ςݐ
		#'219.108.2.0/24',		'219.108.3.0/24',		'125.28.6.0/24',		'125.28.7.0/24',
		#'125.28.11.0/24',		'125.28.12.0/24',		'125.28.13.0/24',		'125.28.14.0/24',
		#'211.18.238.0/24',		'211.18.239.0/24',		'219.108.4.0/24',		'219.108.5.0/24',
		#'219.108.6.0/24',		'221.119.5.0/24',		'114.21.255.0/27',
	
		
	);
	$cidr->{'willcom'} = \@willcom;
	
	# ibisuEU
	my @ibis = (
		
		'59.106.88.0/24',
		
	);
	$cidr->{'ibis'} = \@ibis;
	
	# jiguEU
	my @jig = (
		
		# http://br.jig.jp/pc/ip_br.html
		'82.48.6.10/31',		'82.48.6.12/30',		'112.78.114.208/32',	'112.78.207.6/31',
		'112.78.207.8/29',		'112.78.207.16/29',		'112.78.207.24/31',		'112.78.207.38/31',
		'112.78.207.40/29',		'112.78.207.48/29',		'112.78.207.56/31',		'112.78.215.70/31',
		'112.78.215.72/29',		'112.78.215.80/29',		'112.78.215.88/31',		'112.78.215.166/31',
		'112.78.215.168/29',	'112.78.215.176/29',	'112.78.215.184/31',	'112.78.215.198/31',
		'112.78.215.200/29',	'112.78.215.208/29',	'112.78.215.216/31',	'112.78.215.230/31',
		'112.78.215.232/29',	'112.78.215.240/29',	'112.78.215.248/31',	'182.48.5.134/31',
		'182.48.5.136/29',		'182.48.5.144/29',		'182.48.5.152/31',		'182.48.5.166/31',
		'182.48.5.168/29',		'182.48.5.176/29',		'182.48.5.184/31',		'182.48.5.198/31',
		'182.48.5.200/29',		'182.48.5.208/29',		'182.48.5.216/31',		'182.48.5.230/31',
		'182.48.5.232/29',		'182.48.6.6/31',		'182.48.6.8/29',		'202.181.98.160/32',
		'202.181.98.179/32',	'202.181.98.196/32',	'210.188.205.81/32',	'210.188.205.83/32',
		'219.94.177.6/31',		'219.94.177.8/29',		'219.94.177.16/29',		'219.94.177.24/31',
		'219.94.182.230/31',	'219.94.182.232/29',	'219.94.182.240/29',	'219.94.182.248/31',
		'219.94.183.102/31',	'219.94.183.104/29',	'219.94.183.112/29',	'219.94.183.120/31',
		'219.94.184.70/31',		'219.94.184.72/29',		
		
		# jiguEUWEB
		'124.83.159.0/24',		'124.83.190.0/24',		'210.188.204.0/23',		'210.188.205.0/24',
		
	);
	$cidr->{'jig'} = \@jig;
	
	# iPhone/iPad
	my @iphone = (
		
		# 
		# http://d.hatena.ne.jp/unstablelife/20101228/1293538861
		# http://durianjp.com/mt/2011/01/iphone-ip.html
		'126.160.0.0/11',		'126.192.0.0/10',
		
		# openmobile.ne.jp
		#'126.192.0.0/15',		'126.243.0.0/16',
		
	);
	$cidr->{'iphone'} = \@iphone;
	
	# p2
	my @p2 = (
		
		# cw43.razil.jp
		'210.135.98.43',
		
		# p202.razil.jp
		'210.135.100.132',
		
	);
	$cidr->{'p2'} = \@p2;
}

1;
