#!/usr/bin/perl
#============================================================================================================
#
#	ǂݏopCGI
#	r.cgi
#	-------------------------------------------------------------------------------------
#	2004.04.08 VXeςɔVK쐬
#
#============================================================================================================

# CGI̎sʂIR[hƂ
exit(ReadCGI());

#------------------------------------------------------------------------------------------------------------
#
#	r.cgiC
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub ReadCGI
{
	my (%SYS, $Page, $err);
	
	require './module/thorin.pl';
	$Page = new THORIN;
	
	# Eɐe\
	if (($err = Initialize(\%SYS, $Page)) == 0) {
		# wb_\
		PrintReadHead(\%SYS, $Page);
		
		# j[\
		PrintReadMenu(\%SYS, $Page);
		
		# e\
		PrintReadContents(\%SYS, $Page);
		
		# tb^\
		PrintReadFoot(\%SYS, $Page);
	}
	# ɎsG[\
	else {
		# ΏۃXbhȂꍇ͒Tʂ\
		if ($err == 1003) {
			PrintReadSearch(\%SYS, $Page, $err);
		}
		# ȊO͒ʏG[
		else {
			PrintReadError(\%SYS, $Page, $err);
		}
	}
	
	# \ʂo
	$Page->Flush(0, 0, '');
	
	return $err;
}

#------------------------------------------------------------------------------------------------------------
#
#	r.cgiEO
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Initialize
{
	my ($pSYS, $Page) = @_;
	my (@elem, @regs, $path);
	
	# egpW[̐Ə
	require './module/melkor.pl';
	require './module/isildur.pl';
	require './module/gondor.pl';
	require './module/galadriel.pl';
	
	my ($oSYS, $oSET, $oCONV, $oDAT);
	
	$oSYS	= new MELKOR;
	$oSET	= new ISILDUR;
	$oCONV	= new GALADRIEL;
	$oDAT	= new ARAGORN;
	
	%$pSYS = (
		'SYS'	=> $oSYS,
		'SET'	=> $oSET,
		'CONV'	=> $oCONV,
		'DAT'	=> $oDAT,
		'CODE'	=> 'sjis'
	);
	
	# VXe
	$pSYS->{'SYS'}->Init();
	
	# Np[^̉
	@elem = $pSYS->{'CONV'}->GetArgument(\%ENV);
	
	# BBSw肪
	if ($elem[0] eq '') {
		return 1001;
	}
	# XbhL[w肪
	elsif ($elem[1] eq '' || $elem[1] =~ /[^0-9]/ || length($elem[1]) != 10) {
		return 1002;
	}
	
	# VXeϐݒ
	$pSYS->{'SYS'}->Set('MODE', 0);
	$pSYS->{'SYS'}->Set('BBS', $elem[0]);
	$pSYS->{'SYS'}->Set('KEY', $elem[1]);
	$pSYS->{'SYS'}->Set('AGENT', $elem[7]);
	
	$path = $pSYS->{'SYS'}->Get('BBSPATH') . "/$elem[0]/dat/$elem[1].dat";
	
	# datt@C̓ǂݍ݂Ɏs
	if ($pSYS->{'DAT'}->Load($pSYS->{'SYS'}, $path, 1) == 0) {
		return 1003;
	}
	$pSYS->{'DAT'}->Close();
	
	# ݒt@C̓ǂݍ݂Ɏs
	if ($pSYS->{'SET'}->Load($pSYS->{'SYS'}) == 0) {
		return 1004;
	}
	
	# \JnIʒu̐ݒ
	@regs = $pSYS->{'CONV'}->RegularDispNum(
				$pSYS->{'SYS'}, $pSYS->{'DAT'}, $elem[2], $elem[3], $elem[4]);
	$pSYS->{'SYS'}->SetOption($elem[2], $regs[0], $regs[1], $elem[5], $elem[6]);
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	r.cgiwb_o
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PrintReadHead
{
	my ($Sys, $Page) = @_;
	my ($Caption, $Banner, $code, $title);
	
	require './module/denethor.pl';
	$Banner = new DENETHOR;
	$Banner->Load($Sys->{'SYS'});
	
	$code	= $Sys->{'CODE'};
	$title	= $Sys->{'DAT'}->GetSubject();
	
	# HTMLwb_̏o
	$Page->Print("Content-type: text/html\n\n");
	$Page->Print("<html><head><title>$title</title>");
	$Page->Print("<meta http-equiv=Content-Type content=\"text/html;charset=$code\">");
	$Page->Print('</head><!--nobanner-->');
	
	# <body>^Oo
	{
		$Page->Print('<body>');
	}
	
	# oi[o
	$Banner->Print($Page, 100, 2, 1);
}

#------------------------------------------------------------------------------------------------------------
#
#	r.cgij[o
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PrintReadMenu
{
	my ($Sys, $Page) = @_;
	my ($oSYS, $bbs, $key, $baseBBS, $resNum);
	my ($pathBBS, $pathAll, $pathLast, $pathMenu, $pathNext, $pathPrev);
	
	# O
	$oSYS		= $Sys->{'SYS'};
	$bbs		= $oSYS->Get('BBS');
	$key		= $oSYS->Get('KEY');
	$baseBBS	= $oSYS->Get('SERVER') . '/' . $bbs;
	$pathBBS	= $baseBBS . '/i/index.html';
	$pathAll	= $Sys->{'CONV'}->CreatePath($oSYS, 1, $bbs, $key, '1-10n');
	$pathLast	= $Sys->{'CONV'}->CreatePath($oSYS, 1, $bbs, $key, 'l10');
	$resNum		= $Sys->{'DAT'}->Size();
	
	# OAԍ̎擾
	{
		my ($st, $ed, $b1, $b2, $f1, $f2);
		
		$st = $oSYS->GetOption(2);
		$ed = $oSYS->GetOption(3);
		$b1 = ($st - 11 > 0) ? ($st - 11) : 1;
		$b2 = ($b1 == 1) ? 10 : ($b1 + 10);
		$f1 = ($ed + 1 < $resNum) ? ($ed + 1) : $resNum;
		$f2 = ($ed + 10 < $resNum) ? ($ed + 10) : $resNum;
		
		$pathNext = $Sys->{'CONV'}->CreatePath($oSYS, 1, $bbs, $key, "${f1}-${f2}n");
		$pathPrev = $Sys->{'CONV'}->CreatePath($oSYS, 1, $bbs, $key, "${b1}-${b2}n");
	}
	
	# j[̕\
	$Page->Print("<a href=\"$pathBBS\"></a> ");
	$Page->Print("<a href=\"$pathAll\">1-</a> ");
	$Page->Print("<a href=\"$pathPrev\">O</a> ");
	$Page->Print("<a href=\"$pathNext\"></a> ");
	$Page->Print("<a href=\"$pathLast\">V</a> ");
	$Page->Print("<a href=\"#res\">ڽ</a><br><br>\n");
	
	# Xbh^Cg\
	{
		my $title	= $Sys->{'DAT'}->GetSubject();
		my $ttlCol	= $Sys->{'SET'}->Get('BBS_SUBJECT_COLOR');
		$Page->Print("<dl><font color=$ttlCol size=+1>$title</font><br><br>\n");
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	r.cgieo
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PrintReadContents
{
	my ($Sys, $Page) = @_;
	my ($work, @elem, $i);
	
	$work = $Sys->{'SYS'}->Get('OPTION');
	@elem = split(/\,/, $work);
	
	# 1\tOTRUEŊJn1łȂ1\
	if ($elem[3] == 0 && $elem[1] != 1) {
		PrintResponse($Sys, $Page, 1);
	}
	# c̃X\
	for ($i = $elem[1] ; $i <= $elem[2] ; $i++) {
		PrintResponse($Sys, $Page, $i);
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	r.cgitb^o
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PrintReadFoot
{
	my ($Sys, $Page) = @_;
	my ($oSYS, $Conv, $bbs, $key, $ver, $rmax, $pathNext, $pathPrev);
	
	# O
	$oSYS		= $Sys->{'SYS'};
	$Conv		= $Sys->{'CONV'};
	$bbs		= $oSYS->Get('BBS');
	$key		= $oSYS->Get('KEY');
	$ver		= $oSYS->Get('VERSION');
	$rmax		= $oSYS->Get('RESMAX');
	
	# OAԍ̎擾
	{
		my ($st, $ed, $b1, $b2, $f1, $f2);
		
		$st = $oSYS->GetOption(2);
		$ed = $oSYS->GetOption(3);
		$b1 = ($st - 11 > 0) ? ($st - 11) : 1;
		$b2 = ($b1 == 1) ? 10 : ($b1 + 10);
		$f1 = ($ed + 1 < $rmax) ? ($ed + 1) : $rmax;
		$f2 = ($ed + 10 < $rmax) ? ($ed + 10) : $rmax;
		
		$pathNext = $Conv->CreatePath($oSYS, 1, $bbs, $key, "${f1}-${f2}n");
		$pathPrev = $Conv->CreatePath($oSYS, 1, $bbs, $key, "${b1}-${b2}n");
	}
	$Page->Print('</dl><hr>');
	$Page->Print("<a href=\"$pathPrev\">O</a> ");
	$Page->Print("<a href=\"$pathNext\"></a><hr><a name=res></a>");
	
	# etH[̕\
	# Xő吔𒴂Ăꍇ̓tH[\Ȃ
	if ($rmax > $Sys->{'DAT'}->Size()) {
		my ($tm, $cgiPath);
		
		$tm			= time;
		$cgiPath	= $oSYS->Get('SERVER') . $oSYS->Get('CGIPATH');
		
		$Page->Print("<form method=\"POST\" action=\"$cgiPath/bbs.cgi\" utn>\n");
		$Page->Print("<input type=hidden name=bbs value=$bbs>");
		$Page->Print("<input type=hidden name=key value=$key>");
		$Page->Print("<input type=hidden name=time value=$tm>");
		$Page->Print("\nO<br><input type=text name=\"FROM\"><br>");
		$Page->Print('E-mail<br><input type=text name="mail"><br>');
		$Page->Print('<textarea rows=1 wrap=off name="MESSAGE"></textarea>');
		$Page->Print('<br><input type=submit value=""><br>');
	}
	$Page->Print("<small>$ver</small></form></body></html>\n");
}

#------------------------------------------------------------------------------------------------------------
#
#	r.cgiX\
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PrintResponse
{
	my ($Sys, $Page, $n) = @_;
	my ($oSYS, $oConv, $pDat, @elem, $maxLen, $len);
	
	$oSYS	= $Sys->{'SYS'};
	$oConv	= $Sys->{'CONV'};
	$pDat	= $Sys->{'DAT'}->Get($n -1);
	@elem	= split(/<>/, $$pDat);
	$len	= length $elem[3];
	$maxLen	= $Sys->{'SET'}->Get('BBS_LINE_NUMBER');
	$maxLen	= int($maxLen * 5);
	
	# \͈͓w\Ȃ炷ׂĕ\
	if ($oSYS->GetOption(5) == 1 || $len <= $maxLen) {
		$oConv->ConvertURL($oSYS, $Sys->{'SET'}, 1, \$elem[3]);
		$oConv->ConvertQuotation($oSYS, \$elem[3], 1);
	}
	# \͈͂𒴂Ăȗ\
	else {
		my ($bbs, $key, $path);
		
		$bbs		= $oSYS->Get('BBS');
		$key		= $oSYS->Get('KEY');
		$elem[3]	= $oConv->DeleteText(\$elem[3], $maxLen);
		$maxLen		= int(($len - length($elem[3])) / 20);
		$path		= $oConv->CreatePath($oSYS, 1, $bbs, $key, "${n}n");
		
		$oConv->ConvertURL($oSYS, $Sys->{'SET'}, 1, \$elem[3]);
		$oConv->ConvertQuotation($oSYS, \$elem[3], 1);
		
		if ($maxLen) {
			$elem[3] .= " <a href=\"$path\">$maxLen</a>";
		}
	}
	$Page->Print("<hr>[$n]$elem[0]</b>F$elem[2]<br>$elem[3]<br>\n");
}

#------------------------------------------------------------------------------------------------------------
#
#	r.cgiTʕ\
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PrintReadSearch
{
	my ($Sys, $Page) = @_;
}

#------------------------------------------------------------------------------------------------------------
#
#	r.cgiG[\
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PrintReadError
{
	my ($Sys, $Page, $err) = @_;
	my $code;
	
	$code = 'Shift_JIS';
	
	# HTMLwb_̏o
	$Page->Print("Content-type: text/html\n\n");
	$Page->Print('<html><head><title>dqqnqII</title>');
	$Page->Print("<meta http-equiv=Content-Type content=\"text/html;charset=$code\">");
	$Page->Print('</head><!--nobanner-->');
	$Page->Print('<html><body>');
	$Page->Print("<b>$err</b>");
	$Page->Print('</body></html>');
}

