#============================================================================================================
#
#	httpT[rXW[
#	httpservice.pl
#	-------------------------------------------------------------------------------------
#	2005.11.09 start
#	2012.02.25 啝ɉ ݊Hij\H
#
#============================================================================================================
package HTTPSERVICE;

use strict;
#use warnings;

use Socket;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	httpT[rXIuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $this = shift;
	my ($obj, %PARAMETER);
	
	$obj = {
		'METHOD'		=> 'GET',
		'URI'			=> undef,
		'PARAMETER'		=> \%PARAMETER,
		'AGENT'			=> 'Mozilla/5.0 Zero-Channel BBS Plus Project',
		'CONTENT_TYPE'	=> 'application/x-www-form-urlencoded',
		'CONNECTION'	=> 'close',
		'REFERER'		=> undef,
		'LANGUAGE'		=> 'ja,en-us;q=0.7,en;q=0.3',
		'PROXY_HOST'	=> undef,
		'PROXY_PORT'	=> undef,
		
		'TIMEOUT'		=> 3,
		'HEADER'		=> undef,
		'CODE'			=> 500,
		'CONTENT'		=> undef
	};
	bless $obj, $this;
	return $obj;
}

=for
#------------------------------------------------------------------------------------------------------------
#
#	(RXgN^ŏȂꍇp)
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	httpT[rXIuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub init
{
	my $this = shift;
	
	$this->{'AGENT'}		= 'Mozilla/5.0 Zero-Channel BBS Plus Project';
	$this->{'METHOD'}		= 'GET';
	$this->{'CONTENT_TYPE'}	= 'application/x-www-form-urlencoded';
	$this->{'CONNECTION'}	= 'close';
	$this->{'TIMEOUT'}		= 3;
}
=cut

#------------------------------------------------------------------------------------------------------------
#
#	httpvM
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	G[R[h
#			1:I
#			-1:URIG[
#			-2:socketG[
#
#------------------------------------------------------------------------------------------------------------
sub request
{
	my $this = shift;
	my ($uri, $host, $port, $target, $request);
	
	# URI𕪉
	$uri = $this->{'URI'};
	( $host, $port, $target ) = decompositionURI($uri);
	
	if ( !defined $host ) {
		return -1;
	}
	
	# vLVgp
	if ( defined $this->{'PROXY_HOST'} ) {
		$host	= $this->{'PROXY_HOST'};
		$port	= $this->{'PROXY_PORT'} || 80;
		$target	= $uri;
	}
	
	# NGXgNG̍쐬
	$request = createRequestString($this, $host, $target);
	
	eval
	{
		my ($sockaddr, $header, $streamflag, $content, $contflag, $code, $uri);
		local $SIG{ALRM} = sub{ die "connect time out. $!" };
		
		alarm($this->{'TIMEOUT'});
		
		# \Pbg̍쐬
		$sockaddr = pack_sockaddr_in( $port, inet_aton($host) );
		socket ( SOCKET, PF_INET, SOCK_STREAM, 0 );
		select SOCKET;
		$| =1;
		select STDOUT;
		connect ( SOCKET, $sockaddr );
		#autoflush SOCKET (1);
		
		# NGXgM
		print SOCKET $request;
		
		$streamflag = 0;
		$contflag = 0;
		
		while ( <SOCKET> ) {
			
			chomp;
			
			# HTTPXe[^X
			if ( $_ =~ m!HTTP/1.1 (\d+) .+$! ) {
				$code = $1;
			}
			
			# X|Xwb_[̎擾
			if ( $contflag == 0 ) {
				$header .= $_."\n";
				
				# Xg[炵
				if ( $_ =~ m/^Transfer\-Encoding: chunked/i ) {
					$streamflag = 1;
				}
				
			}
			
			# {̎擾
			if ( $_ =~ m!^(\r)?(\n)?$! && $contflag == 0 ) {
				$contflag = 1;
			}
			elsif ( $contflag == 1 ) {
				
				# Xg[͖
				next if ( $_ =~ /^([0-9a-fA-F]+)?(\x20+)?([\r|\n]+)$/ && $streamflag );
				
				$content .= $_."\n";
				
			}
			
		}
		
		close(SOCKET);
		
		$this->{'CODE'}		= $code;
		$this->{'HEADER'}	= $header;
		$this->{'CONTENT'}	= $content;
		
		alarm(0);
		
	};
	if ($@) {
		$this->{'CONTENT'} = $@;
		return -2;
	}
	
	return 1;
}

#------------------------------------------------------------------------------------------------------------
#
#	URI
#	-------------------------------------------------------------------------------------
#	@param	$uri	URI
#	@return	$host	zXg
#			$port	|[gԍ
#
#------------------------------------------------------------------------------------------------------------
sub decompositionURI
{
	my $uri = shift;
	my ($host, $port, $path);
	
	$uri =~ m!(http:)?(//)?([^:/]*)?(:(\d+)?)?(/.*)?!;
	if ($3) { $host = $3; }
	if ($5) { $port = $5; }
	else	{ $port = 80; }
	if ($6) { $path = $6; }
	
	return ( $host, $port, $path );
}

#------------------------------------------------------------------------------------------------------------
#
#	httpv̐
#	-------------------------------------------------------------------------------------
#	@param	$host	httpvAhX
#			$target	httpvURI
#	@return	httpvwb_
#
#------------------------------------------------------------------------------------------------------------
sub createRequestString
{
	my $this = shift;
	my ($host, $target) = @_;
	my ($request, $params, $len);
	
	# http{fB(p[^)̍쐬
	foreach (keys %{$this->{'PARAMETER'}}) {
		$params .= "$_=" . encode($this->{'PARAMETER'}->{$_}) . '&';
	}
	if (defined $params) {
		$params = substr($params, 0, length($params) - 1);
		$len = length $params;
	}
	
	$request  = $this->{'METHOD'}." ".$target." HTTP/1.1\n";
	$request .= "Host: ".$host."\n";
	$request .= "User-Agent: ".$this->{'AGENT'}."\n";
	$request .= "Accept-Language: ".$this->{'LANGUAGE'}."\n";
	$request .= 'Content-Type: ' . $this->{'CONTENT_TYPE'} . "\n";
	$request .= 'Keep-Alive: 115'."\n";
	if ( $this->{'REFERER'} ) {
		$request .= "Referer: ".$this->{'REFERER'}."\n";
	}
	$request .= "Connection: ".$this->{'CONNECTION'}."\n";
	if ( $this->{'METHOD'} eq "POST" ) {
		$request .= "Content-Length: ".$len."\n";
	}
	$request .= "\n";
	
	if ( $this->{'METHOD'} eq "POST" ) {
		$request .= $params."\n";
	}
	
	return $request;
	
}

#------------------------------------------------------------------------------------------------------------
#
#	URLGR[h
#	-------------------------------------------------------------------------------------
#	@param	$text	GR[h
#	@return	URLGR[h
#
#------------------------------------------------------------------------------------------------------------
sub encode
{
	my $str = shift;
	$str =~ s/([^\w ])/'%'.unpack('H2', $1)/eg;
	$str =~ tr/ /+/;
	return $str;
}

#------------------------------------------------------------------------------------------------------------
#
#	httpwb_[擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	httpwb_[
#
#------------------------------------------------------------------------------------------------------------
sub getHeader
{
	my $this = shift;
	return $this->{'HEADER'};
}

#------------------------------------------------------------------------------------------------------------
#
#	httpHTTPXe[^X擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	httpXe[^X
#
#------------------------------------------------------------------------------------------------------------
sub getStatus
{
	my $this = shift;
	return $this->{'CODE'};
}

#------------------------------------------------------------------------------------------------------------
#
#	httpRec擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	http擾Rec httpvsocketG[Nꍇ̓G[bZ[W
#
#------------------------------------------------------------------------------------------------------------
sub getContent
{
	my $this = shift;
	return $this->{'CONTENT'};
}

#------------------------------------------------------------------------------------------------------------
#
#	httpvuriݒ
#	-------------------------------------------------------------------------------------
#	@param	$uri	URI
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setURI
{
	my $this = shift;
	my ($uri) = @_;
	$this->{'URI'} = $uri;
}

#------------------------------------------------------------------------------------------------------------
#
#	httpv|[gݒ
#	-------------------------------------------------------------------------------------
#	@param	$port	|[gԍ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setPort
{
	my $this = shift;
	my ($port) = @_;
	$this->{'PORT'} = $port;
}

#------------------------------------------------------------------------------------------------------------
#
#	httpv\bhݒ
#	-------------------------------------------------------------------------------------
#	@param	$method	\bh
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setMethod
{
	my $this = shift;
	my ($method) = @_;
	$this->{'METHOD'} = $method;
}


#------------------------------------------------------------------------------------------------------------
#
#	UserAgentݒ
#	-------------------------------------------------------------------------------------
#	@param	$agent	UserAgent
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setAgent
{
	my $this = shift;
	my ($agent) = @_;
	$this->{'AGENT'} = $agent;
}

#------------------------------------------------------------------------------------------------------------
#
#	^CAEgݒ
#	-------------------------------------------------------------------------------------
#	@param	$time	^CAEg(b)
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setTimeout
{
	my $this = shift;
	my ($time) = @_;
	$this->{'TUMEOUT'} = $time;
}

#------------------------------------------------------------------------------------------------------------
#
#	Reg^Cvݒ
#	-------------------------------------------------------------------------------------
#	@param	$type	Reg^Cv
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setContentType
{
	my $this = shift;
	my ($type) = @_;
	$this->{'CONTENT_TYPE'} = $type;
}

#------------------------------------------------------------------------------------------------------------
#
#	RlNVݒ
#	-------------------------------------------------------------------------------------
#	@param	$conn	RlNV
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setConnection
{
	my $this = shift;
	my ($conn) = @_;
	$this->{'CONNECTION'} = $conn;
}

#------------------------------------------------------------------------------------------------------------
#
#	t@ݒ
#	-------------------------------------------------------------------------------------
#	@param	$ref	t@
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setReferer
{
	my $this = shift;
	my ($ref) = @_;
	$this->{'REFERER'} = $ref;
}

#------------------------------------------------------------------------------------------------------------
#
#	vLVݒ
#	-------------------------------------------------------------------------------------
#	@param	$proxy	vLV ( [host]:[port]` )
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setProxy
{
	my $this = shift;
	my ($proxy) = @_;
	my ($host, $port) = split( /:/, $proxy );
	$this->{'PROXY_HOST'} = $host;
	$this->{'PROXY_PORT'} = $port;
}

#------------------------------------------------------------------------------------------------------------
#
#	ݒ
#	-------------------------------------------------------------------------------------
#	@param	$lang	
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setLanguage
{
	my $this = shift;
	my ($lang) = @_;
	$this->{'LANGUAGE'} = $lang;
}

#------------------------------------------------------------------------------------------------------------
#
#	httpvp[^ݒ
#	-------------------------------------------------------------------------------------
#	@param	$key	p[^L[
#	@param	$value	p[^l
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub setParameter
{
	my $this = shift;
	my ($key, $value) = @_;
	$this->{'PARAMETER'}->{$key} = $value;
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
