#============================================================= -*-Perl-*-
#
# Template::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Andy Wardley   <abw@wardley.org>
#
# COPYRIGHT
#   Copyright (C) 1996-2006 Andy Wardley.  All Rights Reserved.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
# REVISION
#   $Id$
#
# IMPORTANT NOTE
#   This module is constructed from the parser/Grammar.pm.skel file by
#   running the parser/yc script.  You only need to do this if # you
#   have modified the grammar in the parser/Parser.yp file and need #
#   to-recompile it.  See the README in the 'parser' directory for
#   more information (sub-directory of the Template distribution).
#
#========================================================================
package Template::Grammar;use strict;use warnings;our$VERSION=2.25;my(@RESERVED,%CMPOP,$LEXTABLE,$RULES,$STATES);my($factory,$rawstart);@RESERVED=qw(GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END USE PLUGIN FILTER MACRO PERL RAWPERL TO STEP AND OR NOT DIV MOD IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META IN TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW DEBUG);%CMPOP=qw(!= ne == eq < < > > >= >= <= <=);$LEXTABLE={'FOREACH'=>'FOR','BREAK'=>'LAST','&&'=>'AND','||'=>'OR','!'=>'NOT','|'=>'FILTER','.'=>'DOT','_'=>'CAT','..'=>'TO','='=>'ASSIGN','=>'=>'ASSIGN',','=>'COMMA','\\'=>'REF','and'=>'AND','or'=>'OR','not'=>'NOT','mod'=>'MOD','div'=>'DIV',};{my@tokens=qw<( ) [ ] { } ${ $ + / ; : ?>;my@cmpop=keys%CMPOP;my@binop=qw(- * %);@$LEXTABLE{@RESERVED,@cmpop,@binop,@tokens}=(@RESERVED,('CMPOP')x@cmpop,('BINOP')x@binop,@tokens);}sub new{my$class=shift;bless{LEXTABLE=>$LEXTABLE,STATES=>$STATES,RULES=>$RULES,},$class;}sub install_factory{my($self,$new_factory)=@_;$factory=$new_factory;}$STATES=[{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'loop'=>4,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'atomdir'=>12,'anonblock'=>50,'template'=>52,'defblockname'=>14,'ident'=>16,'assign'=>19,'macro'=>20,'lterm'=>56,'node'=>23,'term'=>58,'rawperl'=>59,'expr'=>62,'use'=>63,'defblock'=>66,'filter'=>29,'sterm'=>68,'perl'=>31,'chunks'=>33,'setlist'=>70,'try'=>35,'switch'=>34,'directive'=>71,'block'=>72,'condition'=>73}},{ACTIONS=>{"\$"=>43,'LITERAL'=>75,'IDENT'=>2,"\${"=>37},GOTOS=>{'setlist'=>76,'item'=>39,'assign'=>19,'node'=>23,'ident'=>74}},{DEFAULT=>-130},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>79,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{DEFAULT=>-23},{ACTIONS=>{";"=>80}},{DEFAULT=>-37},{DEFAULT=>-14},{ACTIONS=>{"\""=>89,"\$"=>86,'LITERAL'=>88,'FILENAME'=>83,'IDENT'=>81,'NUMBER'=>84},GOTOS=>{'filepart'=>87,'names'=>91,'nameargs'=>90,'filename'=>85,'name'=>82}},{ACTIONS=>{"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"]"=>94,"\${"=>37},GOTOS=>{'sterm'=>96,'item'=>39,'range'=>93,'node'=>23,'ident'=>77,'term'=>95,'lterm'=>56,'list'=>92}},{ACTIONS=>{";"=>97}},{DEFAULT=>-5},{ACTIONS=>{";"=>-20},DEFAULT=>-27},{DEFAULT=>-78,GOTOS=>{'@5-1'=>98}},{ACTIONS=>{'IDENT'=>99},DEFAULT=>-87,GOTOS=>{'blockargs'=>102,'metadata'=>101,'meta'=>100}},{ACTIONS=>{'IDENT'=>99},GOTOS=>{'metadata'=>103,'meta'=>100}},{ACTIONS=>{'DOT'=>104,'ASSIGN'=>105},DEFAULT=>-109},{ACTIONS=>{"\""=>89,"\$"=>86,'LITERAL'=>88,'FILENAME'=>83,'IDENT'=>81,'NUMBER'=>84},GOTOS=>{'filepart'=>87,'names'=>91,'nameargs'=>106,'filename'=>85,'name'=>82}},{ACTIONS=>{'IDENT'=>107}},{DEFAULT=>-149},{DEFAULT=>-12},{ACTIONS=>{"{"=>30,'LITERAL'=>78,'IDENT'=>108,"\""=>60,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'sterm'=>68,'item'=>39,'loopvar'=>110,'node'=>23,'ident'=>77,'term'=>109,'lterm'=>56}},{DEFAULT=>-40},{DEFAULT=>-127},{DEFAULT=>-6},{ACTIONS=>{"\""=>117,"\$"=>114,'LITERAL'=>116,'FILENAME'=>83,'IDENT'=>111,'NUMBER'=>84,"\${"=>37},GOTOS=>{'names'=>91,'lvalue'=>112,'item'=>113,'name'=>82,'filepart'=>87,'filename'=>85,'nameargs'=>118,'lnameargs'=>115}},{DEFAULT=>-113},{ACTIONS=>{"\$"=>43,'IDENT'=>2,"\${"=>37},GOTOS=>{'item'=>39,'node'=>23,'ident'=>119}},{ACTIONS=>{'LITERAL'=>124,'FILENAME'=>83,'IDENT'=>120,'NUMBER'=>84},DEFAULT=>-87,GOTOS=>{'blockargs'=>123,'filepart'=>87,'filename'=>122,'blockname'=>121,'metadata'=>101,'meta'=>100}},{DEFAULT=>-43},{ACTIONS=>{"\$"=>43,'LITERAL'=>129,'IDENT'=>2,"\${"=>37},DEFAULT=>-119,GOTOS=>{'params'=>128,'hash'=>125,'item'=>126,'param'=>127}},{DEFAULT=>-25},{ACTIONS=>{"\""=>117,"\$"=>114,'LITERAL'=>116,'FILENAME'=>83,'IDENT'=>111,'NUMBER'=>84,"\${"=>37},GOTOS=>{'names'=>91,'lvalue'=>112,'item'=>113,'name'=>82,'filepart'=>87,'filename'=>85,'nameargs'=>118,'lnameargs'=>130}},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-2,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>131,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'try'=>35,'switch'=>34,'assign'=>19,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{DEFAULT=>-22},{DEFAULT=>-24},{ACTIONS=>{"\""=>89,"\$"=>86,'LITERAL'=>88,'FILENAME'=>83,'IDENT'=>81,'NUMBER'=>84},GOTOS=>{'filepart'=>87,'names'=>91,'nameargs'=>132,'filename'=>85,'name'=>82}},{ACTIONS=>{"\""=>60,"\$"=>43,'LITERAL'=>78,'IDENT'=>2,'REF'=>27,'NUMBER'=>26,"\${"=>37},GOTOS=>{'sterm'=>133,'item'=>39,'node'=>23,'ident'=>77}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>134,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{"("=>135},DEFAULT=>-128},{ACTIONS=>{";"=>136}},{DEFAULT=>-38},{DEFAULT=>-11},{ACTIONS=>{'IDENT'=>137}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>138,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>139,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{DEFAULT=>-42},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>140,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{'IF'=>144,'FILTER'=>143,'FOR'=>142,'WHILE'=>146,'WRAPPER'=>145,'UNLESS'=>141}},{DEFAULT=>-39},{DEFAULT=>-10},{ACTIONS=>{"\""=>89,"\$"=>86,'LITERAL'=>88,'FILENAME'=>83,'IDENT'=>81,'NUMBER'=>84},GOTOS=>{'filepart'=>87,'names'=>91,'nameargs'=>147,'filename'=>85,'name'=>82}},{ACTIONS=>{''=>148}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>57,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>151,'sterm'=>68,'item'=>39,'assign'=>150,'node'=>23,'ident'=>149,'term'=>58,'lterm'=>56}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>152,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{"\""=>89,"\$"=>86,'LITERAL'=>88,'FILENAME'=>83,'IDENT'=>81,'NUMBER'=>84},GOTOS=>{'filepart'=>87,'names'=>91,'nameargs'=>153,'filename'=>85,'name'=>82}},{DEFAULT=>-103},{ACTIONS=>{'ASSIGN'=>154},DEFAULT=>-112},{DEFAULT=>-146},{DEFAULT=>-15},{DEFAULT=>-176,GOTOS=>{'quoted'=>155}},{ACTIONS=>{"\""=>89,"\$"=>86,'LITERAL'=>88,'FILENAME'=>83,'IDENT'=>81,'NUMBER'=>84},GOTOS=>{'filepart'=>87,'names'=>91,'nameargs'=>156,'filename'=>85,'name'=>82}},{ACTIONS=>{";"=>-16,"+"=>157,'CAT'=>163,'CMPOP'=>164,"?"=>158,'DIV'=>159,'MOD'=>165,"/"=>166,'AND'=>160,'BINOP'=>161,'OR'=>162},DEFAULT=>-26},{DEFAULT=>-13},{DEFAULT=>-36},{ACTIONS=>{"\""=>89,"\$"=>86,'LITERAL'=>88,'FILENAME'=>83,'IDENT'=>81,'NUMBER'=>84},GOTOS=>{'filepart'=>87,'names'=>91,'nameargs'=>167,'filename'=>85,'name'=>82}},{DEFAULT=>-9},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>168,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{DEFAULT=>-104},{ACTIONS=>{"\$"=>43,'LITERAL'=>75,'IDENT'=>2,"\${"=>37},GOTOS=>{'setlist'=>169,'item'=>39,'assign'=>19,'node'=>23,'ident'=>74}},{ACTIONS=>{"\$"=>43,'COMMA'=>171,'LITERAL'=>75,'IDENT'=>2,"\${"=>37},DEFAULT=>-19,GOTOS=>{'item'=>39,'assign'=>170,'node'=>23,'ident'=>74}},{DEFAULT=>-8},{DEFAULT=>-1},{DEFAULT=>-21},{ACTIONS=>{'ASSIGN'=>172,'DOT'=>104}},{ACTIONS=>{'ASSIGN'=>154}},{ACTIONS=>{'COMMA'=>171,'LITERAL'=>75,'IDENT'=>2,"\$"=>43,"\${"=>37},DEFAULT=>-30,GOTOS=>{'item'=>39,'assign'=>170,'node'=>23,'ident'=>74}},{ACTIONS=>{'DOT'=>104},DEFAULT=>-109},{DEFAULT=>-112},{ACTIONS=>{'CMPOP'=>164,"?"=>158,";"=>173,"+"=>157,'MOD'=>165,'DIV'=>159,"/"=>166,'AND'=>160,'CAT'=>163,'BINOP'=>161,'OR'=>162}},{DEFAULT=>-7},{DEFAULT=>-173},{DEFAULT=>-166},{DEFAULT=>-172},{DEFAULT=>-174},{ACTIONS=>{'DOT'=>174},DEFAULT=>-168},{ACTIONS=>{"\$"=>43,'IDENT'=>2,"\${"=>37},GOTOS=>{'item'=>39,'node'=>23,'ident'=>175}},{DEFAULT=>-171},{DEFAULT=>-169},{DEFAULT=>-176,GOTOS=>{'quoted'=>176}},{DEFAULT=>-35},{ACTIONS=>{"+"=>177,"("=>178},DEFAULT=>-156,GOTOS=>{'args'=>179}},{ACTIONS=>{"{"=>30,'COMMA'=>182,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"]"=>180,"\${"=>37},GOTOS=>{'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>181,'lterm'=>56}},{ACTIONS=>{"]"=>183}},{DEFAULT=>-107},{DEFAULT=>-116},{ACTIONS=>{'TO'=>184},DEFAULT=>-104},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>185,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{ACTIONS=>{";"=>186}},{ACTIONS=>{'ASSIGN'=>187}},{DEFAULT=>-99},{ACTIONS=>{'COMMA'=>189,'IDENT'=>99},DEFAULT=>-86,GOTOS=>{'meta'=>188}},{ACTIONS=>{";"=>190}},{ACTIONS=>{'COMMA'=>189,'IDENT'=>99},DEFAULT=>-17,GOTOS=>{'meta'=>188}},{ACTIONS=>{"\$"=>43,'IDENT'=>2,'NUMBER'=>192,"\${"=>37},GOTOS=>{'item'=>39,'node'=>191}},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'WRAPPER'=>55,'FOR'=>21,'NEXT'=>22,'LITERAL'=>57,"\""=>60,'PROCESS'=>61,'FILTER'=>25,'RETURN'=>64,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>193,'DEFAULT'=>69,"{"=>30,"\${"=>37},GOTOS=>{'item'=>39,'node'=>23,'term'=>58,'loop'=>4,'expr'=>195,'wrapper'=>46,'atomexpr'=>48,'atomdir'=>12,'mdir'=>194,'filter'=>29,'sterm'=>68,'ident'=>149,'perl'=>31,'setlist'=>70,'try'=>35,'switch'=>34,'assign'=>19,'directive'=>196,'condition'=>73,'lterm'=>56}},{DEFAULT=>-33},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'INCLUDE'=>17,"("=>198,'SWITCH'=>54,'WRAPPER'=>55,'FOR'=>21,'NEXT'=>22,'LITERAL'=>57,"\""=>60,'PROCESS'=>61,'FILTER'=>25,'RETURN'=>64,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>193,'DEFAULT'=>69,"{"=>30,"\${"=>37},GOTOS=>{'item'=>39,'node'=>23,'term'=>58,'loop'=>4,'expr'=>199,'wrapper'=>46,'atomexpr'=>48,'atomdir'=>12,'mdir'=>197,'filter'=>29,'sterm'=>68,'ident'=>149,'perl'=>31,'setlist'=>70,'try'=>35,'switch'=>34,'assign'=>19,'directive'=>196,'condition'=>73,'lterm'=>56}},{ACTIONS=>{'IN'=>201,'ASSIGN'=>200},DEFAULT=>-130},{DEFAULT=>-156,GOTOS=>{'args'=>202}},{ACTIONS=>{";"=>203}},{ACTIONS=>{'ASSIGN'=>-130},DEFAULT=>-173},{ACTIONS=>{'ASSIGN'=>204}},{DEFAULT=>-159},{ACTIONS=>{"\$"=>43,'IDENT'=>205,"\${"=>37},GOTOS=>{'item'=>39,'node'=>23,'ident'=>175}},{ACTIONS=>{";"=>206}},{ACTIONS=>{'ASSIGN'=>-161},DEFAULT=>-169},{DEFAULT=>-176,GOTOS=>{'quoted'=>207}},{DEFAULT=>-158},{ACTIONS=>{'DOT'=>104},DEFAULT=>-110},{ACTIONS=>{'ASSIGN'=>187},DEFAULT=>-173},{DEFAULT=>-83},{ACTIONS=>{'DOT'=>174},DEFAULT=>-84},{ACTIONS=>{";"=>208}},{DEFAULT=>-85},{ACTIONS=>{"}"=>209}},{ACTIONS=>{'ASSIGN'=>210}},{DEFAULT=>-122},{ACTIONS=>{"\$"=>43,'COMMA'=>212,'LITERAL'=>129,'IDENT'=>2,"\${"=>37},DEFAULT=>-118,GOTOS=>{'item'=>126,'param'=>211}},{ACTIONS=>{'ASSIGN'=>213}},{DEFAULT=>-73},{DEFAULT=>-4},{ACTIONS=>{";"=>214}},{ACTIONS=>{"}"=>215}},{ACTIONS=>{'DIV'=>159,'BINOP'=>161,"+"=>157,'CAT'=>163,'CMPOP'=>164,'MOD'=>165,"/"=>166},DEFAULT=>-142},{DEFAULT=>-156,GOTOS=>{'args'=>216}},{DEFAULT=>-76,GOTOS=>{'@4-2'=>217}},{DEFAULT=>-132},{ACTIONS=>{'CMPOP'=>164,"?"=>158,";"=>218,"+"=>157,'MOD'=>165,'DIV'=>159,"/"=>166,'AND'=>160,'CAT'=>163,'BINOP'=>161,'OR'=>162}},{ACTIONS=>{"+"=>157,'CAT'=>163,'CMPOP'=>164,"?"=>158,'DIV'=>159,'MOD'=>165,"/"=>166,'AND'=>160,'BINOP'=>161,'OR'=>162},DEFAULT=>-29},{ACTIONS=>{"+"=>157,'CAT'=>163,'CMPOP'=>164,"?"=>158,'DIV'=>159,'MOD'=>165,"/"=>166,'AND'=>160,'BINOP'=>161,'OR'=>162},DEFAULT=>-28},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>219,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{"{"=>30,'LITERAL'=>78,'IDENT'=>108,"\""=>60,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'sterm'=>68,'item'=>39,'loopvar'=>220,'node'=>23,'ident'=>77,'term'=>109,'lterm'=>56}},{ACTIONS=>{"\""=>117,"\$"=>114,'LITERAL'=>116,'FILENAME'=>83,'IDENT'=>111,'NUMBER'=>84,"\${"=>37},GOTOS=>{'names'=>91,'lvalue'=>112,'item'=>113,'name'=>82,'filepart'=>87,'filename'=>85,'nameargs'=>118,'lnameargs'=>221}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>222,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{"\""=>89,"\$"=>86,'LITERAL'=>88,'FILENAME'=>83,'IDENT'=>81,'NUMBER'=>84},GOTOS=>{'filepart'=>87,'names'=>91,'nameargs'=>223,'filename'=>85,'name'=>82}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>224,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{DEFAULT=>-41},{DEFAULT=>0},{ACTIONS=>{'DOT'=>104,'ASSIGN'=>172},DEFAULT=>-109},{ACTIONS=>{")"=>225}},{ACTIONS=>{'CMPOP'=>164,"?"=>158,"+"=>157,'MOD'=>165,'DIV'=>159,"/"=>166,'AND'=>160,'CAT'=>163,'BINOP'=>161,")"=>226,'OR'=>162}},{ACTIONS=>{'CMPOP'=>164,"?"=>158,";"=>227,"+"=>157,'MOD'=>165,'DIV'=>159,"/"=>166,'AND'=>160,'CAT'=>163,'BINOP'=>161,'OR'=>162}},{ACTIONS=>{";"=>228}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>229,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{"\""=>234,'TEXT'=>231,";"=>233,"\$"=>43,'IDENT'=>2,"\${"=>37},GOTOS=>{'item'=>39,'node'=>23,'ident'=>230,'quotable'=>232}},{DEFAULT=>-34},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>235,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>236,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>237,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>238,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>239,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>240,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>241,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>242,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>243,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>244,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{DEFAULT=>-32},{ACTIONS=>{'CMPOP'=>164,"?"=>158,";"=>245,"+"=>157,'MOD'=>165,'DIV'=>159,"/"=>166,'AND'=>160,'CAT'=>163,'BINOP'=>161,'OR'=>162}},{ACTIONS=>{'COMMA'=>171,'LITERAL'=>75,'IDENT'=>2,"\$"=>43,"\${"=>37},DEFAULT=>-31,GOTOS=>{'item'=>39,'assign'=>170,'node'=>23,'ident'=>74}},{DEFAULT=>-147},{DEFAULT=>-148},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>246,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>247,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{ACTIONS=>{'FILENAME'=>83,'IDENT'=>81,'NUMBER'=>84},GOTOS=>{'filepart'=>248}},{ACTIONS=>{'DOT'=>104},DEFAULT=>-156,GOTOS=>{'args'=>249}},{ACTIONS=>{"\""=>250,'TEXT'=>231,";"=>233,"\$"=>43,'IDENT'=>2,"\${"=>37},GOTOS=>{'item'=>39,'node'=>23,'ident'=>230,'quotable'=>232}},{ACTIONS=>{"\""=>89,'LITERAL'=>88,'FILENAME'=>83,'IDENT'=>81,'NUMBER'=>84},GOTOS=>{'filepart'=>87,'filename'=>85,'name'=>251}},{DEFAULT=>-156,GOTOS=>{'args'=>252}},{ACTIONS=>{'NOT'=>38,'LITERAL'=>256,'IDENT'=>2,"\""=>60,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"{"=>30,'COMMA'=>258,"("=>53,"\${"=>37},DEFAULT=>-163,GOTOS=>{'expr'=>257,'sterm'=>68,'item'=>254,'param'=>255,'node'=>23,'ident'=>253,'term'=>58,'lterm'=>56}},{DEFAULT=>-105},{DEFAULT=>-114},{DEFAULT=>-115},{DEFAULT=>-106},{ACTIONS=>{"\""=>60,"\$"=>43,'LITERAL'=>78,'IDENT'=>2,'REF'=>27,'NUMBER'=>26,"\${"=>37},GOTOS=>{'sterm'=>259,'item'=>39,'node'=>23,'ident'=>77}},{ACTIONS=>{'FINAL'=>260,'CATCH'=>262},DEFAULT=>-72,GOTOS=>{'final'=>261}},{ACTIONS=>{'TEXT'=>263}},{ACTIONS=>{"\""=>266,'LITERAL'=>265,'NUMBER'=>264}},{DEFAULT=>-97},{DEFAULT=>-98},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'loop'=>4,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'atomdir'=>12,'anonblock'=>50,'template'=>267,'defblockname'=>14,'ident'=>16,'assign'=>19,'macro'=>20,'lterm'=>56,'node'=>23,'term'=>58,'rawperl'=>59,'expr'=>62,'use'=>63,'defblock'=>66,'filter'=>29,'sterm'=>68,'perl'=>31,'chunks'=>33,'setlist'=>70,'switch'=>34,'try'=>35,'directive'=>71,'block'=>72,'condition'=>73}},{DEFAULT=>-125},{DEFAULT=>-126},{ACTIONS=>{";"=>268}},{DEFAULT=>-89},{ACTIONS=>{";"=>-150,"+"=>157,'LITERAL'=>-150,'IDENT'=>-150,'CAT'=>163,"\$"=>-150,'CMPOP'=>164,"?"=>158,'DIV'=>159,'MOD'=>165,'COMMA'=>-150,"/"=>166,'AND'=>160,'BINOP'=>161,'OR'=>162,"\${"=>-150},DEFAULT=>-26},{DEFAULT=>-92},{DEFAULT=>-91},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>57,'IDENT'=>269,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>151,'sterm'=>68,'item'=>39,'assign'=>150,'margs'=>270,'node'=>23,'ident'=>149,'term'=>58,'lterm'=>56}},{ACTIONS=>{"+"=>157,'CAT'=>163,'CMPOP'=>164,"?"=>158,'DIV'=>159,'MOD'=>165,"/"=>166,'AND'=>160,'BINOP'=>161,'OR'=>162},DEFAULT=>-26},{ACTIONS=>{"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>271,'lterm'=>56}},{ACTIONS=>{"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>272,'lterm'=>56}},{ACTIONS=>{'NOT'=>38,"{"=>30,'COMMA'=>258,'LITERAL'=>256,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},DEFAULT=>-64,GOTOS=>{'expr'=>257,'sterm'=>68,'item'=>254,'param'=>255,'node'=>23,'ident'=>253,'term'=>58,'lterm'=>56}},{DEFAULT=>-56,GOTOS=>{'@1-3'=>273}},{ACTIONS=>{"\""=>89,"\$"=>86,'LITERAL'=>88,'FILENAME'=>83,'IDENT'=>81,'NUMBER'=>84},GOTOS=>{'filepart'=>87,'names'=>91,'nameargs'=>274,'filename'=>85,'name'=>82}},{ACTIONS=>{'ASSIGN'=>-132},DEFAULT=>-130},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>275,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{ACTIONS=>{"\""=>276,'TEXT'=>231,";"=>233,"\$"=>43,'IDENT'=>2,"\${"=>37},GOTOS=>{'item'=>39,'node'=>23,'ident'=>230,'quotable'=>232}},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>277,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{DEFAULT=>-108},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>278,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{DEFAULT=>-120},{DEFAULT=>-121},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>279,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{DEFAULT=>-74,GOTOS=>{'@3-3'=>280}},{DEFAULT=>-131},{ACTIONS=>{'NOT'=>38,"{"=>30,'COMMA'=>258,'LITERAL'=>256,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,")"=>281,"\${"=>37},GOTOS=>{'expr'=>257,'sterm'=>68,'item'=>254,'param'=>255,'node'=>23,'ident'=>253,'term'=>58,'lterm'=>56}},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>282,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>283,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{ACTIONS=>{'CMPOP'=>164,"?"=>158,"+"=>157,'MOD'=>165,'DIV'=>159,"/"=>166,'AND'=>160,'CAT'=>163,'BINOP'=>161,'OR'=>162},DEFAULT=>-47},{DEFAULT=>-58},{DEFAULT=>-81},{ACTIONS=>{'CMPOP'=>164,"?"=>158,"+"=>157,'MOD'=>165,'DIV'=>159,"/"=>166,'AND'=>160,'CAT'=>163,'BINOP'=>161,'OR'=>162},DEFAULT=>-45},{DEFAULT=>-66},{ACTIONS=>{'CMPOP'=>164,"?"=>158,"+"=>157,'MOD'=>165,'DIV'=>159,"/"=>166,'AND'=>160,'CAT'=>163,'BINOP'=>161,'OR'=>162},DEFAULT=>-61},{DEFAULT=>-144},{DEFAULT=>-145},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>284,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>285,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{ACTIONS=>{"+"=>157,'CAT'=>163,'CMPOP'=>164,"?"=>158,'DIV'=>159,'MOD'=>165,"/"=>166,'AND'=>160,'BINOP'=>161,'OR'=>162},DEFAULT=>-151},{ACTIONS=>{'DOT'=>104},DEFAULT=>-177},{DEFAULT=>-178},{DEFAULT=>-175},{DEFAULT=>-179},{DEFAULT=>-111},{ACTIONS=>{'DIV'=>159,'MOD'=>165,"/"=>166},DEFAULT=>-135},{ACTIONS=>{":"=>286,'CMPOP'=>164,"?"=>158,"+"=>157,'MOD'=>165,'DIV'=>159,"/"=>166,'AND'=>160,'CAT'=>163,'BINOP'=>161,'OR'=>162}},{ACTIONS=>{'MOD'=>165},DEFAULT=>-136},{ACTIONS=>{'DIV'=>159,'BINOP'=>161,"+"=>157,'CAT'=>163,'CMPOP'=>164,'MOD'=>165,"/"=>166},DEFAULT=>-140},{ACTIONS=>{'DIV'=>159,"+"=>157,'MOD'=>165,"/"=>166},DEFAULT=>-133},{ACTIONS=>{'DIV'=>159,'BINOP'=>161,"+"=>157,'CAT'=>163,'CMPOP'=>164,'MOD'=>165,"/"=>166},DEFAULT=>-141},{ACTIONS=>{'DIV'=>159,'BINOP'=>161,"+"=>157,'CMPOP'=>164,'MOD'=>165,"/"=>166},DEFAULT=>-139},{ACTIONS=>{'DIV'=>159,'BINOP'=>161,"+"=>157,'MOD'=>165,"/"=>166},DEFAULT=>-138},{DEFAULT=>-137},{ACTIONS=>{'DIV'=>159,'MOD'=>165},DEFAULT=>-134},{DEFAULT=>-59,GOTOS=>{'@2-3'=>287}},{ACTIONS=>{"+"=>157,'CAT'=>163,'CMPOP'=>164,"?"=>158,'DIV'=>159,'MOD'=>165,"/"=>166,'AND'=>160,'BINOP'=>161,'OR'=>162},DEFAULT=>-150},{ACTIONS=>{'ELSIF'=>290,'ELSE'=>288},DEFAULT=>-50,GOTOS=>{'else'=>289}},{DEFAULT=>-170},{ACTIONS=>{'NOT'=>38,'LITERAL'=>256,'IDENT'=>2,"\""=>60,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"{"=>30,'COMMA'=>258,"("=>53,"\${"=>37},DEFAULT=>-162,GOTOS=>{'expr'=>257,'sterm'=>68,'item'=>254,'param'=>255,'node'=>23,'ident'=>253,'term'=>58,'lterm'=>56}},{DEFAULT=>-167},{DEFAULT=>-165},{ACTIONS=>{'NOT'=>38,"{"=>30,'COMMA'=>258,'LITERAL'=>256,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,")"=>291,"\${"=>37},GOTOS=>{'expr'=>257,'sterm'=>68,'item'=>254,'param'=>255,'node'=>23,'ident'=>253,'term'=>58,'lterm'=>56}},{ACTIONS=>{'DOT'=>104,'ASSIGN'=>292},DEFAULT=>-109},{ACTIONS=>{"("=>135,'ASSIGN'=>210},DEFAULT=>-128},{DEFAULT=>-153},{ACTIONS=>{'ASSIGN'=>213},DEFAULT=>-112},{ACTIONS=>{"+"=>157,'CAT'=>163,'CMPOP'=>164,"?"=>158,'DIV'=>159,'MOD'=>165,"/"=>166,'AND'=>160,'BINOP'=>161,'OR'=>162},DEFAULT=>-152},{DEFAULT=>-155},{DEFAULT=>-117},{ACTIONS=>{";"=>293}},{ACTIONS=>{'END'=>294}},{ACTIONS=>{";"=>296,'DEFAULT'=>297,'FILENAME'=>83,'IDENT'=>81,'NUMBER'=>84},GOTOS=>{'filepart'=>87,'filename'=>295}},{ACTIONS=>{'END'=>298}},{DEFAULT=>-102},{DEFAULT=>-100},{ACTIONS=>{'TEXT'=>299}},{ACTIONS=>{'END'=>300}},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>301,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{ACTIONS=>{'IDENT'=>-96,")"=>-96,'COMMA'=>-96},DEFAULT=>-130},{ACTIONS=>{'COMMA'=>304,'IDENT'=>302,")"=>303}},{DEFAULT=>-156,GOTOS=>{'args'=>305}},{DEFAULT=>-156,GOTOS=>{'args'=>306}},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>307,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{DEFAULT=>-157},{ACTIONS=>{'END'=>308}},{ACTIONS=>{'ASSIGN'=>-160},DEFAULT=>-167},{ACTIONS=>{'END'=>309}},{ACTIONS=>{'DIV'=>159,'AND'=>160,'BINOP'=>161,'OR'=>162,"+"=>157,'CAT'=>163,'CMPOP'=>164,"?"=>158,'MOD'=>165,"/"=>166},DEFAULT=>-124},{ACTIONS=>{'DIV'=>159,'AND'=>160,'BINOP'=>161,'OR'=>162,"+"=>157,'CAT'=>163,'CMPOP'=>164,"?"=>158,'MOD'=>165,"/"=>166},DEFAULT=>-123},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>310,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{DEFAULT=>-129},{ACTIONS=>{'END'=>311}},{ACTIONS=>{'ELSIF'=>290,'ELSE'=>288},DEFAULT=>-50,GOTOS=>{'else'=>312}},{ACTIONS=>{'CASE'=>313},DEFAULT=>-55,GOTOS=>{'case'=>314}},{ACTIONS=>{'END'=>315}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>316,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>317,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{ACTIONS=>{";"=>318}},{ACTIONS=>{'END'=>319}},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>320,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{DEFAULT=>-164},{ACTIONS=>{'NOT'=>38,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'expr'=>321,'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>58,'lterm'=>56}},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>322,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{DEFAULT=>-67},{ACTIONS=>{'DOT'=>174,";"=>323}},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>324,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{ACTIONS=>{";"=>325}},{DEFAULT=>-79},{ACTIONS=>{"\""=>326}},{DEFAULT=>-82},{ACTIONS=>{'END'=>327}},{DEFAULT=>-94},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'WRAPPER'=>55,'FOR'=>21,'NEXT'=>22,'LITERAL'=>57,"\""=>60,'PROCESS'=>61,'FILTER'=>25,'RETURN'=>64,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>193,'DEFAULT'=>69,"{"=>30,"\${"=>37},GOTOS=>{'item'=>39,'node'=>23,'term'=>58,'loop'=>4,'expr'=>199,'wrapper'=>46,'atomexpr'=>48,'atomdir'=>12,'mdir'=>328,'filter'=>29,'sterm'=>68,'ident'=>149,'perl'=>31,'setlist'=>70,'try'=>35,'switch'=>34,'assign'=>19,'directive'=>196,'condition'=>73,'lterm'=>56}},{DEFAULT=>-95},{ACTIONS=>{'NOT'=>38,"{"=>30,'COMMA'=>258,'LITERAL'=>256,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},DEFAULT=>-62,GOTOS=>{'expr'=>257,'sterm'=>68,'item'=>254,'param'=>255,'node'=>23,'ident'=>253,'term'=>58,'lterm'=>56}},{ACTIONS=>{'NOT'=>38,"{"=>30,'COMMA'=>258,'LITERAL'=>256,'IDENT'=>2,"\""=>60,"("=>53,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},DEFAULT=>-63,GOTOS=>{'expr'=>257,'sterm'=>68,'item'=>254,'param'=>255,'node'=>23,'ident'=>253,'term'=>58,'lterm'=>56}},{ACTIONS=>{'END'=>329}},{DEFAULT=>-80},{DEFAULT=>-88},{ACTIONS=>{'END'=>330}},{DEFAULT=>-77},{ACTIONS=>{'END'=>331}},{ACTIONS=>{";"=>332,'DEFAULT'=>334,"{"=>30,'LITERAL'=>78,'IDENT'=>2,"\""=>60,"\$"=>43,"["=>9,'NUMBER'=>26,'REF'=>27,"\${"=>37},GOTOS=>{'sterm'=>68,'item'=>39,'node'=>23,'ident'=>77,'term'=>333,'lterm'=>56}},{ACTIONS=>{'END'=>335}},{DEFAULT=>-65},{ACTIONS=>{'DIV'=>159,'AND'=>160,'BINOP'=>161,'OR'=>162,"+"=>157,'CAT'=>163,'CMPOP'=>164,"?"=>158,'MOD'=>165,"/"=>166},DEFAULT=>-143},{ACTIONS=>{'END'=>336}},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>337,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{DEFAULT=>-46},{ACTIONS=>{'CMPOP'=>164,"?"=>158,";"=>338,"+"=>157,'MOD'=>165,'DIV'=>159,"/"=>166,'AND'=>160,'CAT'=>163,'BINOP'=>161,'OR'=>162}},{ACTIONS=>{"+"=>157,'CAT'=>163,'CMPOP'=>164,"?"=>158,'DIV'=>159,'MOD'=>165,"/"=>166,'AND'=>160,'BINOP'=>161,'OR'=>162},DEFAULT=>-154},{DEFAULT=>-71},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>339,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{ACTIONS=>{'FINAL'=>260,'CATCH'=>262},DEFAULT=>-72,GOTOS=>{'final'=>340}},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>341,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{DEFAULT=>-101},{DEFAULT=>-93},{DEFAULT=>-90},{DEFAULT=>-57},{DEFAULT=>-75},{DEFAULT=>-44},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>342,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{ACTIONS=>{";"=>343}},{ACTIONS=>{";"=>344}},{DEFAULT=>-51},{DEFAULT=>-60},{DEFAULT=>-49},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>345,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{ACTIONS=>{'FINAL'=>260,'CATCH'=>262},DEFAULT=>-72,GOTOS=>{'final'=>346}},{DEFAULT=>-70},{ACTIONS=>{'FINAL'=>260,'CATCH'=>262},DEFAULT=>-72,GOTOS=>{'final'=>347}},{DEFAULT=>-54},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>348,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{ACTIONS=>{'SET'=>1,'PERL'=>40,'NOT'=>38,'IDENT'=>2,'CLEAR'=>41,'UNLESS'=>3,'IF'=>44,"\$"=>43,'STOP'=>6,'CALL'=>45,'THROW'=>8,'GET'=>47,"["=>9,'TRY'=>10,'LAST'=>49,'DEBUG'=>51,'RAWPERL'=>13,'META'=>15,'INCLUDE'=>17,"("=>53,'SWITCH'=>54,'MACRO'=>18,'WRAPPER'=>55,";"=>-18,'FOR'=>21,'LITERAL'=>57,'NEXT'=>22,"\""=>60,'TEXT'=>24,'PROCESS'=>61,'RETURN'=>64,'FILTER'=>25,'INSERT'=>65,'NUMBER'=>26,'REF'=>27,'WHILE'=>67,'BLOCK'=>28,'DEFAULT'=>69,"{"=>30,'USE'=>32,'VIEW'=>36,"\${"=>37},DEFAULT=>-3,GOTOS=>{'item'=>39,'node'=>23,'rawperl'=>59,'term'=>58,'loop'=>4,'use'=>63,'expr'=>62,'capture'=>42,'statement'=>5,'view'=>7,'wrapper'=>46,'atomexpr'=>48,'chunk'=>11,'defblock'=>66,'atomdir'=>12,'anonblock'=>50,'sterm'=>68,'defblockname'=>14,'filter'=>29,'ident'=>16,'perl'=>31,'setlist'=>70,'chunks'=>33,'try'=>35,'switch'=>34,'assign'=>19,'block'=>349,'directive'=>71,'macro'=>20,'condition'=>73,'lterm'=>56}},{ACTIONS=>{'ELSIF'=>290,'ELSE'=>288},DEFAULT=>-50,GOTOS=>{'else'=>350}},{DEFAULT=>-68},{DEFAULT=>-69},{ACTIONS=>{'CASE'=>313},DEFAULT=>-55,GOTOS=>{'case'=>351}},{DEFAULT=>-53},{DEFAULT=>-48},{DEFAULT=>-52}];$RULES=[['$start',2,undef],['template',1,sub{$factory->template($_[1])}],['block',1,sub{$factory->block($_[1])}],['block',0,sub{$factory->block()}],['chunks',2,sub{push(@{$_[1]},$_[2])if defined$_[2];$_[1]}],['chunks',1,sub{defined$_[1]?[$_[1]]:[]}],['chunk',1,sub{$factory->textblock($_[1])}],['chunk',2,sub{return ''unless$_[1];$_[0]->location().$_[1];}],['statement',1,undef],['statement',1,undef],['statement',1,undef],['statement',1,undef],['statement',1,undef],['statement',1,undef],['statement',1,undef],['statement',1,undef],['statement',1,sub{$factory->get($_[1])}],['statement',2,sub{$_[0]->add_metadata($_[2]);}],['statement',0,undef],['directive',1,sub{$factory->set($_[1])}],['directive',1,undef],['directive',1,undef],['directive',1,undef],['directive',1,undef],['directive',1,undef],['directive',1,undef],['atomexpr',1,sub{$factory->get($_[1])}],['atomexpr',1,undef],['atomdir',2,sub{$factory->get($_[2])}],['atomdir',2,sub{$factory->call($_[2])}],['atomdir',2,sub{$factory->set($_[2])}],['atomdir',2,sub{$factory->default($_[2])}],['atomdir',2,sub{$factory->insert($_[2])}],['atomdir',2,sub{$factory->include($_[2])}],['atomdir',2,sub{$factory->process($_[2])}],['atomdir',2,sub{$factory->throw($_[2])}],['atomdir',1,sub{$factory->return()}],['atomdir',1,sub{$factory->stop()}],['atomdir',1,sub{"\$output = '';";}],['atomdir',1,sub{$_[0]->block_label('last ',';')}],['atomdir',1,sub{$_[0]->in_block('FOR')?$factory->next($_[0]->block_label):$_[0]->block_label('next ',';')}],['atomdir',2,sub{if($_[2]->[0]->[0]=~/^'(on|off)'$/){$_[0]->{DEBUG_DIRS}=($1 eq 'on');$factory->debug($_[2]);}else{$_[0]->{DEBUG_DIRS}?$factory->debug($_[2]):'';}}],['atomdir',1,undef],['atomdir',1,undef],['condition',6,sub{$factory->if(@_[2,4,5])}],['condition',3,sub{$factory->if(@_[3,1])}],['condition',6,sub{$factory->if("!($_[2])",@_[4,5])}],['condition',3,sub{$factory->if("!($_[3])",$_[1])}],['else',5,sub{unshift(@{$_[5]},[@_[2,4]]);$_[5];}],['else',3,sub{[$_[3]]}],['else',0,sub{[undef]}],['switch',6,sub{$factory->switch(@_[2,5])}],['case',5,sub{unshift(@{$_[5]},[@_[2,4]]);$_[5];}],['case',4,sub{[$_[4]]}],['case',3,sub{[$_[3]]}],['case',0,sub{[undef]}],['@1-3',0,sub{$_[0]->enter_block('FOR')}],['loop',6,sub{$factory->foreach(@{$_[2]},$_[5],$_[0]->leave_block)}],['loop',3,sub{$factory->foreach(@{$_[3]},$_[1])}],['@2-3',0,sub{$_[0]->enter_block('WHILE')}],['loop',6,sub{$factory->while(@_[2,5],$_[0]->leave_block)}],['loop',3,sub{$factory->while(@_[3,1])}],['loopvar',4,sub{[@_[1,3,4]]}],['loopvar',4,sub{[@_[1,3,4]]}],['loopvar',2,sub{[0,@_[1,2]]}],['wrapper',5,sub{$factory->wrapper(@_[2,4])}],['wrapper',3,sub{$factory->wrapper(@_[3,1])}],['try',5,sub{$factory->try(@_[3,4])}],['final',5,sub{unshift(@{$_[5]},[@_[2,4]]);$_[5];}],['final',5,sub{unshift(@{$_[5]},[undef,$_[4]]);$_[5];}],['final',4,sub{unshift(@{$_[4]},[undef,$_[3]]);$_[4];}],['final',3,sub{[$_[3]]}],['final',0,sub{[0]}],['use',2,sub{$factory->use($_[2])}],['@3-3',0,sub{$_[0]->push_defblock();}],['view',6,sub{$factory->view(@_[2,5],$_[0]->pop_defblock)}],['@4-2',0,sub{${$_[0]->{INPERL}}++;}],['perl',5,sub{${$_[0]->{INPERL}}--;$_[0]->{EVAL_PERL}?$factory->perl($_[4]):$factory->no_perl();}],['@5-1',0,sub{${$_[0]->{INPERL}}++;$rawstart=${$_[0]->{'LINE'}};}],['rawperl',5,sub{${$_[0]->{INPERL}}--;$_[0]->{EVAL_PERL}?$factory->rawperl($_[4],$rawstart):$factory->no_perl();}],['filter',5,sub{$factory->filter(@_[2,4])}],['filter',3,sub{$factory->filter(@_[3,1])}],['defblock',5,sub{my$name=join('/',@{$_[0]->{DEFBLOCKS}});pop(@{$_[0]->{DEFBLOCKS}});$_[0]->define_block($name,$_[4]);undef}],['defblockname',2,sub{push(@{$_[0]->{DEFBLOCKS}},$_[2]);$_[2];}],['blockname',1,undef],['blockname',1,sub{$_[1]=~s/^'(.*)'$/$1/;$_[1]}],['blockargs',1,undef],['blockargs',0,undef],['anonblock',5,sub{local$"=', ';print STDERR"experimental block args: [@{ $_[2] }]\n"if$_[2];$factory->anon_block($_[4])}],['capture',3,sub{$factory->capture(@_[1,3])}],['macro',6,sub{$factory->macro(@_[2,6,4])}],['macro',3,sub{$factory->macro(@_[2,3])}],['mdir',1,undef],['mdir',4,sub{$_[3]}],['margs',2,sub{push(@{$_[1]},$_[2]);$_[1]}],['margs',2,sub{$_[1]}],['margs',1,sub{[$_[1]]}],['metadata',2,sub{push(@{$_[1]},@{$_[2]});$_[1]}],['metadata',2,undef],['metadata',1,undef],['meta',3,sub{for($_[3]){s/^'//;s/'$//;s/\\'/'/g};[@_[1,3]]}],['meta',5,sub{[@_[1,4]]}],['meta',3,sub{[@_[1,3]]}],['term',1,undef],['term',1,undef],['lterm',3,sub{"[ $_[2] ]"}],['lterm',3,sub{"[ $_[2] ]"}],['lterm',2,sub{"[ ]"}],['lterm',3,sub{"{ $_[2]  }"}],['sterm',1,sub{$factory->ident($_[1])}],['sterm',2,sub{$factory->identref($_[2])}],['sterm',3,sub{$factory->quoted($_[2])}],['sterm',1,undef],['sterm',1,undef],['list',2,sub{"$_[1], $_[2]"}],['list',2,undef],['list',1,undef],['range',3,sub{$_[1].'..'.$_[3]}],['hash',1,undef],['hash',0,sub{""}],['params',2,sub{"$_[1], $_[2]"}],['params',2,undef],['params',1,undef],['param',3,sub{"$_[1] => $_[3]"}],['param',3,sub{"$_[1] => $_[3]"}],['ident',3,sub{push(@{$_[1]},@{$_[3]});$_[1]}],['ident',3,sub{push(@{$_[1]},map{($_,0)}split(/\./,$_[3]));$_[1];}],['ident',1,undef],['node',1,sub{[$_[1],0]}],['node',4,sub{[$_[1],$factory->args($_[3])]}],['item',1,sub{"'$_[1]'"}],['item',3,sub{$_[2]}],['item',2,sub{$_[0]->{V1DOLLAR}?"'$_[2]'":$factory->ident(["'$_[2]'",0])}],['expr',3,sub{"$_[1] $_[2] $_[3]"}],['expr',3,sub{"$_[1] $_[2] $_[3]"}],['expr',3,sub{"$_[1] $_[2] $_[3]"}],['expr',3,sub{"int($_[1] / $_[3])"}],['expr',3,sub{"$_[1] % $_[3]"}],['expr',3,sub{"$_[1] $CMPOP{ $_[2] } $_[3]"}],['expr',3,sub{"$_[1]  . $_[3]"}],['expr',3,sub{"$_[1] && $_[3]"}],['expr',3,sub{"$_[1] || $_[3]"}],['expr',2,sub{"! $_[2]"}],['expr',5,sub{"$_[1] ? $_[3] : $_[5]"}],['expr',3,sub{$factory->assign(@{$_[2]})}],['expr',3,sub{"($_[2])"}],['expr',1,undef],['setlist',2,sub{push(@{$_[1]},@{$_[2]});$_[1]}],['setlist',2,undef],['setlist',1,undef],['assign',3,sub{[$_[1],$_[3]]}],['assign',3,sub{[@_[1,3]]}],['args',2,sub{push(@{$_[1]},$_[2]);$_[1]}],['args',2,sub{push(@{$_[1]->[0]},$_[2]);$_[1]}],['args',4,sub{push(@{$_[1]->[0]},"'', ".$factory->assign(@_[2,4]));$_[1]}],['args',2,sub{$_[1]}],['args',0,sub{[[]]}],['lnameargs',3,sub{push(@{$_[3]},$_[1]);$_[3]}],['lnameargs',1,undef],['lvalue',1,undef],['lvalue',3,sub{$factory->quoted($_[2])}],['lvalue',1,undef],['nameargs',3,sub{[[$factory->ident($_[2])],$_[3]]}],['nameargs',2,sub{[@_[1,2]]}],['nameargs',4,sub{[@_[1,3]]}],['names',3,sub{push(@{$_[1]},$_[3]);$_[1]}],['names',1,sub{[$_[1]]}],['name',3,sub{$factory->quoted($_[2])}],['name',1,sub{"'$_[1]'"}],['name',1,undef],['filename',3,sub{"$_[1].$_[3]"}],['filename',1,undef],['filepart',1,undef],['filepart',1,undef],['filepart',1,undef],['quoted',2,sub{push(@{$_[1]},$_[2])if defined$_[2];$_[1]}],['quoted',0,sub{[]}],['quotable',1,sub{$factory->ident($_[1])}],['quotable',1,sub{$factory->text($_[1])}],['quotable',1,sub{undef}]];1;__END__
