#============================================================================================================
#
#	VXeǗ - f W[
#
#============================================================================================================
package	MODULE;

use strict;
use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'LOG'	=> [],
	};
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	\\bh
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@param	$Form	SAMWISE
#	@param	$CGI	ǗVXe
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub DoPrint
{
	my $this = shift;
	my ($Sys, $Form, $CGI) = @_;
	
	# Ǘ}X^IuWFNg̐
	require './mordor/sauron.pl';
	my $Base = SAURON->new;
	$Base->Create($Sys, $Form);
	
	my $subMode = $Form->Get('MODE_SUB');
	
	# j[̐ݒ
	SetMenuList($Base, $CGI);
	
	my $indata = undef;
	
	# fꗗ
	if ($subMode eq 'LIST') {
		$indata = PreparePageBBSList($Sys, $Form);
	}
	# f쐬
	elsif ($subMode eq 'CREATE') {
		$indata = PreparePageBBSCreate($Sys, $Form);
	}
	# f폜mF
	elsif ($subMode eq 'DELETE') {
		$indata = PreparePageBBSDelete($Sys, $Form);
	}
	# fJeSύX
	elsif ($subMode eq 'CATCHANGE') {
		$indata = PreparePageBBScategoryChange($Sys, $Form);
	}
	# JeSꗗ
	elsif ($subMode eq 'CATEGORY') {
		$indata = PreparePageCategoryList($Sys, $Form);
	}
	# JeSǉ
	elsif ($subMode eq 'CATEGORYADD') {
		$indata = PreparePageCategoryAdd($Sys, $Form);
	}
	# JeS폜
	elsif ($subMode eq 'CATEGORYDEL') {
		$indata = PreparePageCategoryDelete($Sys, $Form);
	}
	# 
	elsif ($subMode eq 'COMPLETE') {
		$indata = $Base->PreparePageComplete('f', $this->{'LOG'});
	}
	# VXeݒ莸s
	elsif ($subMode eq 'FALSE') {
		$indata = $Base->PreparePageError($this->{'LOG'});
	}
	
	$Base->Print($Sys->Get('_TITLE'), 1, $indata);
}

#------------------------------------------------------------------------------------------------------------
#
#	@\\bh
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@param	$Form	SAMWISE
#	@param	$CGI	ǗVXe
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub DoFunction
{
	my $this = shift;
	my ($Sys, $Form, $CGI) = @_;
	
	my $subMode = $Form->Get('MODE_SUB');
	my $err = 0;
	
	# f쐬
	if ($subMode eq 'CREATE') {
		$err = FunctionBBSCreate($Sys, $Form, $this->{'LOG'});
	}
	# f폜
	elsif ($subMode eq 'DELETE') {
		$err = FunctionBBSDelete($Sys, $Form, $this->{'LOG'});
	}
	# JeSύX
	elsif ($subMode eq 'CATCHANGE') {
		$err = FunctionCategoryChange($Sys, $Form, $this->{'LOG'});
	}
	# JeSǉ
	elsif ($subMode eq 'CATADD') {
		$err = FunctionCategoryAdd($Sys, $Form, $this->{'LOG'});
	}
	# JeS폜
	elsif ($subMode eq 'CATDEL') {
		$err = FunctionCategoryDelete($Sys, $Form, $this->{'LOG'});
	}
	# fXV
	elsif ($subMode eq 'UPDATE') {
		$err = FunctionBBSInfoUpdate($Sys, $Form, $this->{'LOG'});
	}
	# fXV
	elsif ($subMode eq 'UPDATEBBS') {
		$err = FunctionBBSUpdate($Sys, $Form, $this->{'LOG'});
	}
	
	# ʕ\
	if ($err) {
		$CGI->{'LOGGER'}->Put($Form->Get('UserName'), "BBS($subMode)", "ERROR:$err");
		push @{$this->{'LOG'}}, $err;
		$Form->Set('MODE_SUB', 'FALSE');
	}
	else {
		$CGI->{'LOGGER'}->Put($Form->Get('UserName'), "BBS($subMode)", 'COMPLETE');
		$Form->Set('MODE_SUB', 'COMPLETE');
	}
	
	$this->DoPrint($Sys, $Form, $CGI);
}

#------------------------------------------------------------------------------------------------------------
#
#	j[Xgݒ
#	-------------------------------------------------------------------------------------
#	@param	$Base	SAURON
#	@param	$CGI	
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub SetMenuList
{
	my ($Base, $CGI) = @_;
	
	$Base->SetMenu('fꗗ', "'sys.bbs','DISP','LIST'");
	
	# VXeǗ̂
	if ($CGI->{'SECINFO'}->IsAuthority($CGI->{'USER'}, $ZP::AUTH_SYSADMIN, '*')) {
		$Base->SetMenu('f쐬', "'sys.bbs','DISP','CREATE'");
		$Base->SetMenu('', '');
		$Base->SetMenu('fJeSꗗ', "'sys.bbs','DISP','CATEGORY'");
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	fꗗ̕\
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PreparePageBBSList
{
	my ($Sys, $Form) = @_;
	
	my $Sec = $Sys->Get('ADMIN')->{'SECINFO'};
	my $cuser = $Sys->Get('ADMIN')->{'USER'};
	
	require './module/nazguls.pl';
	my $Boards = NAZGUL->new;
	my $Category = ANGMAR->new;
	$Boards->Load($Sys);
	$Category->Load($Sys);
	
	# JeSXgo
	my $categories = [];
	my @catSet = ();
	$Category->GetKeySet(\@catSet);
	foreach my $id (sort @catSet) {
		push @$categories, {
			'id'	=> $id,
			'name'	=> $Category->Get('NAME', $id),
		};
	}
	
	# [UBBSꗗ擾
	my @belongBoard = ();
	$Sec->GetBelongBBSList($cuser, $Boards, \@belongBoard);
	
	# f擾
	my @bbsSet = ();
	my $scat = $Form->Get('BBS_CATEGORY', '');
	my $subtitle = '';
	if ($scat eq '' || $scat eq 'ALL') {
		$Boards->GetKeySet('ALL', '', \@bbsSet);
	}
	else {
		$Boards->GetKeySet('CATEGORY', $scat, \@bbsSet);
		$subtitle = $Category->Get('NAME',$scat);
	}
	
	# fXgo
	my $boards = [];
	foreach my $id (sort @bbsSet) {
		# f̂ݕ\
		foreach (@belongBoard) {
			next if ($id ne $_);
			push @$boards, {
				'id'		=> $id,
				'name'		=> $Boards->Get('NAME', $id),
				'subject'	=> $Boards->Get('SUBJECT', $id),
				'category'	=> $Category->Get('NAME', $Boards->Get('CATEGORY', $id)),
			};
			last;
		}
	}
	
	my $indata = {
		'title'			=> 'BBS List' . ($subtitle ? " - $subtitle" : ''),
		'intmpl'		=> 'sys.bbs.bbslist',
		'scategory'		=> $scat,
		'categories'	=> $categories,
		'boards'		=> $boards,
		'issysad'		=> $Sec->IsAuthority($cuser, $ZP::AUTH_SYSADMIN, '*'),
	};
	
	return $indata;
}

#------------------------------------------------------------------------------------------------------------
#
#	f쐬ʂ̕\
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PreparePageBBSCreate
{
	my ($Sys, $Form) = @_;
	
	require './module/nazguls.pl';
	my $Boards = NAZGUL->new;
	my $Category = ANGMAR->new;
	$Boards->Load($Sys);
	$Category->Load($Sys);
	
	# JeSXgo
	my $categories = [];
	my @catSet = ();
	$Category->GetKeySet(\@catSet);
	foreach my $id (sort @catSet) {
		push @$categories, {
			'id'	=> $id,
			'name'	=> $Category->Get('NAME', $id),
		};
	}
	
	# fXgo
	my $boards = [];
	my @bbsSet = ();
	$Boards->GetKeySet('ALL', '', \@bbsSet);
	foreach my $id (sort @bbsSet) {
		push @$boards, {
			'id'		=> $id,
			'name'		=> $Boards->Get('NAME', $id),
		};
	}
	
	my $indata = {
		'title'			=> 'BBS Create',
		'intmpl'		=> 'sys.bbs.bbscreate',
		'categories'	=> $categories,
		'boards'		=> $boards,
	};
	
	return $indata;
}

#------------------------------------------------------------------------------------------------------------
#
#	f폜mFʂ̕\
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PreparePageBBSDelete
{
	my ($Sys, $Form) = @_;
	
	require './module/nazguls.pl';
	my $Boards = NAZGUL->new;
	my $Category = ANGMAR->new;
	$Boards->Load($Sys);
	$Category->Load($Sys);
	
	# fXgo
	my $boards = [];
	my @bbsSet = $Form->GetAtArray('BBSS');
	foreach my $id (sort @bbsSet) {
		next if (!defined $Boards->Get('NAME', $id));
		push @$boards, {
			'id'		=> $id,
			'name'		=> $Boards->Get('NAME', $id),
			'subject'	=> $Boards->Get('SUBJECT', $id),
			'category'	=> $Category->Get('NAME', $Boards->Get('CATEGORY', $id)),
		};
	}
	
	my $indata = {
		'title'			=> 'BBS Delete Confirm',
		'intmpl'		=> 'sys.bbs.bbsdelete',
		'boards'		=> $boards,
	};
	
	return $indata;
}

#------------------------------------------------------------------------------------------------------------
#
#	fJeSύXʂ̕\
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PreparePageBBScategoryChange
{
	my ($Sys, $Form) = @_;
	
	require './module/nazguls.pl';
	my $Boards = NAZGUL->new;
	my $Category = ANGMAR->new;
	$Boards->Load($Sys);
	$Category->Load($Sys);
	
	# fXgo
	my $boards = [];
	my @bbsSet = $Form->GetAtArray('BBSS');
	foreach my $id (sort @bbsSet) {
		next if (!defined $Boards->Get('NAME', $id));
		push @$boards, {
			'id'		=> $id,
			'name'		=> $Boards->Get('NAME', $id),
			'subject'	=> $Boards->Get('SUBJECT', $id),
			'category'	=> $Category->Get('NAME', $Boards->Get('CATEGORY', $id)),
		};
	}
	
	# JeSXgo
	my $categories = [];
	my @catSet = ();
	$Category->GetKeySet(\@catSet);
	foreach my $id (sort @catSet) {
		push @$categories, {
			'id'	=> $id,
			'name'	=> $Category->Get('NAME', $id),
		};
	}
	
	my $indata = {
		'title'			=> 'Category Change',
		'intmpl'		=> 'sys.bbs.catchange',
		'boards'		=> $boards,
		'categories'	=> $categories,
	};
	
	return $indata;
}

#------------------------------------------------------------------------------------------------------------
#
#	JeSꗗʂ̕\
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PreparePageCategoryList
{
	my ($Sys, $Form) = @_;
	
	require './module/nazguls.pl';
	my $Boards = NAZGUL->new;
	my $Category = ANGMAR->new;
	$Boards->Load($Sys);
	$Category->Load($Sys);
	
	# JeSXgo
	my $categories = [];
	my @catSet = ();
	$Category->GetKeySet(\@catSet);
	foreach my $id (sort @catSet) {
		my @bbsSet = ();
		$Boards->GetKeySet('CATEGORY', $id, \@bbsSet);
		push @$categories, {
			'id'		=> $id,
			'name'		=> $Category->Get('NAME', $id),
			'subject'	=> $Category->Get('SUBJECT', $id),
			'num'		=> scalar(@bbsSet),
		};
	}
	
	my $indata = {
		'title'			=> 'Category List',
		'intmpl'		=> 'sys.bbs.catlist',
		'categories'	=> $categories,
	};
	
	return $indata;
}

#------------------------------------------------------------------------------------------------------------
#
#	JeSǉʂ̕\
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PreparePageCategoryAdd
{
	my ($Sys, $Form) = @_;
	
	my $indata = {
		'title'			=> 'Category Add',
		'intmpl'		=> 'sys.bbs.catadd',
	};
	
	return $indata;
}

#------------------------------------------------------------------------------------------------------------
#
#	JeS폜ʂ̕\
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub PreparePageCategoryDelete
{
	my ($Sys, $Form) = @_;
	
	require './module/nazguls.pl';
	my $Category = ANGMAR->new;
	$Category->Load($Sys);
	
	my @catSet = $Form->GetAtArray('CATS');
	
	# JeSXgo
	my $categories = [];
	foreach my $id (sort @catSet) {
		my @bbsSet = ();
		push @$categories, {
			'id'		=> $id,
			'name'		=> $Category->Get('NAME', $id),
			'subject'	=> $Category->Get('SUBJECT', $id),
		};
	}
	
	my $indata = {
		'title'			=> 'Category Delete Confirm',
		'intmpl'		=> 'sys.bbs.catdelete',
		'categories'	=> $categories,
	};
	
	return $indata;
}

#------------------------------------------------------------------------------------------------------------
#
#	f̐
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@param	$pLog	Op
#	@return	G[R[h
#
#------------------------------------------------------------------------------------------------------------
sub FunctionBBSCreate
{
	my ($Sys, $Form, $pLog) = @_;
	
	# `FbN
	my $Sec = $Sys->Get('ADMIN')->{'SECINFO'};
	my $cuser = $Sys->Get('ADMIN')->{'USER'};
	return 1000 if (!$Sec->IsAuthority($cuser, $ZP::AUTH_SYSADMIN, '*'));
	
	# ̓`FbN
	return 1001 if (!$Form->IsInput([qw(BBS_DIR BBS_NAME BBS_CATEGORY)]));
	return 1002 if (!$Form->IsBBSDir([qw(BBS_DIR)]));
	
	require './module/earendil.pl';
	
	# POSTf[^̎擾
	my $bbsCategory		= $Form->Get('BBS_CATEGORY');
	my $bbsDir			= $Form->Get('BBS_DIR');
	my $bbsName			= $Form->Get('BBS_NAME');
	my $bbsExplanation	= $Form->Get('BBS_EXPLANATION');
	my $bbsInherit		= $Form->Get('BBS_INHERIT');
	
	# pX̐ݒ
	my $createPath	= $Sys->Get('BBSPATH').'/'.$bbsDir;
	my $dataPath	= '.'.$Sys->Get('DATA');
	
	# ffBNg̍쐬ɐẢ̃fBNg쐬
	if (!EARENDIL::CreateDirectory($createPath, $Sys->Get('PM-BDIR'))) {
		return 2000;
	}
	
	# TufBNg
	EARENDIL::CreateDirectory("$createPath/i", $Sys->Get('PM-BDIR'));
	EARENDIL::CreateDirectory("$createPath/dat", $Sys->Get('PM-BDIR'));
	EARENDIL::CreateDirectory("$createPath/log", $Sys->Get('PM-LDIR'));
	EARENDIL::CreateDirectory("$createPath/kako", $Sys->Get('PM-BDIR'));
	EARENDIL::CreateDirectory("$createPath/pool", $Sys->Get('PM-ADIR'));
	EARENDIL::CreateDirectory("$createPath/info", $Sys->Get('PM-ADIR'));
	
	# ftHgf[^̃Rs[
	EARENDIL::Copy("$dataPath/default_img.gif", "$createPath/kanban.gif");
	EARENDIL::Copy("$dataPath/default_bac.gif", "$createPath/ba.gif");
	EARENDIL::Copy("$dataPath/default_hed.txt", "$createPath/head.txt");
	EARENDIL::Copy("$dataPath/default_fot.txt", "$createPath/foot.txt");
	EARENDIL::Copy("$dataPath/index.html", "$createPath/log/index.html");
	EARENDIL::Copy("$dataPath/index.html", "$createPath/pool/index.html");
	EARENDIL::Copy("$dataPath/index.html", "$createPath/info/index.html");
	
	push @$pLog, "ffBNg...[$createPath]";
	
	require './module/nazguls.pl';
	my $Boards = NAZGUL->new;
	$Boards->Load($Sys);
	
	# ݒp̃Rs[
	if ($bbsInherit ne '') {
		my $inheritPath = $Sys->Get('BBSPATH').'/'.$Boards->Get('DIR', $bbsInherit);
		EARENDIL::Copy("$inheritPath/SETTING.TXT", "$createPath/SETTING.TXT");
		EARENDIL::Copy("$inheritPath/info/groups.cgi", "$createPath/info/groups.cgi");
		EARENDIL::Copy("$inheritPath/info/capgroups.cgi", "$createPath/info/capgroups.cgi");
		
		push @$pLog, "ݒp...[$inheritPath]";
	}
	
	# fݒ񐶐
	require './module/isildur.pl';
	my $bbsSetting = ISILDUR->new;
	
	$Sys->Set('BBS', $bbsDir);
	$bbsSetting->Load($Sys);
	
	require './module/galadriel.pl';
	my $createPath2 = GALADRIEL::MakePath($Sys->Get('CGIPATH'), $createPath);
	my $cookiePath = GALADRIEL::MakePath($Sys->Get('CGIPATH'), $Sys->Get('BBSPATH'));
	$cookiePath .= '/' if ($cookiePath ne '/');
	$bbsSetting->Set('BBS_TITLE', $bbsName);
	$bbsSetting->Set('BBS_SUBTITLE', $bbsExplanation);
	$bbsSetting->Set('BBS_BG_PICTURE', "$createPath2/ba.gif");
	$bbsSetting->Set('BBS_TITLE_PICTURE', "$createPath2/kanban.gif");
	$bbsSetting->Set('BBS_COOKIEPATH', $cookiePath);
	
	$bbsSetting->Save($Sys);
	
	push @$pLog, 'fݒ芮...';
	
	# f\vf
	my ($BBSAid);
	require './module/varda.pl';
	$BBSAid = VARDA->new;
	
	$Sys->Set('MODE', 'CREATE');
	$BBSAid->Init($Sys, $bbsSetting);
	$BBSAid->CreateIndex();
	$BBSAid->CreateIIndex();
	$BBSAid->CreateSubback();
	
	push @$pLog, 'f\\vf...';
	
	# ߋOCfNX
	require './module/thorin.pl';
	require './module/celeborn.pl';
	my $PastLog = CELEBORN->new;
	my $Page = THORIN->new;
	$PastLog->Load($Sys);
	$PastLog->UpdateInfo($Sys);
	$PastLog->UpdateIndex($Sys, $Page);
	$PastLog->Save($Sys);
	
	push @$pLog, 'ߋOCfNX...';
	
	# fɒǉ
	$Boards->Add($bbsName, $bbsDir, $bbsExplanation, $bbsCategory);
	$Boards->Save($Sys);
	
	push @$pLog, 'fǉ';
	push @$pLog, "@@@@OF$bbsName";
	push @$pLog, "@@@@TuWFNgF$bbsExplanation";
	push @$pLog, "@@@@JeSF$bbsCategory";
	push @$pLog, '<hr>ȉURLɌf쐬܂B';
	push @$pLog, "<a href=\"$createPath/\" target=_blank>$createPath/</a>";
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	f̍XV
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@param	$pLog	Op
#	@return	G[R[h
#
#------------------------------------------------------------------------------------------------------------
sub FunctionBBSUpdate
{
	my ($Sys, $Form, $pLog) = @_;
	
	require './module/nazguls.pl';
	require './module/varda.pl';
	my $Boards = NAZGUL->new;
	my $BBSAid = VARDA->new;
	
	$Boards->Load($Sys);
	
	my @bbsSet = $Form->GetAtArray('BBSS');
	
	foreach my $id (@bbsSet) {
		my $bbs = $Boards->Get('DIR', $id, '');
		next if ($bbs eq '');
		my $name = $Boards->Get('NAME', $id);
		$Sys->Set('BBS', $bbs);
		$Sys->Set('MODE', 'CREATE');
		$BBSAid->Init($Sys, undef);
		$BBSAid->CreateIndex();
		$BBSAid->CreateIIndex();
		$BBSAid->CreateSubback();
		
		push @$pLog, "fu$namevXV܂B";
	}
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	f̍XV
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@param	$pLog	Op
#	@return	G[R[h
#
#------------------------------------------------------------------------------------------------------------
sub FunctionBBSInfoUpdate
{
	my ($Sys, $Form, $pLog) = @_;
	
	# `FbN
	my $Sec = $Sys->Get('ADMIN')->{'SECINFO'};
	my $cuser = $Sys->Get('ADMIN')->{'USER'};
	return 1000 if (!$Sec->IsAuthority($cuser, $ZP::AUTH_SYSADMIN, '*'));
	
	require './module/nazguls.pl';
	my $Boards = NAZGUL->new;
	
	$Boards->Load($Sys);
	$Boards->Update($Sys, '');
	$Boards->Save($Sys);
	
	push @$pLog, 'f̍XVɏI܂B';
	push @$pLog, 'JeS͑Sāuʁvɐݒ肳ꂽ̂ŁAĐݒ肵ĂB';
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	f̍폜
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@param	$pLog	Op
#	@return	G[R[h
#
#------------------------------------------------------------------------------------------------------------
sub FunctionBBSDelete
{
	my ($Sys, $Form, $pLog) = @_;
	
	# `FbN
	my $Sec = $Sys->Get('ADMIN')->{'SECINFO'};
	my $cuser = $Sys->Get('ADMIN')->{'USER'};
	return 1000 if (!$Sec->IsAuthority($cuser, $ZP::AUTH_SYSADMIN, '*'));
	
	require './module/nazguls.pl';
	require './module/earendil.pl';
	my $Boards = NAZGUL->new;
	$Boards->Load($Sys);
	
	my @bbsSet = $Form->GetAtArray('BBSS');
	
	foreach my $id (@bbsSet) {
		my $dir = $Boards->Get('DIR', $id, '');
		next if ($dir ne '');
		my $name = $Boards->Get('NAME', $id);
		my $path = $Sys->Get('BBSPATH') . "/$dir";
		
		# ffBNgƌf̍폜
		EARENDIL::DeleteDirectory($path);
		$Boards->Delete($id);
		
		push @$pLog, "fu$name($dir)v폜܂B<br>";
	}
	
	$Boards->Save($Sys);
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	JeS̒ǉ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@param	$pLog	Op
#	@return	G[R[h
#
#------------------------------------------------------------------------------------------------------------
sub FunctionCategoryAdd
{
	my ($Sys, $Form, $pLog) = @_;
	
	# `FbN
	my $Sec = $Sys->Get('ADMIN')->{'SECINFO'};
	my $cuser = $Sys->Get('ADMIN')->{'USER'};
	return 1000 if (!$Sec->IsAuthority($cuser, $ZP::AUTH_SYSADMIN, '*'));
	
	require './module/nazguls.pl';
	my $Category = ANGMAR->new;
	$Category->Load($Sys);
	
	my $name = $Form->Get('NAME');
	my $subj = $Form->Get('SUBJ');
	
	$Category->Add($name, $subj);
	$Category->Save($Sys);
	
	# O̐ݒ
	push @$pLog, ' JeSǉ';
	push @$pLog, "JeŚF$name";
	push @$pLog, "JeSF$subj";
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	JeS̍폜
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@param	$pLog	Op
#	@return	G[R[h
#
#------------------------------------------------------------------------------------------------------------
sub FunctionCategoryDelete
{
	my ($Sys, $Form, $pLog) = @_;
	
	# `FbN
	my $Sec = $Sys->Get('ADMIN')->{'SECINFO'};
	my $cuser = $Sys->Get('ADMIN')->{'USER'};
	return 1000 if (!$Sec->IsAuthority($cuser, $ZP::AUTH_SYSADMIN, '*'));
	
	require './module/nazguls.pl';
	my $Boards = NAZGUL->new;
	my $Category = ANGMAR->new;
	$Boards->Load($Sys);
	$Category->Load($Sys);
	
	my @catSet = $Form->GetAtArray('CATS');
	
	foreach my $id (@catSet) {
		if ($id ne '0000000001') {
			my $name = $Category->Get('NAME', $id);
			my @bbsSet = ();
			$Boards->GetKeySet('CATEGORY', $id, \@bbsSet);
			foreach my $bbsid (@bbsSet) {
				$Boards->Set($bbsid, 'CATEGORY', '0000000001');
			}
			$Category->Delete($id);
			push @$pLog, "JeSu$namev폜";
		}
	}
	
	$Boards->Save($Sys);
	$Category->Save($Sys);
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	JeS̕ύX
#	-------------------------------------------------------------------------------------
#	@param	$Sys	VXeϐ
#	@param	$Form	tH[ϐ
#	@param	$pLog	Op
#	@return	G[R[h
#
#------------------------------------------------------------------------------------------------------------
sub FunctionCategoryChange
{
	my ($Sys, $Form, $pLog) = @_;
	
	# `FbN
	my $Sec = $Sys->Get('ADMIN')->{'SECINFO'};
	my $cuser = $Sys->Get('ADMIN')->{'USER'};
	return 1000 if (!$Sec->IsAuthority($cuser, $ZP::AUTH_SYSADMIN, '*'));
	
	require './module/nazguls.pl';
	my $Boards = NAZGUL->new;
	my $Category = ANGMAR->new;
	$Boards->Load($Sys);
	$Category->Load($Sys);
	
	my @bbsSet	= $Form->GetAtArray('BBSS');
	my $catid	= $Form->Get('SEL_CATEGORY');
	my $catname	= $Category->Get('NAME', $catid);
	
	foreach my $id (@bbsSet) {
		$Boards->Set($id, 'CATEGORY', $catid);
		my $bbsname = $Boards->Get('NAME', $id);
		push @$pLog, "u$bbsnameṽJeSu$catnamevɕύX";
	}
	
	$Boards->Save($Sys);
	
	return 0;
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
