#============================================================================================================
#
#	g@\ - u
#	0ch_replace.pl
#	---------------------------------------------------------------------------
#	2013.05.07 start
#
#============================================================================================================
package ZPL_replace;

#------------------------------------------------------------------------------------------------------------
#	RXgN^
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	my ($Config) = @_;
	
	my $obj = {};
	bless $obj, $class;
	
	if (defined $Config) {
		$obj->{'PLUGINCONF'} = $Config;
		$obj->{'is0ch+'} = 1;
	}
	else {
		$obj->{'CONFIG'} = $class->getConfig();
		$obj->{'is0ch+'} = 0;
	}
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#	g@\̎擾
#------------------------------------------------------------------------------------------------------------
sub getName
{
	my $this = shift;
	return 'u';
}

#------------------------------------------------------------------------------------------------------------
#	g@\擾
#------------------------------------------------------------------------------------------------------------
sub getExplanation
{
	my $this = shift;
	return '{▼OɊ܂܂̕u܂BNG[hułB';
}

#------------------------------------------------------------------------------------------------------------
#	g@\^Cv擾
#------------------------------------------------------------------------------------------------------------
sub getType
{
	my $this = shift;
	return 16;
}

#------------------------------------------------------------------------------------------------------------
#	ݒ胊Xg擾 (0ch+ Only)
#------------------------------------------------------------------------------------------------------------
sub getConfig
{
	my $this = shift;
	my %config = ();
	return \%config;
}

#------------------------------------------------------------------------------------------------------------
#	g@\sC^tFCX
#------------------------------------------------------------------------------------------------------------
sub execute
{
	my $this = shift;
	my ($Sys, $Form, $type) = @_;
	
	if ($type & 16) {
		foreach my $key ('FROM', 'mail', 'MESSAGE') {
			my $text = $Form->Get($key);
			
			# u镶
			$text =~ s|U|ځ[|g;
			$text =~ s|pass[0-9]*word|[{]|gi;
			
			# {̂
			if ($key eq 'MESSAGE') {
				$text =~ s||Nice boat.|g;
				# Shift_JISoOɒ
				$text =~ s|\Q^C}V\E|<font color=red>֑</font>|g;
			}
			
			$Form->Set($key, $text);
		}
	}
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#	ݒl擾 (0ch+ Only)
#------------------------------------------------------------------------------------------------------------
sub GetConf
{
	my $this = shift;
	my ($key) = @_;
	if ($this->{'is0ch+'}) {
		return $this->{'PLUGINCONF'}->GetConfig($key);
	}
	elsif (defined $this->{'CONFIG'}->{$key}) {
		return $this->{'CONFIG'}->{$key}->{'default'};
	}
}

#------------------------------------------------------------------------------------------------------------
#	ݒlݒ (0ch+ Only)
#------------------------------------------------------------------------------------------------------------
sub SetConf
{
	my $this = shift;
	my ($key, $val) = @_;
	if ($this->{'is0ch+'}) {
		$this->{'PLUGINCONF'}->SetConfig($key, $val);
	}
	elsif (defined $this->{'CONFIG'}->{$key}) {
		$this->{'CONFIG'}->{$key}->{'default'} = $val;
	}
	else {
		$this->{'CONFIG'}->{$key} = { 'default' => $val };
	}
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
