#============================================================================================================
#
#	g@\ - dat
#	0ch_autopool.pl
#	---------------------------------------------------------------------------
#	2013.05.06 start
#
#============================================================================================================
package ZPL_autopool;

#------------------------------------------------------------------------------------------------------------
#	RXgN^
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	my ($Config) = @_;
	
	my $obj = {};
	bless $obj, $class;
	
	if (defined $Config) {
		$obj->{'PLUGINCONF'} = $Config;
		$obj->{'is0ch+'} = 1;
	}
	else {
		$obj->{'CONFIG'} = $class->getConfig();
		$obj->{'is0ch+'} = 0;
	}
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#	g@\̎擾
#------------------------------------------------------------------------------------------------------------
sub getName
{
	my $this = shift;
	return 'dat';
}

#------------------------------------------------------------------------------------------------------------
#	g@\擾
#------------------------------------------------------------------------------------------------------------
sub getExplanation
{
	my $this = shift;
	return 'ݎɁA莞ԉ߂XbhŃv[Ɉړ(Ƃ)vOCłB';
}

#------------------------------------------------------------------------------------------------------------
#	g@\^Cv擾
#------------------------------------------------------------------------------------------------------------
sub getType
{
	my $this = shift;
	return 16;
}

#------------------------------------------------------------------------------------------------------------
#	ݒ胊Xg擾 (0ch+ Only)
#------------------------------------------------------------------------------------------------------------
sub getConfig
{
	my $this = shift;
	my %config = (
		'duration'	=> {
			'default'		=> 1*(24*60*60),
			'valuetype'		=> 1,
			'description'	=> '莞ԊԊuJď(b)',
		},
		'elapsed'	=> {
			'default'		=> 14*(24*60*60),
			'valuetype'		=> 1,
			'description'	=> '莞ԍXVȂXdat(b)',
		},
		'_samba'	=> {
			'default'		=> 0,
			'valuetype'		=> 1,
			'description'	=> 'Ōɏ ꎞϐȂ̂łȂ',
		},
	);
	return \%config;
}

#------------------------------------------------------------------------------------------------------------
#	g@\sC^tFCX
#------------------------------------------------------------------------------------------------------------
sub execute
{
	my $this = shift;
	my ($Sys, $Form, $type) = @_;
	
	# ݒOɏ / 0ch{Ƃł͎sȂ
	if (($type & 16) && $this->{'is0ch+'}) {
		my $duration = $this->GetConf('duration');
		my $elapsed = $this->GetConf('elapsed');
		my $samba = $this->GetConf('_samba');
		my $nowtime = time;
		
		# ԊuuĎs
		if ($nowtime - $samba > $duration) {
			require './module/earendil.pl';
			my $Threads = $Sys->Get('_THREAD_');
			my $Pools = FRODO->new;
			$Pools->Load($Sys);
			
			my $path = $Sys->Get('BBSPATH').'/'.$Sys->Get('BBS');
			my @threadList = ();
			$Threads->GetKeySet('ALL', '', \@threadList);
			
			# ݂̔̑SXbh`FbN
			foreach my $id (@threadList) {
				# ƂĂXbh̓X[
				next if ($Sys->Get('KEY') eq $id);
				
				# dat̍ŏIXV
				my $lastmodif = (stat "$path/dat/$id.dat")[9];
				# ݒ莞ԍXVĂȂ΃v[Ɉړ(dat)
				if ($nowtime - $lastmodif > $elapsed) {
					$Pools->Add($id, $Threads->Get('SUBJECT', $id), $Threads->Get('RES', $id));
					$Threads->Delete($id);
					EARENDIL::Move("$path/dat/$id.dat", "$path/pool/$id.cgi");
				}
			}
			
			# Xbhۑ
			$Pools->Save($Sys);
			$Threads->Save($Sys);
			
			# ŌɏXV
			$this->SetConf('_samba', $nowtime);
		}
	}
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#	ݒl擾 (0ch+ Only)
#------------------------------------------------------------------------------------------------------------
sub GetConf
{
	my $this = shift;
	my ($key) = @_;
	if ($this->{'is0ch+'}) {
		return $this->{'PLUGINCONF'}->GetConfig($key);
	}
	elsif (defined $this->{'CONFIG'}->{$key}) {
		return $this->{'CONFIG'}->{$key}->{'default'};
	}
}

#------------------------------------------------------------------------------------------------------------
#	ݒlݒ (0ch+ Only)
#------------------------------------------------------------------------------------------------------------
sub SetConf
{
	my $this = shift;
	my ($key, $val) = @_;
	if ($this->{'is0ch+'}) {
		$this->{'PLUGINCONF'}->SetConfig($key, $val);
	}
	elsif (defined $this->{'CONFIG'}->{$key}) {
		$this->{'CONFIG'}->{$key}->{'default'} = $val;
	}
	else {
		$this->{'CONFIG'}->{$key} = { 'default' => $val };
	}
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
