#============================================================================================================
#
#	g@\ - n\vOC( ken.2ch.net )
#	0ch_area2ch.pl
#
#	by 낿˂vX
#	http://zerochplus.sourceforge.jp/
#
#	  O  K  r e a d m e . t x t         B
#	ǂ܂ȂƂȂ͖̒   Q       B
#
#	---------------------------------------------------------------------------
#
#	2011.08.27 start
#
#============================================================================================================
package ZPL_area2ch;

#------------------------------------------------------------------------------------------------------------
#	RXgN^
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $this = shift;
	my ($Config) = @_;
	my ($obj);
	
	$obj = {};
	bless $obj, $this;
	
	if (defined $Config) {
		$obj->{'PLUGINCONF'} = $Config;
		$obj->{'is0ch+'} = 1;
	}
	else {
		$obj->{'CONFIG'} = $this->getConfig();
		$obj->{'is0ch+'} = 0;
	}
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#	g@\̎擾
#	-------------------------------------------------------------------------------------
#	@return	̕
#------------------------------------------------------------------------------------------------------------
sub getName
{
	my	$this = shift;
	return 'n\vOC( ken.2ch.net )';
}

#------------------------------------------------------------------------------------------------------------
#	g@\擾
#	-------------------------------------------------------------------------------------
#	@return	
#------------------------------------------------------------------------------------------------------------
sub getExplanation
{
	my	$this = shift;
	return 'Oɒn\܂(\2ch݊)';
}

#------------------------------------------------------------------------------------------------------------
#	g@\^Cv擾
#	-------------------------------------------------------------------------------------
#	@return	g@\^Cv(X:1, X:2, read:4, index:8, ݑO:16)
#------------------------------------------------------------------------------------------------------------
sub getType
{
	my	$this = shift;
	return (16);
}

#------------------------------------------------------------------------------------------------------------
#	ݒ胊Xg擾 (0ch+ Only)
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	ݒnbVt@X
#		\%config = (
#			'ݒ薼'	=> {
#				'default'		=> l,			# ^Ul̏ꍇ on/true: 1, off/false: 0
#				'valuetype'		=> l̃^Cv,		# l: 1, : 2, ^Ul: 3
#				'description'	=> 'ݒ̐',	# Ă\܂
#			},
#		);
#------------------------------------------------------------------------------------------------------------
sub getConfig
{
	my	$this = shift;
	my	%config;
	
	%config = (
		'bbs'	=> {
			'default'		=> 'testing,testingx',
			'valuetype'		=> 2,
			'description'	=> '삳(u,v؂ŕw)',
		},
		'mode'	=> {
			'default'		=> 1,
			'valuetype'		=> 1,
			'description'	=> '\[h(1Œʏ̌ ȊO http://ken.2ch.net/shikibetsu/ Q)',
		},
		'hidden' => {
			'default'		=> 0,
			'valuetype'		=> 3,
			'description'	=> '!hiddenŒn\',
		},
		'cap'	=> {
			'default'		=> 0,
			'valuetype'		=> 3,
			'description'	=> 'Lbvt̏ꍇ͒n\ɂ',
		},
		'cache'	=> {
			'default'		=> 50,
			'valuetype'		=> 1,
			'description'	=> 'LbVۑ',
		},
	);
	
	return \%config;
}

#------------------------------------------------------------------------------------------------------------
#	g@\sC^tFCX
#	-------------------------------------------------------------------------------------
#	@param	$sys	MELKOR
#	@param	$form	SAMWISE
#	@param	$type	s^Cv
#	@return	Ȉꍇ0
#------------------------------------------------------------------------------------------------------------
sub execute
{
	my	$this = shift;
	my	($sys, $form, $type) = @_;
	my	($flag, $name, $HOST, $ADDR, $SERIAL, $area);
	
	# 萔W[ ǂݍ
	require './module/constant.pl';
	
	# 삳w
	$flag = 0;
	foreach ( split( /,/, $this->GetConf('bbs') ) ) {
		$flag = 1 if( $_ eq $sys->Get('BBS') );
	}
	return 0 if ( !$flag );
	
	# n\Ȃɂ
	if ( $this->GetConf('hidden') && HiddenArea( $form ) ) {
		return 0;
	}
	
	if ( ( index ( $form->Get('FROM'), "" ) != -1 ) && $this->GetConf('cap') ) {
		return 0;
	}
	
	# [gzXg
	$HOST = $ENV{'REMOTE_HOST'};
	# IP
	$ADDR = $ENV{'REMOTE_ADDR'};
	# gьŗLID擾
	$SELIAL = AddIdentifier( $sys ) if ( $sys->Get('CLIENT') & $ZP::C_MOBILE_IDGET );
	
	# LbV
	$area = CacheSearch( $ADDR, $SELIAL );
	if ( $area ) {
		SetArea( $sys, $form, $area );
		return 0;
	}
	
	# APIŎĂ
	$area = GetArea( $HOST, $ADDR, $SELIAL, $this->GetConf('mode') );
	
	# OɃZbg
	SetArea( $sys, $form, $area );
	
	# LbVۑ
	CacheSave( $ADDR, $SELIAL, $area, $this->GetConf('cache') );
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#	n\
#	-------------------------------------------------------------------------------------
#	@param	$form	SAMWISE
#	@return	\Ȃ1 \Ȃ0
#------------------------------------------------------------------------------------------------------------
sub HiddenArea
{
	my ( $form ) = @_;
	my ( $mail );
	
	# [擾
	$mail = $form->Get('mail');
	
	# [ !hidden ܂܂Ăn\Ȃ
	if ( $mail =~ /!hidden/ ) {
		$mail =~ s/!hidden//; # S~
		$form->Set('mail', $mail);
		return 1;
	}
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#	ŗLIDǂ̂
#	-------------------------------------------------------------------------------------
#	@param	$sys	MELKOR
#	@return	LAʎqťgт̌ŗLID
#------------------------------------------------------------------------------------------------------------
sub AddIdentifier
{
	my ( $sys ) = @_;
	my ( $client, $SERIAL );
	
	$SELIAL = $sys->Get('KOYUU');
	$client = $sys->Get('CLIENT');
	
	if ( $client & $ZP::C_AU_M ) {
		return "au:".$SELIAL;
	}
	elsif ( $client & $ZP::C_DOCOMO_M ) {
		return "dc:".$SELIAL;
	}
	elsif ( $client & $ZP::C_SOFTBANK_M ) {
		return "sb:".$SELIAL;
	}
	else {
		return '';
	}
}

#------------------------------------------------------------------------------------------------------------
#	LbVۑp
#	-------------------------------------------------------------------------------------
#	@param	$ADDR	IPAhX
#			$SELIAL	gьŗLID
#			$area	\n
#	@return	Ȃ
#------------------------------------------------------------------------------------------------------------
sub CacheSave
{
	my ( $ADDR, $SELIAL, $area, $log ) = @_;
	my ( $query, @cache );
	
	$query = ( $SELIAL ne "" ? $SELIAL : $ADDR );
	
	if ( open( CACHE, "< ./info/area_cache.cgi") ) {
		@cache = <CACHE>;
		close CACHE;
	}
	# LbVۑ𒴂Ă
	shift @cache if ( $log - 2 < $#cache );
	push (@cache, "$query<>$area\n" );
	if ( open( CACHE, "> ./info/area_cache.cgi") ) {
		print CACHE @cache;
		close CACHE;
	}
}

#------------------------------------------------------------------------------------------------------------
#	LbV
#	-------------------------------------------------------------------------------------
#	@param	$ADDR	IPAhX
#			$SELIAL	gьŗLID
#	@return	s{/ LbVȂ/s̏ꍇ 0
#------------------------------------------------------------------------------------------------------------
sub CacheSearch
{
	my ( $ADDR, $SELIAL, $area ) = @_;
	my ( $query );
	
	$query = ( $SELIAL ne "" ? $SELIAL : $ADDR );
	
	if ( open( CACHE, "< ./info/area_cache.cgi") ) {
		while ( <CACHE> ) {
			return $1 if ( $_ =~ /^$query<>(.+)\n$/ )
		}
	}
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#	API擾
#	-------------------------------------------------------------------------------------
#	@param	$HOST		[gzXgAhX
#			$ADDR		IPAhX
#			$SELIAL		gьŗLID
#			$mode		\[h
#	@return	$cont		擾e(n\)
#------------------------------------------------------------------------------------------------------------
sub GetArea
{
	my ( $HOST, $ADDR, $koyuu, $mode ) = @_;
	my ( $url, $proxy, $req, $res, $cont, $code );
	
	require './module/httpservice.pl';
	
	# APIANZXpURL
	$url = "http://ken.2ch.net/ken.cgi?ip=$ADDR&host=$HOST&mode=$mode&keitai=$SELIAL";
	
	# O
	$proxy = HTTPSERVICE->new;
	$proxy->setURI($url);
	$proxy->setAgent('Mozilla/5.0 Plugin for 0ch+; 0ch_area2ch.pl http://zerochplus.sourceforge.jp/');
	$proxy->setTimeout(5);
	
	# Ă܂
	$proxy->request();
	
	$cont = $proxy->getContent();
	$code = $proxy->getStatus();
	
	# 擾łȂ
	return -1 if ( $code ne 200 );
	
	# Tj^CWO
	$cont =~ s/[\x0d\x0a\0]//g;
	$cont =~ s/"/&quot;/g; #"
	$cont =~ s/</&lt;/g;
	$cont =~ s/>/&gt;/g;
	
	return $cont;
}

#------------------------------------------------------------------------------------------------------------
#	n\Zbg
#	-------------------------------------------------------------------------------------
#	@param	$sys	MELKOR
#			$form	SAMWISE
#			$area	\n
#	@return	Ȃ
#------------------------------------------------------------------------------------------------------------
sub SetArea
{
	my ( $sys, $form, $area ) = @_;
	my ( $name );
	
	require './module/isildur.pl';
	my $SET = ISILDUR->new;
	$SET->Load($sys);
	
	# ̂ւ̏̂Ń_vOCǂ̂
	$name = ($form->Get('FROM')||$SET->Get('BBS_NONAME_NAME'));
	
	$form->Set('FROM', $name."</b>(".$area.")<b>");
}

#------------------------------------------------------------------------------------------------------------
#	ݒl擾 (0ch+ Only)
#	-------------------------------------------------------------------------------------
#	@param	$key	ݒ薼
#	@return	ݒl
#------------------------------------------------------------------------------------------------------------
sub GetConf
{
	my	$this = shift;
	my	($key) = @_;
	my	($val);
	
	if ($this->{'is0ch+'}) {
		$val = $this->{'PLUGINCONF'}->GetConfig($key);
	}
	else {
		if (defined $this->{'CONFIG'}->{$key}) {
			$val = $this->{'CONFIG'}->{$key}->{'default'};
		}
		else {
			$val = undef;
		}
	}
	
	return $val;
}

#------------------------------------------------------------------------------------------------------------
#	ݒlݒ (0ch+ Only)
#	-------------------------------------------------------------------------------------
#	@param	$key	ݒ薼
#	@param	$val	ݒl
#	@return	Ȃ
#------------------------------------------------------------------------------------------------------------
sub SetConf
{
	my	$this = shift;
	my	($key, $val) = @_;
	
	if ($this->{'is0ch+'}) {
		$this->{'PLUGINCONF'}->SetConfig($key, $val);
	}
	else {
		if (defined $this->{'CONFIG'}->{$key}) {
			$this->{'CONFIG'}->{$key}->{'default'} = $val;
		}
		else {
			$this->{'CONFIG'}->{$key} = { 'default' => $val };
		}
	}
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
