
package com.yx.mvc.command;

import java.util.concurrent.LinkedBlockingQueue;

import com.yx.util.TALogger;

/**
 * @Title TACommandQueue
 * @package com.yx.core.mvc.command
 * @Description TACommandQueue维护一个Command
 * @author YXDroid
 * @date 2014-1-16 下午 16:51
 * @version V1.0
 */
public class TACommandQueue
{
	private LinkedBlockingQueue<TAICommand> theQueue = new LinkedBlockingQueue<TAICommand>();

	public TACommandQueue()
	{
		TALogger.i(TACommandQueue.this, "初始化Command队列");
	}

	public void enqueue(TAICommand cmd)
	{
		TALogger.i(TACommandQueue.this, "添加Command到队列");
		theQueue.add(cmd);
	}

	public synchronized TAICommand getNextCommand()
	{
		TALogger.i(TACommandQueue.this, "获取Command");
		TAICommand cmd = null;
		try
		{
			TALogger.i(TACommandQueue.this, "CommandQueue::to-take");
			cmd = theQueue.take();
			TALogger.i(TACommandQueue.this, "CommandQueue::taken");
		} catch (InterruptedException e)
		{
			TALogger.i(TACommandQueue.this, "没有获取到Command");
			e.printStackTrace();
		}
		TALogger.i(TACommandQueue.this, "返回Command" + cmd);
		return cmd;
	}

	public synchronized void clear()
	{
		TALogger.i(TACommandQueue.this, "清空所有Command");
		theQueue.clear();
	}
}
