enchant();
//////////////////////////////////////
/*
    CanvasLayer初期化後にcanvasのコンテキストを操作する
*/
// var initCanvas = CanvasLayer.prototype.initialize;

// CanvasLayer.prototype.initialize = function() {
//     initCanvas.call(this);
//     console.log("canvas");

//     // 拡大時の処理をNearest Neighbor方式に切り替え
//     // ただしChromeとFireFoxでのみ動作
//     this.context.imageSmoothingEnabled = false;
//     this.context.webkitImageSmoothingEnabled = false;
//     this.context.mozImageSmoothingEnabled = false;
// };
//global
var ctl = null;
var mangIcon = null;
var mangTouch = null;
var mangLabel = null;
var mangMsg = null;
var LabelGroup = enchant.Class.mixClasses(Label, Group,true);
var net = new Net();
//////////////////////////////////////
//define
//////////////////////////////////////
var ADD_HUNGRY = 1;
var PALYER_INIT_X = 100;
var PALYER_INIT_Y = 100;
var CHARA_WIDTH = 64;
var CHARA_HEIGHT = 64;
var GAME_WIDTH = 800;
var GAME_HEIGHT = 600;
var FPS = 40;
var BASE_FPS = 20;
var HUNGRY_MAX = 100;
var TIME_SPEED = 4;
var MIN = BASE_FPS;
var HOUR = MIN * 60;
// var DAY = HOUR * 24;
var DAY = HOUR ;
var GAME_START_TIME = HOUR * 6;
//48x48 best?
var ICON_WIDTH = 48;
var ICON_HEIGHT = 48;

var EResPath = {
	YUKKURI_BASE : './data/yukkuri_base.png',
	YUKKURI_BODY_DEAD : './data/yukkuri_dead.png',
	YUKKURI_UNUN : './data/unun.png',
	YUKKURI_SHADOW : './data/shadow.png',
	MARISA_FACE_NORMAL : './data/marisa/face_normal1.png',
	MARISA_FACE_TIRED : './data/marisa/face_tired1.png',
	MARISA_FACE_ANGRY : './data/marisa/face_angry1.png',
	MARISA_FACE_CRY1 : './data/marisa/face_cry1.png',
	MARISA_FACE_CRY2 : './data/marisa/face_cry2.png',
	MARISA_FACE_EAT1 : './data/marisa/face_eat1.png',
	MARISA_FACE_EAT2 : './data/marisa/face_eat2.png',
	MARISA_FACE_HAPPY1 : './data/marisa/face_happy1.png',
	MARISA_FACE_HAPPY2 : './data/marisa/face_happy2.png',
	MARISA_FACE_SLEEP : './data/marisa/face_sleep1.png',
	MARISA_HEAR : './data/marisa/hear1.png',
	MARISA_OKAZARI : './data/marisa/okazari.png',
	OBJECT : './data/object.png',
	MAP0 : './data/map0.png',
	COMMAND : './data/command.png',
	PLACE_TREE : './data/system/place_tree.png',
	GRASS : './data/system/grass.png',
	PLAYER_BADGE : './data/system/player_badge.png',
	KUKI : './data/system/kuki.png',
	MIYUKKURI : './data/system/miyukkuri.png',
	// PLACE_TREE : './data/system/rapture.png',
};
var EResPathReimu = {
	getName: function(){
		return "reimu";
	},
	FACE_NORMAL : './data/reimu/face_normal1.png',
	FACE_TIRED : './data/reimu/face_tired1.png',
	FACE_ANGRY : './data/reimu/face_angry1.png',
	FACE_CRY1 : './data/reimu/face_cry1.png',
	FACE_CRY2 : './data/reimu/face_cry2.png',
	FACE_EAT1 : './data/reimu/face_eat1.png',
	FACE_EAT2 : './data/reimu/face_eat2.png',
	FACE_HAPPY1 : './data/reimu/face_happy1.png',
	FACE_HAPPY2 : './data/reimu/face_happy2.png',
	FACE_SLEEP : './data/reimu/face_sleep1.png',
	HEAR : './data/reimu/hear1.png',
	OKAZARI : './data/reimu/okazari.png',
	SUB1 : './data/reimu/sub1.png',

};

var EFace = {
	NORMAL:0,
	TIRED:1,
	ANGRY:2,
	CRY1:3,
	CRY2:4,
	EAT1:5,
	EAT2:6,
	HAPPY1:7,
	HAPPY2:8,
	SLEEP:9,
};
var EBody = {
	NORMAL: 0,
	DEAD: 1,
};

var ECommand = {
	WORLD_CURSOR: 0,
	WORLD_TARGET: 1,
	WORLD_APPLE: 2,
	WORLD_PLACE: 3,
	WORLD_REMOVE: 4,
	WORLD_PICOPICO_HUMMER: 5,
};

var EMenuPos = {
	X : 600,
	Y : 0,
	WIDTH : 200,
	HEIGHT : GAME_HEIGHT,
};
//width:200px;
var EFieldPos = {
	X : 0,
	Y : 0,
	WIDTH: GAME_WIDTH - EMenuPos.WIDTH,
	HEIGHT: GAME_HEIGHT,
};
var EAction = {
	WAIT : 0,
	HUNT : 3,
	THINK : 4,
	WALK : 5,
	DEAD: 6,
	EAT_START : 8,
	EAT_WAIT : 9,
	MOVE_TO_EAT_START: 10,
	MOVE_TO_EAT_UNDERWAY: 11,
	MOVE_TO_COMMAND: 12,
	UNUN_START : 13,
	UNUN_WAIT : 14,
	UNUN_SMELL_START : 15,
	UNUN_SMELL_WAIT : 16,
	SLEEP_START : 17,
	SLEEP_WAIT : 18,
	COMMUNICATE_START : 19,
	COMMUNICATE_WAIT: 20,
	COMMUNICATE_RECV: 21,
	MOVE_TO_PLACE_START_HOMELESS: 22,
	MOVE_TO_PLACE_HOMELESS_UNDERWAY: 23,
	DECLARE_PLACE_HOMELESS: 24,
	MOVE_TO_HUNT_START: 25,
	THINK_SCHEDULE: 26,
	HUNT_START: 27,
	MOVE_GOTO_HOME: 28,
	IN_HOME: 29,
	THINK_IN_HOME: 30,
	EAT_IN_HOME: 31,
	NONE: 9999
};
var EDeepSay = {

}
var EDirection = {
	LEFT : 0,
	RIGHT: 1,
};
var EMsg = {
	WALK: 0,
	SLEEP: 1,
	EAT: 2,
	GET_UP: 3,
	DEAD: 4,
	UNUN: 5,
	UNUN_END: 6,
	UNUN_SMELL: 7,
	SEARCH_FOOD: 8,
	EAT_FAILED: 9,
	SAY_HELLO: 10,
	TARGETING_EAT : 11,
	DECLARE_PLACE: 12,
	HUNT: 13,
	REHUNT: 14,
	HUNT_ESCAPE: 15,
	YYUYYU: 16,
	MOVE_GOTO_HOME:17,
	HUNTING_MESSAGE:18,
	LEARN_NO_FOOD_IN_PLACE:19,
	REMOVE_YUKKURI:20,
	LOST_HOUSE:21,
	MOVE_TO_HUNTING:22,
	DAMAGE:23,

};
var EWalkAnimation = {
	START: 0,
	END: 1,
};
var EGrow = {
	ADULT : 0,
	SUBADULT : 1,
	CHILD : 2,
	BABY : 3,
	FRUIT_BABY : 4,
};
var EDate = {
	MORNING : 0,
	NOON : 1,
	AFTERNOON : 2,
	EVENING : 3,
	NIGHT : 4,
	MIDNIGHT : 5
};
var ESearch = {
	UNUN: 0,
	FOOD: 1,
	YUKKURI: 2,
	PLACE: 3
};
var EFood = {
	BAD : 0,
	NORMAL : 1,
	GREAT : 2
};
var EExSkill = {
	NO_FOOD_IN_PLACE : 1,
	KEKKAI : 2,
};
var EMemory = {
	FOOD_IN_PLACE : 1,
};
var EDamage = {
	PICOHAN : 1
};
var ELooks = {
	GOOD_YUKKURI : 3,
	NORMAL_YUKKURI : 2,
	BAD_YUKKURI : 1,
};
var EAnimStatus = {
	UP : 0,
	DOWN : 1,
};
include("./lib/Animation.js"); 
include("./lib/FormSprite.js"); 
include("./lib/Util.js"); 


var ObjSprite = enchant.Class.create(enchant.Sprite,{
	initialize: function (w, h){
		enchant.Sprite.call(this, w, h);
		this.id = guid();
		ctl.addObj(this);
				// // new BoxLabel(this.ctl,100, e.x, e.y);
				// var box = new Box(this.ctl, 200, 200);
				// box.text("テスト\naaaaaa\nfffffffff\nテスト\naaaaaa\nfffffffff\nテスト\naaaaaa\n", e.x, e.y);
	},
	getStatusForDisplay: function (){
		return "";
	},
	getX: function(){
		return this.x;
	},
	getY: function(){
		return this.y;
	},
	getWidth: function(){
		return this.width;
	},
	getHeight: function(){
		return this.height;
	},
	isWorld: function(){
		return (this.id !== null && this.id !== undefined);
	},
	removeAll: function(){
		this.remove();
		ctl.removeObj(this);
		this.id = null;
	},
	undefineAll: function (){
		for(var key in this){
			// if(this.hasOwnProperty(key)){
				delete this[key];
			// }
		}
	}
});


enchant.Timeline.prototype.moveByEx = function(x, y, time, easing, eventFunctions){
	var params = {
		x: function() {
			return this.x + x;
		},
		y: function() {
			return this.y + y;
		},
		time: time,
		easing: easing
	};
	//-Event register [onactionstart,onactiontick,onactionend]
	if(eventFunctions !== undefined){
		for(var key in eventFunctions){
			params[key] = eventFunctions[key];
		}
	}
	return this.tween(params);
};
function plusFrameScale(frame, scale){
	return (frame/2) * (1 - scale)
}



include("./lang/ja.js");
window.onload = function(){
	var nodeSort = function (a, b){
		if(typeof a.id === "undefined" && typeof b.id === "undefined"){
			return 0;
		}
		else if(typeof a.id === "undefined"){
			return -1;
		}
		else if(typeof b.id === "undefined"){
			return 1;
		}
		var ay = a.y;
		var by = b.y;
		if(a instanceof Box && b instanceof Box){
			return 0;
		}
		if(a instanceof Box){
			return 1;
		}
		if(b instanceof Box){
			return -1;
		}
		var budgeValue = 10 + 28;
		var shadowValue = -28;
		//okazariは他のbodyと比べて11低い
		var okazariValue = 37 + 11;
		var okazariReimuValue = 32;
		var bodyValue = 37;
		var tweetValue = 288;
		var kukiValue = 143;
		var miYukkuriValue = 363;

		if(a.type == "shadow"){
			ay += shadowValue * a.scaleValue;
		}
		else if(a.type == "body" && a.classname == "Okazari" && a.spname == "reimu"){
			ay += okazariReimuValue * a.scaleValue - a.anim.cnt;
		}
		else if(a.type == "body"){
			ay += bodyValue * a.scaleValue - a.anim.cnt;
		}
		else if(a.type == "tweet"){
			ay += tweetValue * a.scaleValue;
		}
		else if(a.type == "budge"){
			ay += budgeValue * a.scaleValue - a.anim.cnt;
		}
		else if(a.type == "kuki"){
			ay += kukiValue * a.scaleValue - a.anim.cnt;
		}


		if(b.type == "shadow"){
			by += shadowValue * b.scaleValue;
		}
		else if(b.type == "body" && b.classname == "Okazari" && b.spname == "reimu"){
			by += okazariReimuValue * b.scaleValue - b.anim.cnt;
		}
		else if(b.type == "body" && b.classname == "Okazari"){
			by += okazariValue * b.scaleValue - b.anim.cnt;
		}
		else if(b.type == "body"){
			by += bodyValue * b.scaleValue - b.anim.cnt;
		}
		else if(b.type == "tweet"){
			by += tweetValue * b.scaleValue;
		}
		else if(b.type == "budge"){
			by += budgeValue * b.scaleValue - b.anim.cnt;
		}
		else if(b.type == "kuki"){
			by += kukiValue * b.scaleValue - b.anim.cnt;
		}



		if(a instanceof SpriteGroup){
			ay = a.y;
			ay += a.height/2;
		}
		if(b instanceof SpriteGroup){
			by = b.y;
			by += b.height /2;
		}
		if(a instanceof MiYukkuri){
			ay += miYukkuriValue * a.scaleValue - a.anim.cnt;
		}
		if(b instanceof MiYukkuri){
			console.log("M");
			by += miYukkuriValue * b.scaleValue - b.anim.cnt;
		}

		if(a instanceof Place){
			ay += Math.round(a.height * 0.7);
		}
		if(b instanceof Place){
			by += Math.round(b.height * 0.7);
		}
		// if(a.flgMiYukkuri){
		// 	ay += CHARA_HEIGHT;
		// }
		// if(b.flgMiYukkuri){
		// 	by += CHARA_HEIGHT;
		// }

		if(Math.round(ay) < Math.round(by))return -1;
		else if(Math.round(ay) > Math.round(by))return 1;
		if(a.id < b.id)return -1;
		else if(a.id > b.id)return 1;
		return 0;

	}

	//init game
	var def = new Object();
	var foodGroup = new Group();
	var SpriteGroup = enchant.Class.mixClasses(Sprite, Group,true);
	SpriteGroup.prototype.classname = "";
	var menuBg = new SpriteGroup(EMenuPos.WIDTH, EMenuPos.HEIGHT);
	var fieldBg = new enchant.Sprite(EFieldPos.WIDTH, EFieldPos.HEIGHT);
	var windowFront = new enchant.Sprite(EFieldPos.WIDTH, EFieldPos.HEIGHT);
	game = new Game(GAME_WIDTH, GAME_HEIGHT);
	game.fps = FPS;
	var _loadArr = [];
	var i=0;
	var tmpName = EResPathReimu.getName();
	i=0;
	for(var _v in EResPathReimu){
		if(typeof EResPathReimu[_v] === "function")continue;
		EResPath[_v + "_" + tmpName] = EResPathReimu[_v];
		i++;
	}
	tmpName = null;

	i=0;
	for(var _v in EResPath){
		_loadArr[i] = EResPath[_v];
		i++;
	}
	game.preload(_loadArr);
	var MapGroup = enchant.Class.mixClasses(Map, Group,true);
	var backgroundMap = new MapGroup(16, 16);
	App.backgroundMap = backgroundMap;
	include("./class.js");
	include("./ctrl.js");
	ctl = new Ctrl();
	ctl.init(game);
	ctl.setBackgroundMap(backgroundMap);
	var Action = enchant.Class.create({
		initialize: function (yukkuri){
			this.status = EAction.THINK;
			this.yukkuri = yukkuri;
			this.isMoving = false;
			this.targetNode = null;
		},
		getStatus: function(){
			return this.status;
		},
		setStatus: function(eaction){
			this.status = eaction;
		},
		observe: function(){
			if(this.yukkuri.isDead()){
				this.status = EAction.DEAD;
			}
			// else if(this.yukkuri.isSleep()){
			// 	this.status = EAction.SLEEP;
			// }

		},
		act : function(){
			this.observe();
			switch(this.status){
				case EAction.WAIT:
					this.waitCnt++;
					if(this.waitCnt >= BASE_FPS * 60 * 24 * 3){
						this.waitCnt = 0;
						this.setStatus(EAction.THINK);
						console.log("wait cnt end");
					}
				break;
				case EAction.THINK_IN_HOME:
					this.waitCnt = 0;
					this.search();
					this.think_in_home();
				break;
				case EAction.EAT_IN_HOME:
					this.eat_in_home();
				break;
				case EAction.THINK:
					this.waitCnt = 0;
					if(this.yukkuri.age%2 === 0){
						this.yukkuri.changeFace();
						this.search();
						this.yukkuri.searchObjectMang.callEvent(this.yukkuri);
					}
				break;
				case EAction.MOVE_TO_EAT_START:
					this.move_to_eat_start();
				break;
				case EAction.MOVE_TO_EAT_UNDERWAY:
				break;
				//Random Walk
				case EAction.WALK:
					this.walk(0);
				break;
				case EAction.SLEEP_START:
					this.sleep_start();
				break;
				case EAction.SLEEP_WAIT:
				break;
				case EAction.DEAD:
					this.dead();
				break;
				case EAction.EAT_START:
					this.eat_start();
				break;
				case EAction.EAT_WAIT:
				break;
				case EAction.UNUN_START:
					this.unun_start();
				break;
				case EAction.UNUN_WAIT:
				break;
				case EAction.MOVE_TO_COMMAND:
					this.move_to_command();
				break;
				case EAction.UNUN_SMELL_START:
					this.unun_smell_start();
				break;
				case EAction.COMMUNICATE_START:
					this.communicate_start();
				break;
				case EAction.COMMUNICATE_WAIT:
				case EAction.COMMUNICATE_RECV:
				if(this.yukkuri.communicateYukkuri != null){
					var _s = this.yukkuri.communicateYukkuri.action.getStatus();
					if(this.yukkuri.communicateYukkuri.isDead()
						|| (_s !== EAction.COMMUNICATE_START && _s !== EAction.COMMUNICATE_WAIT && _s !== EAction.COMMUNICATE_RECV)){
						this.setStatus(EAction.THINK);
						this.yukkuri.animation();
					}
				}
				break;
				case EAction.MOVE_TO_PLACE_START_HOMELESS:
					this.move_to_place_start_homeless();
				break;
				case EAction.DECLARE_PLACE_HOMELESS:
					this.declare_place_homeless();
				break;
				case EAction.MOVE_TO_HUNT_START:
					this.move_to_hunt_start();
				break;
				case EAction.HUNT_START:
					this.hunt_start();
				break;
				case EAction.MOVE_GOTO_HOME:
					this.move_goto_home();
				break;
				case EAction.IN_HOME:
					this.in_home();
				break;

			}
			this.yukkuri.reverse();
		},
		// thinkHavePlace: function(){
		// 	var date = ctl.getDate();
		// 	if(this.yukkuri.isPlaceRange()){
		// 	}else{
		// 		//ゆっくりプレイスの範囲外
		// 		if(date === EDate.EVENING
		// 			|| date === EDate.NIGHT
		// 			|| date === EDate.MIDNIGHT
		// 			){
		// 			this.setStatus(EAction.MOVE_GOTO_HOME);
		// 			return;
		// 		}
		// 		else if(date === EDate.EVENING){
		// 			// if(this.yukkuri.isItemsMax()){
		// 			// 	this.setStatus(EAction.IN_HOME);
		// 			// }
		// 			// else{
		// 			// 	this.setStatus(EAction.MOVE_TO_HUNT_START);
		// 			// }
		// 		}
		// 	}
		// 	if(this.yukkuri.isVeryKuhuku()){
		// 		//食べ物探したい

		// 		//なかったら
		// 		this.setStatus(EAction.MOVE_GOTO_HOME);
		// 	}
		// 	else if(this.yukkuri.isSleep()){
		// 		this.setStatus(EAction.SLEEP_START);
		// 	}
		// 	else if(this.yukkuri.getUnun() >= 80){
		// 		this.setStatus(EAction.UNUN_START);
		// 	}
		// 	else{
		// 		this.yukkuri.changeFace();
		// 		this.search();
		// 	}
		// },
		think_in_home: function(){
			var date = ctl.getDate();
			if((date === EDate.MIDNIGHT)
				&& !this.yukkuri.isSleep()
				&& !this.yukkuri.isVeryKuhuku()
				){
				new SleepEvent({
					"action": this,
					"nextStatus":EAction.THINK_IN_HOME,
					"myYukkuri": this.yukkuri
				});
				return;
			}
			else if(date === EDate.EVENING){
				//QK
			}
			else if(this.yukkuri.isVeryKuhuku() && this.yukkuri.getPlace().isFood()){
				this.setStatus(EAction.EAT_IN_HOME);
			}
			else{
				//marisa is hunting move
				if(this.yukkuri.beforeHuntingFood !== null){
					new MoveToHuntEvent({
						"type": 'food',
						"targetNode": this.yukkuri.beforeHuntingFood,
						"action": this,
						"myYukkuri": this.yukkuri
					});
					return;
				}else{
					this.setStatus(EAction.WALK);
				}
			}
		},
		eat_in_home: function(){
			new EatInHomeEvent({
				"targetNode": this.yukkuri.getPlace(),
				"action": this,
				"myYukkuri": this.yukkuri
			});
		},
		move_to_eat_start : function(){
			new MoveToEatEvent({
				"type": 'food',
				"targetNode": this.targetNode,
				"action": this,
				"myYukkuri": this.yukkuri
			});
		},
		walkNew: function(){

		},
		walk : function(retryCounter){
			if(retryCounter > 15){
				retryCounter = 0;
				this.status = EAction.NONE;
				console.log("retryCount over");
				return;
			}
			if(this.yukkuri.formSprite.tlQueueLength() === 0){
			// if(this.yukkuri.imgGroup.tl.queue.length === 0){
				var frame = 200;
				frame += plusFrameScale(frame, this.yukkuri.getMyScale());
				if(this.isMoving){
					this.isMoving = false;
					this.status = EAction.THINK;
					this.yukkuri.vx = 0;
					this.yukkuri.vy = 0;
				}else{
					var xpos = 150 + rand(40) - (retryCounter * 10);
					var ypos = 150 + rand(40) - (retryCounter * 10);
					if(false){
						this.yukkuri.vx = xpos;
						this.yukkuri.vy = ypos;
						this.yukkuri.setDirection(EDirection.RIGHT);
					}
					else if(rand(8) === 0){
						this.yukkuri.vx = 0;
						this.yukkuri.vy = -ypos;
					}
					else if(rand(8) == 1){
						this.yukkuri.vx = xpos;
						this.yukkuri.vy = -ypos;
						this.yukkuri.setDirection(EDirection.RIGHT);
					}
					else if(rand(8) == 2){
						this.yukkuri.vx = xpos;
						this.yukkuri.vy = 0;
						this.yukkuri.setDirection(EDirection.RIGHT);
					}
					else if(rand(8) == 3){
						this.yukkuri.vx = xpos;
						this.yukkuri.vy = ypos;
						this.yukkuri.setDirection(EDirection.RIGHT);
					}
					else if(rand(8) == 4){
						this.yukkuri.vx = 0;
						this.yukkuri.vy = ypos;
					}
					else if(rand(8) == 5){
						this.yukkuri.vx = -xpos;
						this.yukkuri.vy = ypos;
						this.yukkuri.setDirection(EDirection.LEFT);
					}
					else if(rand(8) == 6){
						this.yukkuri.vx = -xpos;
						this.yukkuri.vy = 0;
						this.yukkuri.setDirection(EDirection.LEFT);
					}
					else if(rand(8) == 7){
						this.yukkuri.vx = -xpos;
						this.yukkuri.vy = -ypos;
						this.yukkuri.setDirection(EDirection.LEFT);
					}
					if (this.yukkuri.vx || this.yukkuri.vy) {
						var map = ctl.backgroundMap;
						// var x = this.yukkuri.x + (this.yukkuri.moveX ? this.yukkuri.moveX / Math.abs(this.yukkuri.moveX) * 16 : 0) + 16;
						// var y = this.yukkuri.y + (this.yukkuri.moveY ? this.yukkuri.moveY / Math.abs(this.yukkuri.moveY) * 16 : 0) + 16;
						var x = this.yukkuri.getX() + this.yukkuri.vx;
						var y = this.yukkuri.getY() + this.yukkuri.vy + this.yukkuri.getHeight() / 2;
						if (0 <= x && x < map.width && 0 <= y && y < map.height && !map.hitTest(x, y)) {
							// console.log("あたってないよ:"+ this.yukkuri.getX() + ":" + this.yukkuri.getY());
							// console.log("X:" + this.yukkuri.moveX);
							// console.log("Y:" + this.yukkuri.moveY);
							this.isMoving = true;
							this.yukkuri.reverse();
							this.yukkuri.moveBy(this.yukkuri.vx, this.yukkuri.vy, frame);
							mangMsg.output(this.yukkuri,EMsg.WALK);
							//うんうんくさい対策
							this.targetNode = null;
						}else{
							// console.log("HIT:"+ this.yukkuri.getX() + ":" + this.yukkuri.getY() + "," + this.yukkuri.vx + ":" + this.yukkuri.vy);
							this.walk(retryCounter+1);
						}
					}
				}
			}
		},
		sleep_start: function(){
			new SleepEvent({
				"action": this,
				"myYukkuri": this.yukkuri
			});
		},
		dead : function(){
			mangMsg.output(this.yukkuri, EMsg.DEAD);
			this.yukkuri.tlPause();
			this.yukkuri.setBodyImage(EBody.DEAD);
		},
		eat_start: function(){
			new EatEvent({
				"type": 'eat',
				"targetNode": this.targetNode,
				"action": this,
				"myYukkuri": this.yukkuri
			});

		},
		unun_start: function(){
			new UnunEvent({
				"action": this,
				"myYukkuri": this.yukkuri
			});
		},
		unun_smell_start: function(){
			new UnunSmellEvent({
				"action": this,
				"myYukkuri": this.yukkuri
			});
		},
		communicate_start:function(){
			new ComSayHelloSendEvent({
				"type": 'greeting',
				"targetNode": this.targetNode,
				"action": this,
				"myYukkuri": this.yukkuri
			});
		},
		move_to_place_start_homeless:function(){
			new MoveToPlaceStartHomelessEvent({
				"targetNode": this.targetNode,
				"action": this,
				"myYukkuri": this.yukkuri
			});
		},
		declare_place_homeless:function(){
			new DeclarePlaceHomelessEvent({
				"targetNode": this.targetNode,
				"action": this,
				"myYukkuri": this.yukkuri
			});
		},
		move_to_hunt_start:function(){
			new MoveToHuntEvent({
				"type": 'food',
				"targetNode": this.targetNode,
				"action": this,
				"myYukkuri": this.yukkuri
			});
		},
		hunt_start:function(){
			new HuntStartEvent({
				"type": 'food',
				"targetNode": this.targetNode,
				"action": this,
				"myYukkuri": this.yukkuri
			});
		},
		move_goto_home:function(){
			var place = this.yukkuri.getPlace();
			new MoveGotoHomeEvent({
				"type": 'hunt_end',
				"targetNode": place,
				"action": this,
				"myYukkuri": this.yukkuri
			});
		},
		in_home:function(){
			var place = this.yukkuri.getPlace();
			if(place != null && place.isWorld()){
				new InHomeEvent({
					"type": 'hunt_end',
					"targetNode": place,
					"action": this,
					"myYukkuri": this.yukkuri
				});
			}else{
				if(place && !place.isWorld())place.undefineAll();
				this.yukkuri.declarePlace(null);
				this.setStatus(EAction.WAIT);
				mangMsg.output(this.yukkuri, EMsg.LOST_HOUSE);
				this.yukkuri.setFaceImage(EFace.CRY2);
				new WaitEvent({
					"waitframe": FPS * 3.0,
					"action": this,
					"myYukkuri": this.yukkuri
				});
			}
		},
		move_to_command: function(){
			var obj = this.yukkuri.searchObjectMang.currentCmdObject;
			new MoveToCommandEvent({
				"action": this,
				"cmdObject": obj,
				"myYukkuri": this.yukkuri
			});

		},
		search: function(){
			this.yukkuri.clearSearchObject();
			var nodes = ctl.getObjs();
			l = nodes.length;
			var ununFlg = false;
			for (var key in nodes) {
				var node = nodes[key];
				if(node === null || node === undefined)continue;
				if(this.yukkuri.id === node.id)continue;
				//うんうん臭いを検索
				if (
					node instanceof Unun
					&& !(this.targetNode instanceof Unun)
					&& this.yukkuri.within(node, this.yukkuri.getRange() / 3)) {

					this.yukkuri.addSearchObject(ESearch.UNUN, node);
				}
				//食べ物を検索
				else if (node instanceof Food && node.amount > 0) {
					if(this.yukkuri.within(node, this.yukkuri.getRange())){
						this.yukkuri.addSearchObject(ESearch.FOOD, node);
					}
				}
				//ゆっくりを検索
				else if(node instanceof Yukkuri){
					if(node.grow != EGrow.FRUIT_BABY && this.yukkuri.within(node, this.yukkuri.getRange())){
						this.yukkuri.addSearchObject(ESearch.YUKKURI, node);
					}
				}
				//ゆっくりプレイスを検索
				else if(node instanceof Place){
					if(this.yukkuri instanceof Player){
					}
					if(this.yukkuri.within(node, this.yukkuri.getRange())){
						this.yukkuri.addSearchObject(ESearch.PLACE, node);
					}
				}
			}
			this.status =  EAction.WALK;
		}
	});
/**
 * Range範囲内のObjSprを管理する
 * 注意！：ゆっくりプレイスを持って入るもののみ使用される
 * @param  {[type]} )
 * @return {[type]}
 */
	var SearchObjectMang = enchant.Class.create({
		initialize: function (){
			this.init();
			this.currentCmdObject = null;
		},
		init:function(){
			this.datas = [];
			for(var key in ESearch){
				var esearch = ESearch[key];
				this.datas[esearch] = [];
			}
		},
		add :function(esearch, node){
			this.datas[esearch].push(node);
		},
		clear :function(){
			for(var key in ESearch){
				var esearch = ESearch[key];
				this.datas[esearch].length = 0;
			}
			// this.datas.length = 0;
			// this.init();
		},
		get:function (esearch){
			return this.datas[esearch];
		},
		getNear:function (esearch, yukkuri){
			var objects = this.datas[esearch];
			var nearDistance = null;
			var ret = null;
			for(var i=0;i<objects.length;i++){
				var object = objects[i];
				var nowDistance = object.getX() + object.getY() - yukkuri.getX() + yukkuri.getY();
				if(nearDistance === null || nearDistance > nowDistance){
					nearDistance = nowDistance;
					ret = object;
				}
			}
			return ret;
		},
		callEvent: function(yukkuri){
			if(yukkuri.cmdQueue.length !== 0){
				this.currentCmdObject = yukkuri.cmdQueue.shift();
				yukkuri.action.setStatus(EAction.MOVE_TO_COMMAND);
				return;
			}
			if(yukkuri.isSleep()){
				yukkuri.action.setStatus(EAction.SLEEP_START);
				return;
			}
			else if(yukkuri.getUnun() >= 80){
				yukkuri.action.setStatus(EAction.UNUN_START);
				return;
			}

			if(yukkuri.isItemsMax() && yukkuri.isPlace()){
				yukkuri.action.targetNode = yukkuri.getPlace();
				yukkuri.action.setStatus(EAction.MOVE_GOTO_HOME);
				return;
			}
			if(yukkuri.isVeryKuhuku()){
				//エサを探す
				var foods = this.get(ESearch.FOOD);
				if(foods.length > 0){
					var foods = this.get(ESearch.FOOD);
					food = this.getNear(ESearch.FOOD, yukkuri);
					if(food !== null){
						yukkuri.action.targetNode = food;
						yukkuri.action.setStatus(EAction.MOVE_TO_EAT_START);
						return;
					}
				}
				if(yukkuri.getMemory(EMemory.FOOD_IN_PLACE) === 0 && yukkuri.getExSkill(EExSkill.NO_FOOD_IN_PLACE) >= 1){
					yukkuri.action.setStatus(EAction.WALK);
					return;
				}

				//家があるなら家に帰宅
				if(foods.length === 0 && yukkuri.isPlace() && yukkuri.getPlace().isFood()){
					yukkuri.action.targetNode = yukkuri.getPlace();
					yukkuri.action.setStatus(EAction.MOVE_GOTO_HOME);
					return;
				}
				//たべものを探しに行く
				yukkuri.action.setStatus(EAction.WALK);
				return;
			}



			if(!yukkuri.isItemsMax() && yukkuri.isPlace()){
				food = this.getNear(ESearch.FOOD, yukkuri);
				if(food !== null){
					yukkuri.action.targetNode = food;
					yukkuri.action.setStatus(EAction.MOVE_TO_HUNT_START);
					return;
				}
			}
			ununs = this.get(ESearch.UNUN);
			if(ununs.length !== 0){
				yukkuri.action.targetNode = yukkuri.getPlace();
				yukkuri.action.setStatus(EAction.UNUN_SMELL_START);
				return;
			}
			var searchYukkuri = this.getNear(ESearch.YUKKURI, yukkuri);
			if(searchYukkuri !== null && yukkuri.isCommunication(searchYukkuri)){
				yukkuri.action.targetNode = searchYukkuri;
				yukkuri.action.setStatus(EAction.COMMUNICATE_START);
				return;
			}
			if(!yukkuri.isPlace()){
				var searchYukkuri = this.getNear(ESearch.PLACE, yukkuri);
				if(searchYukkuri != null && !searchYukkuri.isOwner()){
					yukkuri.action.targetNode = searchYukkuri;
					yukkuri.action.setStatus(EAction.MOVE_TO_PLACE_START_HOMELESS);
					return;
				}
			}
			yukkuri.action.setStatus(EAction.WALK);

		}

	});
	var Event = enchant.Class.create({
		initialize: function (_data){
			this.guid = guid();
		},
		onactionstart:function(self){
			return this._onactionstart;
		},
		_onactionstart:function(e){
			if(typeof e === "undefined")return;
		},
		onactiontick:function(self){
			return function(e){
				if(typeof e === "undefined")return;
			};
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
			};
		}
	});
	var WalkEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = _data.myYukkuri;
			this.action = _data.action;

			mangMsg.output(this.yukkuri, EMsg.SLEEP);
			this.action.setStatus(EAction.SLEEP_WAIT);
			this.yukkuri.setFaceImage(EFace.SLEEP);
			this.yukkuri.tlPause();
			var self = this;
			this.yukkuri.addEventListener('enterframe', function() {
				var yukkuri = self.yukkuri;
				self.run();
			});
		},
		run : function(){

		}
	});
	var SleepEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = _data.myYukkuri;
			this.action = _data.action;

			mangMsg.output(this.yukkuri, EMsg.SLEEP);
			this.action.setStatus(EAction.SLEEP_WAIT);
			this.yukkuri.setFaceImage(EFace.SLEEP);
			this.yukkuri.tlPause();
			var sec = FPS * 3;
			var self = this;
			this.yukkuri.addEventListener('enterframe', function() {
				var yukkuri = self.yukkuri;
				if(yukkuri.age%2 === 0 && yukkuri.age !== 0)yukkuri.param.sleep--;
				if(yukkuri.param.sleep <= 0){
					yukkuri.param.sleep = 0;
					this.removeEventListener("enterframe",arguments.callee);
					mangMsg.output(self.yukkuri, EMsg.GET_UP);
					yukkuri.setFaceImage(EFace.NORMAL);
					yukkuri.tlResume();
					// self.action.setStatus(EAction.WAIT);
					if(self.data.nextStatus !== undefined){
						self.action.setStatus(self.data.nextStatus);
					}else{
						self.action.setStatus(EAction.THINK);
					}
				}
			});
		}
	});

	var UnunEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = _data.myYukkuri;
			this.action = _data.action;
			this.action.setStatus(EAction.UNUN_WAIT);
			mangMsg.output(this.yukkuri, EMsg.UNUN);
			this.yukkuri.setFaceImage(EFace.HAPPY2);
			var sec = FPS * 3;

			this.yukkuri.wait(sec, {
				"onactionend": this.onactionend(this)
			});
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.yukkuri.unun();
				self.action.setStatus(EAction.WAIT);
				mangMsg.output(self.yukkuri, EMsg.UNUN_END);
				new WaitEvent({
					"waitframe": FPS * 1.5,
					"action": self.action,
					"myYukkuri": self.yukkuri
				});
			};
		}
	});
	var WaitEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = _data.myYukkuri;
			this.action = _data.action;
			this.waitframe = _data.waitframe;
			this.yukkuri.wait(this.waitframe, {
				"onactionstart": this.onactionstart(this),
				"onactiontick": this.onactiontick(this),
				"onactionend": this.onactionend(this)
			});
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.action.setStatus(EAction.THINK);
			};
		}
	});
	var UnunSmellEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = _data.myYukkuri;
			this.action = _data.action;
			this.action.setStatus(EAction.UNUN_SMELL_WAIT);
			mangMsg.output(this.yukkuri, EMsg.UNUN_SMELL);
			this.yukkuri.setFaceImage(EFace.CRY1);
			var sec = FPS * 3;
			this.yukkuri.setYukkuri(this.yukkuri.getYukkuri() - 3);
			this.yukkuri.wait(sec, {
				"onactionend": this.onactionend(this)
			});
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.action.setStatus(EAction.WALK);
			};
		}
	});

	var EatEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = _data.myYukkuri;
			this.food = _data.targetNode;
			this.action = _data.action;
			this.action.setStatus(EAction.EAT_WAIT);

			var sec = BASE_FPS * 3;
			if(this.yukkuri.eat(this.food)){
				mangMsg.output(this.yukkuri, EMsg.EAT);
				this.yukkuri.setFaceImage(EFace.EAT2);
			}else{
				sec = BASE_FPS * 6;
				mangMsg.output(this.yukkuri, EMsg.EAT_FAILED);
				this.yukkuri.setFaceImage(EFace.CRY2);
			}
			this.yukkuri.wait(sec, {
				"onactionend": this.onactionend(this)
			});
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				if(self.food == null || self.food.getAmount() <= 0 || self.yukkuri.isManpuku() || !self.food.isWorld()){
					self.action.setStatus(EAction.THINK);
					self.yukkuri.setFaceImage(EFace.NORMAL);
				}else{
					self.action.setStatus(EAction.EAT_START);
				}
			};
		}
	});
	/**
	 * Move Event
	 * -When yukkuri find Food.
	 * @param  _data
	 * type: "food"
	 * targetNode: enchant.Node
	 * action:Action
	 * myYukkuri:Yukkuri
	 */
	var MoveToEatEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = this.data.myYukkuri;
			this.action = this.data.action;

			var yukkuri = this.yukkuri;
			var node = this.data.targetNode;
			//food distance
			if(this.data.type == "food"){
				this.action.status = EAction.MOVE_TO_EAT_UNDERWAY;
				yukkuri.vx = node.x - yukkuri.getX() + node.width / 2 + yukkuri.getWidth() / 2;
				yukkuri.vy = node.y - yukkuri.getY() - yukkuri.getHeight() / 2 + node.height / 2 + yukkuri.getHeight() / 2;
				var distance = (Math.abs(yukkuri.vx) + Math.abs(yukkuri.vy)) / 2;
				var frame = distance + distance/5 + 1;
				frame += plusFrameScale(frame, this.yukkuri.getMyScale());
				yukkuri.setAutoDirection();
				yukkuri.reverse();
				mangMsg.output(yukkuri, EMsg.TARGETING_EAT);

				yukkuri.moveBy(yukkuri.vx, yukkuri.vy, frame, {
					"onactiontick": this.onactiontick(this),
					"onactionend": this.onactionend(this)
				});
			}
		},
		onactiontick:function(self){
			return function(e){
				if(typeof e === "undefined")return;
			};
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.action.setStatus(EAction.EAT_START);
			};
		}
	});
	var MoveToHuntEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = this.data.myYukkuri;
			this.action = this.data.action;

			var yukkuri = this.yukkuri;
			var node = this.data.targetNode;
			var nodeX = node.x;
			var nodeY = node.y;
			var nodeWidth = node.width;
			var nodeHeight = node.height;
			node = null;

			//food distance
			if(this.data.type == "food"){
				this.action.setStatus(EAction.WAIT);
				yukkuri.vx = nodeX - yukkuri.getX() + yukkuri.getWidth() / 2;
				yukkuri.vy = nodeY - yukkuri.getY() - yukkuri.getHeight() / 2 + nodeHeight / 2 + yukkuri.getHeight() / 2;
				var distance = (Math.abs(yukkuri.vx) + Math.abs(yukkuri.vy)) / 2;
				var frame = distance + distance/5 + 1;
				frame += plusFrameScale(frame, this.yukkuri.getMyScale());
				yukkuri.setAutoDirection();
				yukkuri.reverse();
				mangMsg.output(yukkuri, EMsg.MOVE_TO_HUNTING);

				yukkuri.moveBy(yukkuri.vx, yukkuri.vy, frame, {
					"onactionend": this.onactionend(this)
				});
			}
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.action.setStatus(EAction.HUNT_START);
			};
		}
	});
	var HuntStartEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			Event.call(this, _data);
			this.initCnt = 0;
			this.data = _data;
			this.yukkuri = _data.myYukkuri;
			this.food = _data.targetNode;
			this.action = _data.action;
			this.action.setStatus(EAction.WAIT);
			this.huntingStatus = "hunting";
			this.tick = 0;
			// this.yukkuri.beforeHuntingFood = this.food;
			if(this.food.isWorld()){
				this.yukkuri.beforeHuntingFood = new MemoryFood(this.food);
				var sec = BASE_FPS * 8;
				if(this.yukkuri.hunt(this.food)){
					this.huntingStatus = "hunting";
					mangMsg.output(this.yukkuri, EMsg.HUNTING_MESSAGE);
					this.yukkuri.setFaceImage(EFace.HAPPY1);
				}else{
					if(this.yukkuri.isItemsMax()){
						sec = 1;
						this.huntingStatus = "return";
						// mangMsg.output(this.yukkuri, EMsg.REHUNT);
						this.yukkuri.setFaceImage(EFace.NORMAL);
					}else{
						sec = BASE_FPS * 3;
						this.huntingStatus = "cry";
						mangMsg.output(this.yukkuri, EMsg.EAT_FAILED);
						this.yukkuri.setFaceImage(EFace.CRY2);
					}
				}

			}else{
				this.yukkuri.beforeHuntingFood = null;
				sec = BASE_FPS * 3;
				this.huntingStatus = "cry";
				mangMsg.output(this.yukkuri, EMsg.EAT_FAILED);
				this.yukkuri.setFaceImage(EFace.CRY2);
			}

			this.yukkuri.wait(sec, {
				"onactiontick": this.onactiontick(this),
				"onactionend": this.onactionend(this)
			});
		},
		onactiontick:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.tick++;
				if(self.huntingStatus == "hunting" && self.tick > BASE_FPS * 1){
					if(this.age%(BASE_FPS * 5) == 0){
						// mangMsg.output(self.yukkuri, EMsg.YYUYYU)
						mangMsg.output(self.yukkuri, EMsg.HUNTING_MESSAGE);
					}
				}
			};
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				if(self.huntingStatus == "hunting"){
					if(self.yukkuri.isItemsMax()){
						self.action.setStatus(EAction.MOVE_GOTO_HOME);
						// mangMsg.output(self.yukkuri, EMsg.MOVE_GOTO_HOME);
					}else{
						self.action.setStatus(EAction.HUNT_START);
					}
				}
				else if(self.huntingStatus == "return"){
					self.action.setStatus(EAction.MOVE_GOTO_HOME);
				}
				else if(self.huntingStatus === "cry"){
					// self.action.setStatus(EAction.THINK);
					self.action.setStatus(EAction.WALK);
				}
				self.release();
			};
		},
		release:function(){
			this.action = null;
			this.yukkuri = null;
			this.food = null;
			this.data = null;
		}
	});
	var MoveGotoHomeEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = this.data.myYukkuri;
			this.action = this.data.action;

			var yukkuri = this.yukkuri;
			var place = this.data.targetNode;
			//food distance
			if(this.data.type == "hunt_end"){
				this.action.setStatus(EAction.WAIT);
				yukkuri.vx = place.x - yukkuri.getX() + place.width / 2;
				yukkuri.vy = place.y - yukkuri.getY() - yukkuri.getHeight() / 2 + place.height;
				var distance = (Math.abs(yukkuri.vx) + Math.abs(yukkuri.vy)) / 2;
				var frame = distance + distance/2 + 1 ;
				frame += plusFrameScale(frame, this.yukkuri.getMyScale());
				yukkuri.setAutoDirection();

				yukkuri.reverse();
				mangMsg.output(this.yukkuri, EMsg.MOVE_GOTO_HOME)

				yukkuri.moveBy(yukkuri.vx, yukkuri.vy, frame, {
					"onactiontick": this.onactiontick(this),
					"onactionend": this.onactionend(this)
				});
			}
		},
		onactiontick:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				if(this.age%(BASE_FPS * 5) == 0){
					mangMsg.output(self.yukkuri, EMsg.YYUYYU)
				}
			};
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.action.setStatus(EAction.IN_HOME);
				self.release();
			};
		},
		release:function(){
			this.action = null;
			this.yukkuri = null;
			this.data = null;
		}
	});
	var InHomeEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = this.data.myYukkuri;
			this.action = this.data.action;

			var yukkuri = this.yukkuri;
			var place = this.data.targetNode;

			if(yukkuri.isVeryKuhuku()){
				if(place.isFood()){
					yukkuri.setMemory(EMemory.FOOD_IN_PLACE, 1);
					this.action.setStatus(EAction.EAT_IN_HOME);
					return;
				}else{
					yukkuri.setMemory(EMemory.FOOD_IN_PLACE, 0);
					//experience skill
					if(yukkuri.getExSkill(EExSkill.NO_FOOD_IN_PLACE) >= 1){
						mangMsg.output(yukkuri, EMsg.LEARN_NO_FOOD_IN_PLACE);
						this.action.setStatus(EAction.THINK);
						return;
					}else{
						mangMsg.output(yukkuri, EMsg.EAT_FAILED);
						yukkuri.addExValue(EExSkill.NO_FOOD_IN_PLACE, 50);
					}

				}
			}
			this.action.setStatus(EAction.WAIT);
			var items = this.yukkuri.getItems();
			if(items.length > 0){
				place.setItems(items);
			}else{

			}
			var sec = BASE_FPS * 10;
			if(place.isFood())yukkuri.setMemory(EMemory.FOOD_IN_PLACE, 1);
			this.yukkuri.wait(sec, {
				"onactiontick": this.onactiontick(this),
				"onactionend": this.onactionend(this)
			});
		},
		onactiontick:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				if(this.age%(BASE_FPS * 5) == 0){
					mangMsg.output(self.yukkuri, EMsg.YYUYYU)
				}
			};
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.action.setStatus(EAction.THINK_IN_HOME);
			};
		}
	});
	var EatInHomeEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = _data.myYukkuri;
			this.place = _data.targetNode;
			this.action = _data.action;
			this.action.setStatus(EAction.EAT_WAIT);

			var sec = BASE_FPS * 3;
			var foodHash = this.place.getFoodHash();
			if(foodHash !== false && this.yukkuri.eat(foodHash)){
				mangMsg.output(this.yukkuri, EMsg.EAT);
				this.yukkuri.setFaceImage(EFace.EAT2);
			}else{
				sec = BASE_FPS * 6;
				mangMsg.output(this.yukkuri, EMsg.EAT_FAILED);
				this.yukkuri.setFaceImage(EFace.CRY2);
			}

			this.yukkuri.wait(sec, {
				"onactionend": this.onactionend(this)
			});
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				if(self.place.isFood() && !self.yukkuri.isManpuku()){
					self.action.setStatus(EAction.EAT_IN_HOME);

					// new EatInHomeEvent({
					// 	"targetNode": self.place,
					// 	"action": self.action,
					// 	"myYukkuri": self.yukkuri
					// });
				}else{
					self.action.setStatus(EAction.THINK_IN_HOME);
					self.yukkuri.setFaceImage(EFace.NORMAL);
				}
			};
		}
	});


	var MoveToCommandEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = this.data.myYukkuri;
			this.action = this.data.action;
			// this.vx = this.data.cmdObject.vx;
			// this.vy = this.data.cmdObject.vy;
			// var vx = (-backgroundMap.x + e.x) - this.ctl.player.getX() ;


			var yukkuri = this.yukkuri;
			this.action.status = EAction.WAIT;
			yukkuri.vx = this.data.cmdObject.touchX - this.yukkuri.getX();
			yukkuri.vy = this.data.cmdObject.touchY - this.yukkuri.getY();
			var distance = (Math.abs(yukkuri.vx) + Math.abs(yukkuri.vy)) / 2;
			var frame = distance + distance/2 + 1;
			frame += plusFrameScale(frame, this.yukkuri.getMyScale());

			yukkuri.setAutoDirection();

			yukkuri.moveBy(yukkuri.vx, yukkuri.vy, frame, {
				"onactiontick": this.onactiontick(this),
				"onactionend": this.onactionend(this)
			});
		},
		onactiontick:function(self){
			return function(e){
				if(typeof e === "undefined")return;
			};
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.action.setStatus(EAction.THINK);
			};
		}
	});
	/**
	 * Say hello contact to send communication .
	 */
	var ComSayHelloSendEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = _data.myYukkuri;
			this.targetYukkuri = _data.targetNode;
			this.action = _data.action;
			this.action.setStatus(EAction.COMMUNICATE_WAIT);
			// this.targetYukkuri.action.setStatus(EAction.COMMUNICATE_RECV);
			// this.targetYukkuri.tlPause();
			mangMsg.output(this.yukkuri, EMsg.SAY_HELLO, this.targetYukkuri);
			this.yukkuri.send(this.targetYukkuri, {
				"actionStatus":EAction.COMMUNICATE_RECV,
				"yukkuri":this.yukkuri
			});


			this.yukkuri.tlPause();
			this.yukkuri.syncDirection(this.targetYukkuri);

			this.yukkuri.addAddress(this.targetYukkuri);
			this.yukkuri.getAddress(this.targetYukkuri).isGreeting = true;

			var sec = BASE_FPS * 2;
			this.yukkuri.wait(sec, {
				"onactiontick": this.onactiontick(this),
				"onactionend": this.onactionend(this)
			});
		},
		onactiontick:function(self){
			return function(e){
				if(typeof e === "undefined")return;
			};
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				new ComSayHelloRecvEvent({
					"type": 'greeting',
					"targetNode": self.yukkuri,
					"action": self.targetYukkuri.action,
					"myYukkuri": self.targetYukkuri
				});
			};
		}
	});
	var ComSayHelloRecvEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = _data.myYukkuri;
			this.targetYukkuri = _data.targetNode;
			this.action = _data.action;
			mangMsg.output(this.yukkuri, EMsg.SAY_HELLO, this.targetYukkuri);
			this.yukkuri.addAddress(this.targetYukkuri);
			this.yukkuri.getAddress(this.targetYukkuri).isGreeting = true;

			var sec = BASE_FPS * 2;
			this.yukkuri.wait(sec, {
				"onactiontick": this.onactiontick(this),
				"onactionend": this.onactionend(this)
			});
		},
		onactiontick:function(self){
			return function(e){
				if(typeof e === "undefined")return;
			};
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.action.setStatus(EAction.THINK);

				self.yukkuri.action.setStatus(EAction.THINK);
				self.yukkuri.animation();
				self.targetYukkuri.action.setStatus(EAction.THINK);
				self.targetYukkuri.animation();
			};
		}
	});
	var MoveToPlaceStartHomelessEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = this.data.myYukkuri;
			this.action = this.data.action;

			var yukkuri = this.yukkuri;
			var node = this.data.targetNode;

			this.action.status = EAction.MOVE_TO_PLACE_HOMELESS_UNDERWAY;
			yukkuri.vx = node.x + node.width /2  - yukkuri.getX();
			yukkuri.vy = node.y + node.height - yukkuri.getY() - yukkuri.getHeight() / 2;
			var distance = (Math.abs(yukkuri.vx) + Math.abs(yukkuri.vy)) / 2;
			var frame = distance + distance/5 + 1;
			frame += plusFrameScale(frame, this.yukkuri.getMyScale());

			yukkuri.setAutoDirection();
			yukkuri.reverse();
			yukkuri.moveBy(yukkuri.vx, yukkuri.vy, frame, {
				"onactionend": this.onactionend(this)
			});
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.action.setStatus(EAction.DECLARE_PLACE_HOMELESS);
				self.data = null;
				self.yukkuri = null;
				self.action = null;
			};
		}
	});
	var DeclarePlaceHomelessEvent = enchant.Class.create(Event,{
		initialize: function (_data){
			this.data = _data;
			this.yukkuri = _data.myYukkuri;
			this.place = _data.targetNode;
			this.action = _data.action;
			this.action.setStatus(EAction.WAIT);


			var sec = BASE_FPS * 3;
			this.yukkuri.declarePlace(this.place);
			this.place.setOwner(this.yukkuri);
			mangMsg.output(this.yukkuri, EMsg.DECLARE_PLACE);

			this.yukkuri.setFaceImage(EFace.NORMAL);
			this.yukkuri.wait(sec, {
				"onactionend": this.onactionend(this)
			});
		},
		onactionend:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				self.action.setStatus(EAction.THINK);
			};
		}
	});

	var Food = enchant.Class.create(ObjSprite,{
		initialize: function (type, x, y){
			this.classname = "Food";
			//一つにつきgiveの値分、hunguryを減少させられる
			if(type == "apple"){
				ObjSprite.call(this,16,16);
				this.image = game.assets[EResPath.OBJECT];
				this.frame = 15;
				this.give = 40;
				this.amount = 3;
			}else if(type == "grass"){
				ObjSprite.call(this,64,64);
				this.image = game.assets[EResPath.GRASS];
				this.frame = 0;
				this.give = 10;
				this.amount = 20;
			}
			this.x = x;
			this.y = y;
			foodGroup.addChild(this);
			this.addEventListener('enterframe', function(){
				if(this.amount <= 0){
					this.removeAll();
				}
			});
		},
		getAmount: function(){
			return this.amount;
		},
		getGive: function(){
			return this.give;
		}
	});
	var MemoryPlace = enchant.Class.create({
		// initialize: function (place){
		// 	if(place.x != null){
		// 		this.isWorld = true;
		// 	}else{
		// 		this.isWorld = false;
		// 	}
		// 	this.isWorld = (place.x != null);
		// 	this.x = place.x;
		// 	this.y = place.y;
		// 	this.width = place.width;
		// 	this.height = place.height;
		// },
		// isWorld: function(){
		// 	return this.isWorld;
		// }

	});
	var MemoryFood = enchant.Class.create({
		initialize: function (food){
			if(food.x != null){
				this.isWorld = true;
			}else{
				this.isWorld = false;
			}
			this.isWorld = (food.x != null);
			this.x = food.x;
			this.y = food.y;
			this.width = food.width;
			this.height = food.height;
		},
		isWorld: function(){
			return this.isWorld;
		}
	});
	var Place = enchant.Class.create(ObjSprite,{
		initialize: function (type, x, y){
			ObjSprite.call(this,128,128);
			this.image = game.assets[EResPath.PLACE_TREE];
			this.x = x - this.width / 2;
			this.y = y - this.height / 2;
			backgroundMap.addChild(this);
			this.owner = null;
			this.foods = [];
			for(var key in EFood){
				var efood = EFood[key];
				this.foods[efood] = 0;
			}
			// this.addEventListener('enterframe', function(){
			// 	if(this.age%10 === 0 && this.age !== 0){
			// 		console.log("x/y " + this.x + "/" + this.y);
			// 	}
			// 	if(game.input.left){
			// 		this.x -= 10;;
			// 	}
			// 	if(game.input.right){
			// 		this.x += 10;;
			// 	}
			// 	if(game.input.up){
			// 		this.y -= 10;;
			// 	}
			// 	if(game.input.down){
			// 		this.y += 10;;
			// 	}
			// });
		},
		getStatusForDisplay: function(){
			var ret = "";
			var ownerId = "なし";
			if(this.owner == null)ownerId = "なし";
			else ownerId = this.owner.id;
			ret += "プレイスID　" + this.id + "\n";
			ret += "オーナーID　" + ownerId + "\n";
			ret += "食料うめぇ　 " + this.foods[EFood.GREAT] + "\n";
			ret += "食料それなりー　" + this.foods[EFood.NORMAL] + "\n";
			ret += "食料にがにが　 " + this.foods[EFood.BAD] + "\n";
			return ret;
		},
		setItems:function(items){
			var len = items.length;
			for(var i=0; i<len; i++){
				var item = items[i];
				if(item instanceof Food){
					this.foods[EFood.NORMAL]++;
				}
			}
			items.length = 0;
		},
		isFood:function(){
			var ret = 0;
			for(var key in EFood){
				var efood = EFood[key];
				ret += this.foods[efood];
			}
			return ret !== 0;
		},
		getFoodHash:function(){
			if(this.foods[EFood.GREAT] !== 0){
				this.foods[EFood.GREAT]--;
				return {give:20,yukkuri:15,unun:20};
			}
			else if(this.foods[EFood.NORMAL] !== 0){
				this.foods[EFood.NORMAL]--;
				return {give:10,yukkuri:5,unun:10};
			}
			else if(this.foods[EFood.BAD] !== 0){
				this.foods[EFood.BAD]--;
				return {give:10,yukkuri:-2,unun:10};
			}
			return false;
		},
		setOwner: function(yukkuri){
			this.owner = yukkuri;
		},
		isOwner: function(){
			return this.owner !== null;
		}
	});
	var Unun = enchant.Class.create(ObjSprite,{
		initialize: function (x, y){
			this.classname = "Unun";
			ObjSprite.call(this,32,32);
			this.image = game.assets[EResPath.YUKKURI_UNUN];
			this.x = x;
			this.y = y;
			backgroundMap.addChild(this);
			// this.lifetime = 30 * 24 * 3;
			this.lifetime = 15 * 24;
			this.addEventListener('enterframe', this.runEnterframe(this));
			// game.rootScene.addEventListener('enterframe', this.runEnterframe(this));

		},
		runEnterframe:function(self){
			return function(e){
				if(typeof e === "undefined")return;
				if(this.age%BASE_FPS === 0 && this.age !== 0){
					self.lifetime--;
					if(self.lifetime <= 0){
						this.parentNode.removeChild(this);
						ctl.backgroundMap.removeChild(this);
						ctl.removeObj(this);
						self.image = null;
					}
				}

			};
		}
	});
	var Okazari = enchant.Class.create(enchant.Sprite,{
		initialize: function(yukkuri){
			this.classname = "Okazari";
			if(yukkuri.myCode === "REIMU"){
				enchant.Sprite.call(this, 80, 32);
				this.image = game.assets[EResPathReimu.OKAZARI];
				this.x = -CHARA_WIDTH / 3 * 2;
				this.y = -yukkuri.getHeight()/5 * 2 - 4;
			}else{
				enchant.Sprite.call(this, 64, 64);
				this.image = game.assets[EResPath.MARISA_OKAZARI];
				this.x = -CHARA_WIDTH / 2;
				this.y = -CHARA_HEIGHT / 2 - yukkuri.getHeight()/6;
			}
			this.yukkuri = yukkuri;
		},
		getWidth: function(){
			return this.width;
			// return this.width * this.yukkuri.myScaleX;
		},
		getHeight: function(){
			return this.height;
			// return this.height * this.yukkuri.myScaleY;
		}
	});
	var Kuki = enchant.Class.create(ObjSprite,{
		initialize: function(yukkuri, x, y){
			this.classname = "Kuki";
			enchant.Sprite.call(this, 56, 40);
			this.image = game.assets[EResPath.KUKI];
			this.x = 0 + x;
			this.y = -CHARA_HEIGHT / 2 -CHARA_HEIGHT / 4 + y;
			this.owner = yukkuri;
			this.miYukkuris = [];
		},
		addMiYukkuri: function(miYukkuri){
			// miYukkuri.setX(miYukkuri.getX() + 30);
			// miYukkuri.setY(miYukkuri.getY() - 30);
			this.miYukkuris.push(miYukkuri);
		},
		getMiYukkuris: function(){
			return this.miYukkuris;
		},
		getX : function(){
			return this.x;
		},
		getY : function(){
			return this.y;
		},
		getWidth: function(){
			return this.width;
			// return this.width * this.yukkuri.myScaleX;
		},
		getHeight: function(){
			return this.height;
			// return this.height * this.yukkuri.myScaleY;
		}
	});
	var Address = enchant.Class.create({
		initialize: function(yukkuri){
			this.friendlyLv = 1;
			this.yukkuri = yukkuri;
			this.isGreeting = false;
			this.greetingWaitFrame = 0;
			this.comMatrix = {
				"beginSayHello" : false,
				"sayHello" : false,
			};
			this.evtHash = {};
		},
		set:function(key, value){
			this.comMatrix[key] = value;
		},
		get:function(key){
			return this.comMatrix[key];
		}
	});

	var Yukkuri = enchant.Class.create(ObjSprite,{
		initialize: function(x, y, grow){
			ObjSprite.call(this, 64, 64);
			this.searchObjectMang = new SearchObjectMang();
			this.grow = grow;
			//base plyaer only
			this.cmdQueue = [];
			this.myCode = "YUKKURI";
			this.myName = "ゆっくり";
			this.beforeHuntingFood = null;
			if(grow == EGrow.ADULT){
				this.myScaleX = 1;
				this.myScaleY = 1;
				this.mySize = "L";
			}
			else if(grow == EGrow.SUBADULT){
				this.myScaleX = 0.8;
				this.myScaleY = 0.8;
				this.mySize = "M";
			}
			else if(grow == EGrow.CHILD){
				this.myScaleX = 0.6;
				this.myScaleY = 0.6;
				this.mySize = "S";
			}
			else if(grow == EGrow.BABY){
				this.myScaleX = 0.3;
				this.myScaleY = 0.3;
				this.mySize = "SS";
			}
			else if(grow == EGrow.FRUIT_BABY){
				this.myScaleX = 0.2;
				this.myScaleY = 0.2;
				this.mySize = "SSS";
			}

			// ctl.game.rootScene.addEventListener('touchstart', this.touchstart);
			this.classname = "Yukkuri";
			this.addressBook = {};
			// this.imgGroup = new SpriteGroup();
			// this.imgBody = new SpriteGroup();
			// this.imgGroup.id = guid();
			// this.imgBody.id = guid();
			this.x = -CHARA_WIDTH / 2;
			this.y = -CHARA_HEIGHT / 2;
			this.vx = 0;
			this.vy = 0;
			this.image = game.assets[EResPath.YUKKURI_BASE];
			this.setDirection(EDirection.RIGHT);
			this.addEventListener('enterframe', this.runEnterframe);
			this.bodyStatus ={};
			this.bodyStatus[EBody.NORMAL] = EResPath.YUKKURI_BASE;
			this.bodyStatus[EBody.DEAD] = EResPath.YUKKURI_BODY_DEAD;
			this.walkAnimationStatus = EWalkAnimation.END;
			this.place = null;
			this.items = [];
			this.actionQueue = [];
			this.exLvHash = {};
			this.exValueHash = {};
			this.memoryHash = {};
			this.communicateYukkuri = {};
			for(var _v in EExSkill){
				var key = EExSkill[_v];
				this.exLvHash[key] = 0;
				this.exValueHash[key] = 0;
			}
			this.kukis = [];
			this.formSprite = new FormSprite();
		},
		runEnterframe:function(){
			// console.log("runEnterframe");
				// this.formSprite.run();
				// this.formSprite.addX(1);

			// try{
				if(this.grow == EGrow.FRUIT_BABY){
				}else{
					if(this.kukis){
						// this.kukis[0].miYukkuris[0].setX(this.getX());
						// this.kukis[0].miYukkuris[0].setY(this.getY());
						// var _x = this.imgBody.tl.node.x;
						// var _y = this.imgBody.tl.node.y;
						// var _gety = this.kukis[0].miYukkuris[0].getY();
						// this.kukis[0].miYukkuris[0].setOldY();
						// this.kukis[0].miYukkuris[0].animY(-_y);
						// this.kukis[0].direction = this.direction;
					}
					// console.log(this.getX() + ":" + this.getY());
					this.act();
					if(this.isDead())return;
					this.runYukkuri();
					this.runHungry();
					this.runUnun();
					this.runSleep();
					this.runAddress();
					this.runAnimation();
					// this.animation();

				}
			// }catch(e){
			// 	console.log(e);
			// }
		},
		reverse:function(){
			if(this.direction == EDirection.RIGHT){
				this.formSprite.formScaleX(this.myScaleX);
				if(this instanceof Player){
					this.formSprite.setFixBudgeRight(5);
				}

				this.formSprite.setFixKukiRight();
				var len = this.kukis.length;
				for(var i=0;i<len;i++){
					var kuki = this.kukis[i];
					var miYukkuris = kuki.getMiYukkuris();
					if(!miYukkuris)continue;
					var miyukkuriLength = miYukkuris.length;
					for(var j=0;j<miyukkuriLength;j++){
						// miYukkuris[j].scaleX = 1;
						// miYukkuris[j].scale(-1, 1);
					}
				}
				// this.formSprite.formScaleY(this.myScale);

				// this.imgBody.scaleX = 1;
			}
			else if(this.direction == EDirection.LEFT){
				this.formSprite.formScaleX(-this.myScaleX);
				if(this instanceof Player){
					this.formSprite.setFixBudgeLeft(5);
					this.formSprite.setFixKukiLeft();
				}
				this.formSprite.setFixKukiLeft();
				var len = this.kukis.length;
				for(var i=0;i<len;i++){
					var kuki = this.kukis[i];
					var miYukkuris = kuki.getMiYukkuris();
					if(!miYukkuris)continue;
					var miyukkuriLength = miYukkuris.length;
					for(var j=0;j<miyukkuriLength;j++){
						// miYukkuris[j].scaleX = -1;
						// miYukkuris[j].scale(-1, 1);
					}
				}

				// this.formSprite.formScaleY(this.myScale);
				// this.imgBody.scaleX = -1;
			}
		},
		tweet:function(text){
			text = text.replace(/%name%/g, this.myName);
			// this._tweet.text(text, this.x - this._tweet.width/4, this.y - this._tweet.height);
			this._tweet.text(text, this.getX() - this._tweet.width/4, this.getY() - this._tweet.height);
		},
		moveTo:function(x, y, time){
			this.formSprite.tlMoveTo(x, y, time, enchant.Easing.SIN_EASEINOUT);
			// this.imgGroup.tl.moveTo(x, y, time, enchant.Easing.SIN_EASEINOUT);
		},
		moveBy:function(x, y, time, eventFunctions){
			this.formSprite.tlMoveBy(x, y, time, eventFunctions);
			// var self = this;
			// var params = {
			// 	x: function() {
			// 		return self.getX() + x;
			// 		// return self.imgGroup.x + x;
			// 	},
			// 	y: function() {
			// 		return self.getY() + y;
			// 		// return self.imgGroup.y + y;
			// 	},
			// 	time: time,
			// 	easing: enchant.Easing.SIN_EASEINOUT
			// };
			// //-Event register [onactionstart,onactiontick,onactionend]
			// if(eventFunctions !== undefined){
			// 	for(var key in eventFunctions){
			// 		params[key] = eventFunctions[key];
			// 	}
			// }
			// console.log("moveBy");
			// console.log("self.x:" + self.getX());
			// return this.formSprite.tlTween(params);
			// // return this.imgGroup.tl.tween(params);
		},
		wait:function(frame, eventFunctions){
			this.moveBy(0,0,frame,eventFunctions);
		},
		act: function(){
			this.action.act();
		},
		runAnimation: function(){
			this.formSprite.formRunAnimation();
		},
		animation: function(){
			this.formSprite.formStartAnimation();
			// var frame = 10;
			// frame -= plusFrameScale(frame, this.getMyScale()) / 2;
			// var move = 5;
			// move -= plusFrameScale(move, this.getMyScale());
			// if(this.walkAnimationStatus == EWalkAnimation.END){
			// 	this.imgBody.y = 0;
			// 	this.imgBody.tl.moveByEx(0, -move, frame, enchant.Easing.SWING, {
			// 		"onactionstart": function(e){
			// 			this.walkAnimationStatus = EWalkAnimation.START;
			// 		}
			// 	})
			// 	.moveByEx(0, move, frame, enchant.Easing.SWING,
			// 	{
			// 		"onactionend": function(e){
			// 			this.walkAnimationStatus = EWalkAnimation.END;
			// 		}
			// 	}).loop();
			// }else{
			// 	this.imgBody.tl.loop();
			// }
		},
		getMyScale: function(){
			return (this.myScaleX + this.myScaleY) / 2;
		},
		getWidth: function(){
			return this.width * this.myScaleX;
		},
		getHeight: function(){
			return this.height * this.myScaleY;
		},
		setX: function(x){
			this.formSprite.setX(x);
			// this.imgGroup.x = x;
		},
		setY: function(y){
			this.formSprite.setY(y);
			// this.imgGroup.y = y;
		},
		getX: function(){
			return this.formSprite.getX();
			// return this.imgGroup.x;
		},
		getY: function(){
			return this.formSprite.getY();
			// return this.imgGroup.y;
		},
		moveX: function(x){
			this.formSprite.addX(x);
			// this.imgGroup.x += x;
		},
		moveY: function(y){
			this.formSprite.addY(y);
			// this.imgGroup.y += y;
		},
		// changeFace: function(erespath){
		// 	this.face.image = game.assets[erespath];
		// },
		loadParamsXML: function(url){
			var http = new JKL.ParseXML( url );
			return http.parse();
		},
		runYukkuri: function(){
			if(this.param.hungry > 70){
				if(this.age%(50 - this.param.hungry - 70) === 0 && this.age !== 0){
					this.param.yukkuri -= 1;
				}
			}
			else if(this.param.hungry < 10){
				if(this.age%50 === 0 && this.age !== 0) this.param.yukkuri += 1;
			}

			if(this.param.yukkuri <= 0)this.param.yukkuri = 0;
			else if(this.param.yukkuri >= this.param.maxYukkuri)this.param.yukkuri = this.param.maxYukkuri;

			var x = this.getX();
			var y = this.getY();

			var kukiLength = this.kukis.length;
			var yukkuris = [];
			if(kukiLength > 0){
				for(var i=0;i<kukiLength;i++){
					var kuki = this.kukis[i];
					yukkuris = kuki.getMiYukkuris();
					var yukkuriLength = yukkuris.length;
					for(var j=0;j<yukkuriLength;j++){
						var yukkuri = yukkuris[j];
						//TODO ここに方向によってXの値の加算減算をつける
						yukkuri.setX(x - 20);
						yukkuri.setY(y);
					}
				}

			}
		},
		runHungry: function(){
			if(this.age%50 === 0 && this.age !== 0)this.param.hungry += ADD_HUNGRY;
			if(this.param.hungry >= 100)this.param.hungry = 100;
		},
		runUnun: function(){
			if(this.age%50 === 0 && this.age !== 0)this.param.unun += 1;
			if(this.param.unun >= 100)this.param.unun = 100;
		},
		runSleep: function(){
			if(this.action.getStatus() != EAction.SLEEP_START && this.action.getStatus() != EAction.SLEEP_WAIT){
				if(this.age%80 === 0 && this.age !== 0)this.param.sleep += 1;
				if(this.param.sleep >= 100){
					this.param.sleep = 100;
				}
			}
		},
		runAddress: function(){
			for(var key in this.addressBook){
				var address = this.addressBook[key];
				//挨拶時間。24時間に1度だけ。
				if(address.isGreeting){
					address.greetingWaitFrame++;
					if(address.greetingWaitFrame >= DAY){
						address.greetingWaitFrame = 0;
						address.isGreeting = false;
					}
				}
			}
		},
		changeFace: function(){
			if(this.param.yukkuri >= 80){
				this.setFaceImage(EFace.HAPPY1);
			}
			else if(this.param.yukkuri >= 50){
				this.setFaceImage(EFace.NORMAL);
			}
			else if(this.param.yukkuri >= 30){
				this.setFaceImage(EFace.TIRED);
			}
			else if(this.param.yukkuri >= 10){
				this.setFaceImage(EFace.CRY1);
			}
			else if(this.param.yukkuri >= 1){
				this.setFaceImage(EFace.CRY2);
			}
		},
		getRange: function(){
			return this.param.range;
		},
		isSleep: function(){
			return this.param.sleep >= 100;
		},
		isDead: function(){
			return this.param.yukkuri <= 0;
		},
		isManpuku: function(){
			return this.param.hungry <= 20;
		},
		isKuhuku: function(){
			return this.param.hungry >= 40;
		},
		isVeryKuhuku: function(){
			return this.param.hungry >= 80;
		},
		getYukkuri: function(){
			return this.param.yukkuri;
		},
		setYukkuri: function(yukkuri){
			this.param.yukkuri = yukkuri;
			if(this.param.yukkuri < 0)this.param.yukkuri = 0;
		},
		addYukkuri: function(yukkuri){
			this.param.yukkuri += yukkuri;
			if(this.param.yukkuri < 0)this.param.yukkuri = 0;
		},
		getHungry: function(){
			return this.param.hungry;
		},
		setHungry: function(hungry){
			this.param.hungry = hungry;
			if(this.param.hungry < 0)this.param.hungry = 0;
		},
		getUnun: function(){
			return this.param.unun;
		},
		getLooksNumber: function(){
			return this.param.looks;
		},
		getLooksText: function(){
			if(this.param.looks == ELooks.GOOD_YUKKURI){
				return "びゆん";
			}
			if(this.param.looks == ELooks.NORMAL_YUKKURI){
				return "ぼんゆん";
			}
			if(this.param.looks == ELooks.BAD_YUKKURI){
				return "ぶさゆん";
			}
			return "";
		},
		setUnun: function(unun){
			this.param.unun = unun;
			if(this.param.unun < 0)this.param.unun = 0;
		},

		eat:function(food){
			if(food instanceof Food){
				//Food object case
				if(food.amount > 0){
					food.amount--;
					this.setHungry(this.param.hungry - food.getGive());
					this.setUnun(this.getUnun() + food.getGive() / 4);
					this.setYukkuri(this.getYukkuri() + 5);
					return true;
				}else{
					this.setYukkuri(this.getYukkuri() - 5);
					return false;
				}
			}else{
				//hash case
				if(food != null){
					this.setHungry(this.param.hungry - food.give);
					this.setUnun(this.getUnun() + food.unun);
					this.setYukkuri(this.getYukkuri() + food.yukkuri);
					return true;
				}else{
					return false;
				}
			}
		},
		hunt:function(food){
			if(food.amount > 0){
				if(!this.isItemsMax()){
					food.amount--;
					this.items.push(food);
					this.setYukkuri(this.getYukkuri() + 1);
					return true;
				}
			}
			return false;
		},
		declarePlace: function(place){
			this.place = place;
		},
		getPlace:function(){
			return this.place;
		},
		isPlace: function(){
			return this.place !== null;
		},

		unun:function(){
			if(this.direction == EDirection.RIGHT){
				new Unun(this.getX() -  this.getWidth()/5, this.getY() + this.getHeight()/5 );
			}else{
				new Unun(this.getX() -  this.getWidth()/5, this.getY() + this.getHeight()/5 );
			}
			// if(this.direction == EDirection.RIGHT){
			// 	new Unun(this.getX() + this.getWidth()/2 - this.getWidth()/5, this.getY() + this.getHeight() / 2 +  this.getHeight() / 5 );
			// }else{
			// 	new Unun(this.getX() + this.getWidth()/2 - this.getWidth()/5, this.getY() + this.getHeight() / 2 + this.getHeight() / 5 );
			// }
			this.setUnun(0);
		},
		setBodyImage: function(ebody){
			var path = this.bodyStatus[ebody];
			this.image = game.assets[path];
		},
		tlPause:function(){
			// this.imgBody.tl.clear();
			// this.imgGroup.tl.clear();
			// this.imgBody.tl.unloop();
			// this.imgGroup.tl.unloop();
			// this.imgBody.y = 0;
			this.formSprite.formStopAnimation();
		},
		tlResume: function(){
			// this.imgBody.tl.resume();
			// this.imgGroup.tl.resume();
			this.animation();
		},
		syncDirection:function(senderYukkuri){
			if(this.getX() > senderYukkuri.getX()){
				// this.direction = EDirection.LEFT;
				// senderYukkuri.direction = EDirection.RIGHT;
				this.setDirection(EDirection.LEFT);
				senderYukkuri.setDirection(EDirection.RIGHT);
			}else{
				this.setDirection(EDirection.RIGHT);
				senderYukkuri.setDirection(EDirection.LEFT);
			}
		},
		isCommunication: function(yukkuri){
			if(this.addressBook[yukkuri.id] === undefined) return true;
			if(this.addressBook[yukkuri.id].isGreeting) return false;
			return true;
		},
		addAddress: function(yukkuri){
			this.addressBook[yukkuri.id] = new Address(yukkuri);
		},
		getAddress: function(yukkuri){
			if(this.addressBook[yukkuri.id] === undefined)return null;
			return this.addressBook[yukkuri.id];
		},
		getStatusForDisplay: function (){
			var ret = "";
			var placeId = (this.place==null)?"無し" : this.place.id;
			ret += "ID　" + this.id + "\n";
			ret += "プレイス　 " + placeId + "\n";
			ret += "ゆっくり　 " + this.getYukkuri() + "\n";
			ret += "空腹　 " + this.getHungry() + "\n";
			ret += "うんうん　 " + this.getUnun() + "\n";
			ret += "もちもの　 " + this.items.length + "\n";
			ret += "容姿　 " + this.getLooksText() + "\n";
			ret += "debug  " + this.action.status + "\n";
			return ret;
		},
		isItemsMax:function(){
			return this.items.length >= this.param.items_max;
		},
		getItems:function(){
			return this.items;
		},
		addSearchObject:function(esearch, node){
			this.searchObjectMang.add(esearch, node)
		},
		clearSearchObject:function(){
			this.searchObjectMang.clear()
		},
		setFaceImage: function(eface){
			var path = this.faceStatus[eface];
			this.face.image = game.assets[path];
		},
		myScale: function(_scaleX, _scaleY){
			this.formSprite.scale(_scaleX, _scaleY);
			// this.face.scale(_scaleX,_scaleY);
			// if(this.myCode === "REIMU"){
			// 	// this.okazari.x = -this.okazari.width / 2;
			// 	// this.okazari.y = -CHARA_HEIGHT  / 2 + (this.okazari.height * (1 - _scaleY)) / 2;
			// }else{
			// 	// this.okazari.x = -CHARA_WIDTH /2;
			// 	// this.okazari.y = -CHARA_HEIGHT / 2 - (CHARA_HEIGHT * _scaleY)/6;
			// }
			// if(this.sub1 != null){
			// 	this.sub1.scale(_scaleX,_scaleY);
			// }

			// this.okazari.scale(_scaleX,_scaleY);
			// this.hear.scale(_scaleX,_scaleY);
			// this.scale(_scaleX,_scaleY);
			// if(this.shadow)this.shadow.scale(_scaleX, _scaleY);
		},
		send: function(targetYukkuri, object, callback){
			this.communicateYukkuri = targetYukkuri;
			targetYukkuri.recv(object, callback);
		},
		recv: function(object, callback){
			this.communicateYukkuri = object.yukkuri;
			this.tlPause();
			this.action.setStatus(object.actionStatus);

			// this.actionQueue.push({
			// 	object : object,
			// 	callback: callback
			// });
		},
		addExValue: function(eexskill, plus){
			this.exValueHash[eexskill] += plus;
			if(this.exValueHash[eexskill] >= 100){
				this.exLvHash[eexskill] = 1;
			}
		},
		getExValue: function(eexskill){
			return this.exValueHash[eexskill];
		},
		getExSkill: function(eexskill){
			return this.exLvHash[eexskill];
		},

		setMemory: function(ememory, value){
			this.memoryHash[ememory] = value;
		},
		getMemory: function(ememory){
			return this.memoryHash[ememory];
		},
		damage: function(edamage){
			if(edamage == EDamage.PICOHAN){
				mangMsg.output(this, EMsg.DAMAGE);
				this.setFaceImage(EFace.CRY1);
				this.addYukkuri(-1);
				//現在の行動パターンから躾対象かセレクトする
			}
		},
		// addKuki: function(){
			// for(var i=0;i<this.kukis.length;i++){
			// 	if(this.kukis[i].opacity == 0){
			// 		this.kukis[i].opacity = 1.0;
			// 		// var miMarisa = new MiMarisa(this.getX(), this.getY());
			// 		var miMarisa = new MiMarisa(100, 100);
					
			// 		// console.log(this.imgBody);
			// 		// this.imgBody.addChild(miMarisa);
			// 		this.kukis[i].addMiYukkuri(miMarisa);
			// 		break;
			// 	}
			// }
		// },
		addKuki: function(kuki){
			this.kukis.push(kuki);
			var length = this.kukis.length;
			this.formSprite.addChild(kuki,1000 + length,{type:"kuki",scaleValue:this.myScaleY});
		},
		addMiYukkuri: function(index){
			var kuki = this.kukis[index];
			var miYukkuri = new MiMarisa(this, 10, -30);
			// var x = this.getX();
			// var y = this.getY();
			kuki.addMiYukkuri(miYukkuri);

		},
		setAutoDirection:function(){
			this.direction = this.vx > 0 ? EDirection.RIGHT : EDirection.LEFT;
		},
		setDirection: function(direction){
			this.direction = direction;
			if(this.kukis){
				var kukiLength = this.kukis.length
				for(var i=0;i<kukiLength;i++){
					var kuki = this.kukis[i];
					var miYukkuris = kuki.getMiYukkuris();
					var miyukkuriLength = miYukkuris.length;
					for(var j=0;j<miyukkuriLength;j++){
						miYukkuris[j].direction = direction;
					}
				}
			}
		},
		destruct: function(){

		}
	});
	var MiYukkuri = enchant.Class.create(ObjSprite, {
		initialize: function(param){
			ObjSprite.call(this,14,14);
			// this.oldX = x;
			// this.oldY = y;

			this.classname = "MiYukkuri";
			this.image = game.assets[EResPath.MIYUKKURI];
			this.x = param.x;
			this.y = param.y;
			this.addX = param.addX;
			this.addY = param.addY;
			this.scaleValue = 1;
			this.scaleX = 1;
			this.scaleY = 1;
			backgroundMap.addChild(this);
			this.anim = {};
			this.anim.cnt = 0;

		},
		setX : function(x){
			this.x = x + this.addX;
		},
		setY : function(y){
			this.y = y + this.addY;
		},
		setOldY: function(){
			this.imgGroup.y = this.oldY;

		},
		animX: function(x){
			this.oldX = this.imgGroup.x;
			this.imgGroup.x -= x;
		},
		animY: function(y){
			this.imgGroup.y = this.oldY;
			// this.oldY = this.imgGroup.y;
			this.imgGroup.y -= y;
		},
		scaleX: function(x){
			this.scaleX = x;
		}

	}); 
	var MiMarisa = enchant.Class.create(MiYukkuri,{
		initialize: function(parentYukkuri, addX, addY){
			var x = parentYukkuri.getX();
			var y = parentYukkuri.getY();
			if(addX === undefined){
				x += addX;
			}
			if(addY === undefined){
				y += addY;
			}
			MiYukkuri.call(this, {x:x, y:y,addX:addX, addY:addY});
			this.classname = "MiMarisa";
			this.myCode = "MI_MARISA";
			this.myName = "実まりちゃ";

			// this.classname = "Marisa";
			// this.myCode = "MARISA";
			// this.myName = "実まりさ";

			// this.param = new MarisaParam();
			// this.param.looks = ELooks.GOOD_YUKKURI;
			// this.myName = "実まりちゃ";
			// this.param.range /= 4;

			// this.face = new enchant.Sprite(64, 64);
			// this.face.image = game.assets[EResPath.MARISA_FACE_NORMAL];
			// this.face.x = -CHARA_WIDTH / 2;
			// this.face.y = -CHARA_HEIGHT / 2;

			// this.faceStatus ={};
			// this.faceStatus[EFace.NORMAL] = EResPath.MARISA_FACE_NORMAL;
			// this.faceStatus[EFace.CRY1] = EResPath.MARISA_FACE_CRY1;
			// this.faceStatus[EFace.CRY2] = EResPath.MARISA_FACE_CRY2;
			// this.faceStatus[EFace.ANGRY] = EResPath.MARISA_FACE_ANGRY;
			// this.faceStatus[EFace.HAPPY1] = EResPath.MARISA_FACE_HAPPY1;
			// this.faceStatus[EFace.HAPPY2] = EResPath.MARISA_FACE_HAPPY2;
			// this.faceStatus[EFace.EAT1] = EResPath.MARISA_FACE_EAT1;
			// this.faceStatus[EFace.EAT2] = EResPath.MARISA_FACE_EAT2;
			// this.faceStatus[EFace.TIRED] = EResPath.MARISA_FACE_TIRED;
			// this.faceStatus[EFace.SLEEP] = EResPath.MARISA_FACE_SLEEP;


			// this.hear = new enchant.Sprite(64, 64);
			// this.hear.image = game.assets[EResPath.MARISA_HEAR];
			// this.hear.x = -CHARA_WIDTH / 2;
			// this.hear.y = -CHARA_HEIGHT / 2;

			// this.okazari = new Okazari(this);

			// this._tweet = new TTweet(this, 148, 64);

			// this.formSprite.addChild(this, 1, {
			// 	mainIndexFlg:true,
			// 	type : "body",
			// 	scaleValue:this.myScaleY
			// });

			// this.formSprite.addChild(this.face,2,{type:"body",scaleValue:this.myScaleY});
			// this.formSprite.addChild(this.hear,3,{type:"body",scaleValue:this.myScaleY});
			// this.formSprite.addChild(this.okazari,4,{type:"body",scaleValue:this.myScaleY});
			// this.formSprite.addChild(this._tweet,6,{type:"tweet",scaleValue:this.myScaleY});
			// this.myScale(this.myScaleX, this.myScaleY)
			// if(this instanceof Player){
			// 	this.budge = new enchant.Sprite(16, 16);
			// 	this.budge.image = game.assets[EResPath.PLAYER_BADGE];
			// 	this.budge.x = -this.getWidth()/2;
			// 	this.budge.y = -this.getHeight()/2;
			// 	this.budge.scale(this.myScaleX, this.myScaleY);
			// 	this.formSprite.addChild(this.budge,5, {type:"budge",scaleValue:this.myScaleY});
			// 	this.formSprite.setX(x);
			// 	this.formSprite.setY(y);
			// }
			// this.formSprite.setX(x);
			// this.formSprite.setY(y);
			// this.animation();
			// this.action = new Action(this);
			// ctl.addObj(this);
		}

	});
	var Marisa = enchant.Class.create(Yukkuri,{
		initialize: function(x, y, grow){
			Yukkuri.call(this,x,y, grow);
			this.classname = "Marisa";
			this.myCode = "MARISA";
			this.myName = "まりさ";

			// var xml = this.loadParamsXML("./data/marisa/params.xml");
			// var json = net.load("./data/marisa/params.json");
			// this.param = json.root.param;
			this.param = new MarisaParam();
			this.param.looks = ELooks.GOOD_YUKKURI;
			if(this.grow == EGrow.BABY){
				this.myName = "まりちゃ";
				this.param.range /= 4;
			}
			else if(this.grow == EGrow.CHILD){
				this.param.range /= 3;
			}
			else if(this.grow == EGrow.SUBADULT){
				this.param.range *= 0.8;
			}else{
			}
			this.shadow = new enchant.Sprite(64, 64);
			this.shadow.image = game.assets[EResPath.YUKKURI_SHADOW];
			this.shadow.x = 0 + this.x;
			this.shadow.y = this.getHeight() / 16 + this.y;

			this._style.zIndex = 5;

			this.face = new enchant.Sprite(64, 64);
			this.face.image = game.assets[EResPath.MARISA_FACE_NORMAL];
			this.face.x = -CHARA_WIDTH / 2;
			this.face.y = -CHARA_HEIGHT / 2;

			this.faceStatus ={};
			this.faceStatus[EFace.NORMAL] = EResPath.MARISA_FACE_NORMAL;
			this.faceStatus[EFace.CRY1] = EResPath.MARISA_FACE_CRY1;
			this.faceStatus[EFace.CRY2] = EResPath.MARISA_FACE_CRY2;
			this.faceStatus[EFace.ANGRY] = EResPath.MARISA_FACE_ANGRY;
			this.faceStatus[EFace.HAPPY1] = EResPath.MARISA_FACE_HAPPY1;
			this.faceStatus[EFace.HAPPY2] = EResPath.MARISA_FACE_HAPPY2;
			this.faceStatus[EFace.EAT1] = EResPath.MARISA_FACE_EAT1;
			this.faceStatus[EFace.EAT2] = EResPath.MARISA_FACE_EAT2;
			this.faceStatus[EFace.TIRED] = EResPath.MARISA_FACE_TIRED;
			this.faceStatus[EFace.SLEEP] = EResPath.MARISA_FACE_SLEEP;


			this.hear = new enchant.Sprite(64, 64);
			this.hear.image = game.assets[EResPath.MARISA_HEAR];
			this.hear.x = -CHARA_WIDTH / 2;
			this.hear.y = -CHARA_HEIGHT / 2;

			this.okazari = new Okazari(this);

			this.kukis = [];
			this.kukis[0] = new Kuki(this, 0, 0);
			// this.kukis[1] = new Kuki(this, 10, 0);
			// this.kukis[2] = new Kuki(this, 5, 5);
			// this.kukis[3] = new Kuki(this, -5, 5);
			this._tweet = new TTweet(this, 148, 64);

			this.formSprite.addChild(this.shadow,0,{type:"shadow",shadowIndexFlg:true,scaleValue:this.myScaleY});
			this.formSprite.addChild(this, 1, {
				mainIndexFlg:true,
				type : "body",
				scaleValue:this.myScaleY
			});

			this.formSprite.addChild(this.face,2,{type:"body",scaleValue:this.myScaleY});
			this.formSprite.addChild(this.hear,3,{type:"body",scaleValue:this.myScaleY});
			this.formSprite.addChild(this.okazari,4,{type:"body",scaleValue:this.myScaleY});
			this.formSprite.addChild(this._tweet,6,{type:"tweet",scaleValue:this.myScaleY});
			this.formSprite.addChild(this.kukis[0],7,{type:"kuki",scaleValue:this.myScaleY});


			// this.formSprite.addChildAll();
			// App.backgroundMap.addChild(this._tweet);
			// this.imgGroup.addChild(this.shadow);
			// this.imgBody.addChild(this);
			// this.imgBody.addChild(this.face);
			// this.imgBody.addChild(this.hear);
			// this.imgBody.addChild(this.okazari);
			// for(var i=0;i<this.kukis.length;i++){
			// 	this.imgBody.addChild(this.kukis[i]);
			// 	this.kukis[i].opacity = 0;
			// }
			// this.kuki = ;
			// this.imgBody.addChild(new Kuki(this));
			this.myScale(this.myScaleX, this.myScaleY)
			if(this instanceof Player){
				this.budge = new enchant.Sprite(16, 16);
				this.budge.image = game.assets[EResPath.PLAYER_BADGE];
				this.budge.x = -this.getWidth()/2;
				this.budge.y = -this.getHeight()/2;
				this.budge.scale(this.myScaleX, this.myScaleY);
				this.formSprite.addChild(this.budge,5, {type:"budge",scaleValue:this.myScaleY});
				this.formSprite.setX(x);
				this.formSprite.setY(y);
			}
			// this.imgGroup.width = this.getWidth();
			// this.imgGroup.height = this.getHeight();
			// this.imgGroup.addChild(this.imgBody);

			// backgroundMap.addChild(this.imgGroup);
			// this._tweet = new TTweet(148, 64);

			// this.imgGroup.addChild(this._tweet);
			// this.imgGroup.x = x;
			// this.imgGroup.y = y;
			this.formSprite.setX(x);
			this.formSprite.setY(y);
			this.animation();
			this.action = new Action(this);
			ctl.addObj(this);
		}
	});
	var Player = enchant.Class.create(Marisa,{
		initialize: function(x, y, grow){
			// this.runEnterframe = function(){
			// },
			if(grow === undefined)grow = EGrow.ADULT;
			Marisa.call(this, x, y, grow);
			this.classname = "Player";
			ctl.setPlayer(this);
			// this.removeEventListener('enterframe',this.runEnterframe);
			this.addEventListener('enterframe', function(){

				if(this.age%10 === 0 && this.age !== 0){
					// console.log("palyer:" + this.age);
				}
				// this.act();
				///////////////////////////////////////////////
				//Action pattern  debug
				if(game.input.left){
					// this.changeFace(EResPath.MARISA_FACE_TIRED);
					// this.moveX(-10);
					this.direction = EDirection.LEFT;
				}
				if(game.input.right){
					// for(var i=0;i<this.formSprite.spriteArray.length;i++){
					// 	var spr = this.formSprite.spriteArray[i];
					// 	console.log(i+":spry:" + spr.y);
					// }
					// this.moveX(10);
					this.direction = EDirection.RIGHT;
				}
				if(game.input.up){
					this.moveY(-10);
				}
				if(game.input.down){
					this.moveY(10);
				}

				// if(this.age%20 == 0)console.log("player:" + (this.getY() + this.getHeight()/2));
				///////////////////////////////////////////////
				// this.reverse();
				// if(ctl.backgroundMap.hitTest(this.imgGroup.x, this.imgGroup.y + this.height / 2)){
				//	console.log("hit:" + this.imgGroup.x + ":" +  (this.imgGroup.y + this.height/2) );
				// }else{
				//	console.log("not:" + this.imgGroup.x + ":" +  (this.imgGroup.y + this.image.height/2));
				// }
				//- Display the circle of search range.
				// fieldBg.image.clear();
				// fieldBg.image.context.beginPath();
				// fieldBg.image.context.fillStyle = '#ff0000';
				// fieldBg.image.context.arc(this.imgGroup.x + this.width/2, this.imgGroup.y + this.height/2, this.range, Math.PI * 2, false);
				// fieldBg.image.context.fill();
			});
		}
	});
	var Reimu = enchant.Class.create(Yukkuri,{
		initialize: function(x, y, grow){
			Yukkuri.call(this,x,y, grow);
			this.classname = "Reimu";
			this.myCode = "REIMU";
			this.myName = "れいむ";
			// var xml = this.loadParamsXML("./data/marisa/params.xml");
			// var json = net.load("./data/reimu/params.json");
			// this.param = json.root.param;
			this.param = new ReimuParam();
			if(this.grow == EGrow.BABY){
				this.myName = "れいみゅ";
				this.param.range /= 4;
			}
			else if(this.grow == EGrow.CHILD){
				this.param.range /= 3;
			}
			else if(this.grow == EGrow.SUBADULT){
				this.param.range *= 0.8;
			}
			this.shadow = new enchant.Sprite(64, 64);
			this.shadow.image = game.assets[EResPath.YUKKURI_SHADOW];
			this.shadow.x = 0 + this.x;
			this.shadow.y = this.getWidth() / 16 + this.x;


			this.face = new enchant.Sprite(64, 64);
			this.face.image = game.assets[EResPathReimu.FACE_NORMAL];
			this.face.x = -CHARA_WIDTH / 2;
			this.face.y = -CHARA_HEIGHT / 2;
			this.face._style.zIndex = 0;

			this.faceStatus ={};
			this.faceStatus[EFace.NORMAL] = EResPathReimu.FACE_NORMAL;
			this.faceStatus[EFace.CRY1] = EResPathReimu.FACE_CRY1;
			this.faceStatus[EFace.CRY2] = EResPathReimu.FACE_CRY2;
			this.faceStatus[EFace.ANGRY] = EResPathReimu.FACE_ANGRY;
			this.faceStatus[EFace.HAPPY1] = EResPathReimu.FACE_HAPPY1;
			this.faceStatus[EFace.HAPPY2] = EResPathReimu.FACE_HAPPY2;
			this.faceStatus[EFace.EAT1] = EResPathReimu.FACE_EAT1;
			this.faceStatus[EFace.EAT2] = EResPathReimu.FACE_EAT2;
			this.faceStatus[EFace.TIRED] = EResPathReimu.FACE_TIRED;
			this.faceStatus[EFace.SLEEP] = EResPathReimu.FACE_SLEEP;


			this.hear = new enchant.Sprite(64, 64);
			this.hear.image = game.assets[EResPathReimu.HEAR];
			this.hear.x = -CHARA_WIDTH / 2;
			this.hear.y = -CHARA_HEIGHT / 2;

			this.sub1 = new enchant.Sprite(64, 64);
			this.sub1.image = game.assets[EResPathReimu.SUB1];
			this.sub1.x = -CHARA_WIDTH / 2;
			this.sub1.y = -CHARA_HEIGHT / 2;


			this.okazari = new Okazari(this);
			this.formSprite.addChild(this.shadow,0,{type:"shadow",scaleValue:this.myScaleY});
			this.formSprite.addChild(this, 1, {
				mainIndexFlg:true,
				type : "body",
				scaleValue:this.myScaleY
			});
			this.formSprite.addChild(this.face,2,{type:"body",scaleValue:this.myScaleY});
			this.formSprite.addChild(this.hear,3,{type:"body",scaleValue:this.myScaleY});
			this.formSprite.addChild(this.okazari,4,{type:"body",scaleValue:this.myScaleY,spname:"reimu"});
			this.formSprite.addChild(this.sub1,5,{type:"body",scaleValue:this.myScaleY});
			this._tweet = new TTweet(this, 148, 64);
			this.formSprite.addChild(this._tweet,6,{type:"tweet",scaleValue:this.myScaleY});

			this.myScale(this.myScaleX, this.myScaleY)
			if(this instanceof Player){
				this.budge = new enchant.Sprite(16, 16);
				this.budge.image = game.assets[EResPath.PLAYER_BADGE];
				this.imgBody.addChild(this.budge);
				this.budge.x -= this.getWidth()/2;
				this.budge.y -= this.getHeight()/2;
				this.budge.scale(this.myScaleX, this.myScaleX);
			}

			this.formSprite.setX(x);
			this.formSprite.setY(y);
			this.animation();
			this.action = new Action(this);
			ctl.addObj(this);
			this.exLvHash[EExSkill.KEKKAI] = 1;
			this.exValueHash[EExSkill.KEKKAI] = 100;
		}
	});

	game.onload = function(){
		def.Food = Food;
		def.Unun = Unun;
		def.Place = Place;
		def.ObjSprite = ObjSprite;
		def.Yukkuri = Yukkuri;
		def.nodeSort = nodeSort;
		mangTouch = new MangTouch(ctl);
		mangMsg = new MangMsg(ctl);
		ctl.setDefined(def);
		backgroundMap.image = game.assets[EResPath.MAP0];
		backgroundMap.loadData(_mapData);
		backgroundMap.collisionData = _collisionData;

		var menuSurface = new enchant.Surface(EMenuPos.WIDTH, EMenuPos.HEIGHT);
		var fieldSurface = new enchant.Surface(EFieldPos.WIDTH, EFieldPos.HEIGHT);
		var windowSurface = new enchant.Surface(EFieldPos.WIDTH, EFieldPos.HEIGHT);
		fieldBg.image = fieldSurface;
		fieldBg.x = 0;
		fieldBg.y = 0;

		windowFront.image = windowSurface;
		windowFront.x = 0;
		windowFront.y = 0;
		windowFront.opacity = 0.5;

		windowSurface.context.fillStyle = '#000';
		windowSurface.context.fillRect(0 + 20, EFieldPos.HEIGHT - 60, EFieldPos.WIDTH - 40, EFieldPos.HEIGHT);

		menuSurface.context.fillStyle = '#000';
		menuSurface.context.fillRect(0, 0, EMenuPos.WIDTH, EMenuPos.HEIGHT);
		menuBg.image = menuSurface;
		menuBg.x = EMenuPos.X;
		menuBg.y = EMenuPos.Y;
		backgroundMap.addChild(fieldBg);
		mangIcon = new MangIcon(ctl, menuBg);

		game.rootScene.addChild(backgroundMap);
		// game.rootScene.addChild(windowFront);
		// game.rootScene.addChild(gwindow);
		// var gwindow = new GWindow(ctl, {}, 0, 0, 80, 80);
		game.rootScene.addChild(menuBg);

		// var labelGroup = new LabelGroup();
		mangLabel = new MangLabel(ctl, menuBg);
		// var info = new Label("ゆっくり");
		// info.color = "#ffffff";
		// info.font = "14px 'Times New Roman'";
		// info.x = 4;
		// info.y = GAME_HEIGHT / 2;
		// labelGroup.addChild(info);
		// menuBg.addChild(labelGroup);


		// var food = new def.Food("apple", 200, 250);
		backgroundMap.addChild(foodGroup);
		// backgroundMap.addChild(placeGroup);
		// var mimarisa = new MiMarisa(PALYER_INIT_X + 100, PALYER_INIT_Y + 100, EGrow.FRUIT_BABY);
		var player = new Player(PALYER_INIT_X + 200, PALYER_INIT_Y + 200, EGrow.ADULT);
		;
		player.addMiYukkuri(0);
		// var player = new Player(0, 0);
		// console.log(player.getX());
		// player.addKuki();
		// player.addMiYukkuri(mimarisa)
		// player.createKuki();
		new Marisa(PALYER_INIT_X + 50, PALYER_INIT_Y + 200, EGrow.ADULT);
		
		// new Marisa(PALYER_INIT_X + 150, PALYER_INIT_Y + 200, EGrow.ADULT);
		// new Marisa(PALYER_INIT_X + 250, PALYER_INIT_Y + 200, EGrow.ADULT);
		// new Marisa(PALYER_INIT_X + 100, PALYER_INIT_Y + 200, EGrow.SUBADULT);
		// new Marisa(PALYER_INIT_X + 150, PALYER_INIT_Y + 200, EGrow.CHILD);
		// new Marisa(PALYER_INIT_X + 200, PALYER_INIT_Y + 200, EGrow.BABY);
		// new Reimu(PALYER_INIT_X + 100, PALYER_INIT_Y + 100, EGrow.ADULT);
		// new Reimu(PALYER_INIT_X + 350, PALYER_INIT_Y + 400, EGrow.SUBADULT);
		// new Reimu(PALYER_INIT_X + 300, PALYER_INIT_Y + 400, EGrow.CHILD);
		// new Reimu(PALYER_INIT_X + 250, PALYER_INIT_Y + 400, EGrow.BABY);
		// new Unun(100, 100);
		// new Place("tree", PALYER_INIT_X, PALYER_INIT_Y - 50);
		var touchX = 0;
		// var input = new Label("<form name='hoge' style='background-color:#ff0000;'>" +
		// 		"<input type='text' name='text'>" +
		// 		// "<select name='input_item' id='input_item'><option name='none'>りんご</option></select>" +
		// 		"</from>");
		// input.y = 0;
		// input.element.innerHTML = "<form name='hoge' style='background-color:#ff0000;'>" +
		// 		"<input type='text' name='text'>" +
		// 		// "<select name='input_item' id='input_item'><option name='none'>りんご</option></select>" +
		// 		"</from>";
		// menuBg.addChild(input);
		// game.rootScene.addChild(input);
		// var inputEvent = new Label('');
		// output.y = 64;
		// game.rootScene.addChild(output);
		// output.onenterframe = function(e) {
		// 		output.text = document.hoge.text.value;
		// 	};
		// };
		// enchant.Node.GAddEvent = function(){
		// }
		var popupStatus = null;
		var testFlg = false;
		var iconText = [];
		game._element.addEventListener('mousemove', function (e) {
			var mang = mangTouch.get(ctl.getCurrentCommand());
			if(EMenuPos.X < e.layerX){
				var ex = e.layerX - EMenuPos.X;
				var ey = e.layerY;
				var hitFlg = false;
				for(var i=0;i<mangIcon.cmdIcons.length;i++){
					var icon = mangIcon.cmdIcons[i];
					if(icon.x <= ex && ex <= (icon.x + ICON_WIDTH)
						&& icon.y <= ey && ey <= (icon.y + ICON_HEIGHT)
						){
						hitFlg = true;
						if(popupStatus !== i){
							ctl.popup.renew(game.rootScene, EMenuPos.X + 5, e.layerY + ICON_HEIGHT / 2, 80, 80);
							ctl.popup.setText(icon.text);
							popupStatus = i;
							break;
						}
					}
				}

				if(hitFlg){
					ctl.popup.opacity = 0.9;
					ctl.popup.drawText();
				}
				else {
					ctl.popup.opacity = 0;
				}
				// console.log(e.layerX + ":" + e.layerY);
			}
		});
		// enchant.Core.instance._element.addEventListener('mousemove', function(e) {

		// game.rootScene.addEventListener('mousemove', function (e) {
		// 	console.log("mmmmmmmmm");
		// });


		game.rootScene.addEventListener('touchstart', function (e) {
			game.touched = true;
			var mang = mangTouch.get(ctl.getCurrentCommand());
			mang.touchstart(e);
		});
		game.rootScene.addEventListener('touchmove', function (e) {
			var mang = mangTouch.get(ctl.getCurrentCommand());
			mang.touchmove(e);
		});
		game.rootScene.addEventListener('touchend', function (e) {
			var mang = mangTouch.get(ctl.getCurrentCommand());
			mang.touchend(e);
			game.touched = false;
		});


		game.rootScene.addEventListener('enterframe', function(e){
			//main frame
			mangLabel.draw(player);
			if(this.age%BASE_FPS == 0 ){
				ctl.calcTime();
			}
			ctl.time += TIME_SPEED;
		});
		this.addEventListener('enterframe', function(){
			//The priority processing of display instead of z-index

			backgroundMap.childNodes.sort(nodeSort);
		});

	};
	game.start();
};


