var FormSprite = enchant.Class.create({
	initialize: function (){
		this.spriteArray = [];
		this.formSpriteArray = [];
		this.id = guid();
		this.mainIndex = 0;
		this.shadowIndex = 0;
	},
	addChild:function(sprite, index, attr){
		this.add(sprite, index, attr);
		sprite.baseX = sprite.x;
		sprite.baseY = sprite.y;
		sprite.anim = new Animation(sprite);
		sprite.id = guid();
		App.backgroundMap.addChild(sprite);
	},
	addYukkuri: function(formSprite){
		var addIndex = function (){
			var i = 0;
			return function(){
				return i++;
			};
		}();
		var index = addIndex();
		this.formSpriteArray[index] = formSprite;
	},
	// addChildAll:function(){
	// 	for(var i=0;i<this.spriteArray.length;i++){
	// 		if(this.spriteArray[i] === undefined)continue;
	// 		this.spriteArray[i].baseX = this.spriteArray[i].x;
	// 		this.spriteArray[i].baseY = this.spriteArray[i].y;
	// 		this.spriteArray[i].anim = new Animation(this.spriteArray[i]);
	// 		this.spriteArray[i].id = guid();
	// 		App.backgroundMap.addChild(this.spriteArray[i]);
	// 	}
	// },
	/**
	attr: 
		mainIndexFlg:true/false
		shadowIndexFlg:true/false
		type:body/tweet

	*/
	add : function(sprite, index, attr){
		if(attr === undefined)attr = {};
		this.spriteArray[index] = sprite;
		this.spriteArray[index].type = attr.type;
		this.spriteArray[index].scaleValue = attr.scaleValue;
		this.spriteArray[index].spname = attr.spname;
		if(attr.mainIndexFlg){
			this.mainIndex = index;
		}
		if(attr.shadowIndexFlg){
			this.shadowIndex = index;
		}
		// this.spriteArray.push(sprite);
	},
	remove: function (sprite){
		this.spriteArray.remove(sprite);
	},
	addX: function(x){
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			spr.x += x;
		}
	},
	addY: function(y){
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			spr.y += y;
		}
	},
	/**
	x
	attr: targetTypes 許可するtypeを配列で指定する
	*/
	addXAttr: function(x, attr){
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			if(!attr || attr.targetTypes.indexOf(spr.type) >= 0){
				spr.x += x;
			}
		}
	},
	addYAttr: function(y, attr){
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			if(!attr || attr.targetTypes.indexOf(spr.type) >= 0){
				spr.y += y;
			}
		}
	},
	setXAttr: function(x, attr){
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			if(!attr || attr.targetTypes.indexOf(spr.type) >= 0){
				spr.x = x;
			}
		}
	},
	setYAttr: function(y, attr){
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			if(!attr || attr.targetTypes.indexOf(spr.type) >= 0){
				spr.y = y;
			}
		}
	},
	calcField: function(field, value, attr){
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			if(!attr || attr.types.indexOf(spr.type) >= 0){
				if(attr.calc == "equal"){
					spr[field] = value;
				}
				else if(attr.calc == "add"){
					spr[field] -= value;
				}
				else{
					spr[field] = value;
				}
			}
		}
	},
	getMainSprite: function(){
		return this.spriteArray[this.mainIndex];
	},
	getShadowSprite: function(){
		return this.spriteArray[this.shadowIndex];
	},
	getMainShadowMarginY: function(){
		if(!this.getShadowSprite())return 0;
		return Math.round(this.getMainSprite().y - this.getShadowSprite().y);
	},
	getX: function(){
		return Math.round(this.spriteArray[this.mainIndex].x,2) - this.spriteArray[this.mainIndex].baseX;
	},
	getY: function(){
		return Math.round(this.spriteArray[this.mainIndex].y,2) - this.spriteArray[this.mainIndex].baseY;
	},
	setX: function(x){
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			spr.x = x + spr.baseX;
		}
	},
	setY: function(y){
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			spr.y = y + spr.baseY;
		}
	},
	addBodyY: function(y){
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			if(spr.type == "body" || spr.type == "budge"){
				this.spriteArray[i].y += y;
			}
		}
	},
	setFixBudgeLeft: function (index){
		this.spriteArray[index].x = this.spriteArray[this.mainIndex].x + this.spriteArray[this.mainIndex].width / 3 * 2;
		this.spriteArray[index].scaleX = 1;
	},
	setFixBudgeRight: function (index){
		this.spriteArray[index].x = this.spriteArray[this.mainIndex].x;
	},
	setFixKukiLeft: function (){
		this.calcField("x", this.getMainSprite().x - 30, {types:["kuki"],calc:"equal"});
	},
	setFixKukiRight: function (){
		this.calcField("x", this.getMainSprite().x + 30, {types:["kuki"],calc:"equal"});
	},
	formScaleX: function(x){
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			if(spr.type == "tweet")continue;
			spr.scaleX = x;
		}
	},
	formScaleY: function(y){
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			if(spr.type == "tweet")continue;
			spr.scaleY = y;
		}
	},
	// tlTween:function(params){
	// 	console.log("tlTween");
	// 	for(var i=0;i<this.spriteArray.length;i++){
	// 		var spr = this.spriteArray[i];
	// 		spr.tl.tween(params);
	// 	}
	// },
	tlMoveBy:function(x, y, time, eventFunctions){
		var self = this;
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			if(spr.type == "tweet")continue;

			var addX = x;
			var addY = y;
			var params = {
				x: this.paramX(spr.x, addX),
				y: this.paramY(spr.y, addY),
				time: time,
				easing: enchant.Easing.SIN_EASEINOUT
			};
			if(eventFunctions !== undefined && i == this.mainIndex){
				for(var key in eventFunctions){
					params[key] = eventFunctions[key];
				}
			}
			spr.tl.tween(params);
		}
	},
	paramX : function(x, addX){
		return x  + addX;
	},
	paramY : function(y, addY){
		return y + addY;
	},
	tlMoveTo:function(x, y, time, easing ){
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			spr.tl.moveTo(x, y, time, easing);
		}
	},
	tlQueueLength:function(){
		return this.spriteArray[this.mainIndex].tl.queue.length;
	},
	formRunAnimation: function(){
		//影とボディの差異が強くなったら修正する
		if(this.getMainShadowMarginY() < -8)this.addBodyY(+1);
		else if(this.getMainShadowMarginY() > 0)this.addBodyY(-1);
		
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			if(spr.type == "body" 
				|| spr.type == "budge"
				|| spr.type == "kuki"
				){
				spr.anim.runAnim();
			}
		}
	},
	formStartAnimation: function(){
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			if(spr.type == "body" || spr.type == "budge" || spr.type == "kuki"){
				spr.anim.startAnim();
			}
		}
	},
	formStopAnimation: function(){
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			if(spr.type == "body" || spr.type == "budge" || spr.type == "kuki"){
				spr.anim.stopAnim();
			}
		}
	},
	scale: function(_scaleX,_scaleY){
		for(var i=0;i<this.spriteArray.length;i++){
			if(this.spriteArray[i] === undefined)continue;
			var spr = this.spriteArray[i];
			if(spr.type == "tweet")continue;
			spr.scale(_scaleX, _scaleY);
		}
	},
});