﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using Yubeshi;

namespace YubeshiTest
{
    class GpsTimeTest
    {
        private static readonly DateTime utc =
                    new DateTime(2010, 1, 23, 4, 56, 7, 890, DateTimeKind.Utc);
        private static readonly DateTime utcWrapAround =
                    new DateTime(1999, 8, 21, 23, 59, 47, DateTimeKind.Utc);

        [Test]
        public void LeapSecond()
        {
            TimeSpan span1 = new DateTime(1991, 1, 1) -
                                                    new DateTime(1990, 12, 31);
            TimeSpan span2 = new DateTime(1992, 1, 1) -
                                                    new DateTime(1991, 12, 31);
            // DateTime does not support leap seconds
            Assert.AreEqual(span1.Ticks, span2.Ticks);
        }

        [Test]
        public void FromUtc()
        {
            GpsTime gps = new GpsTime(utc);
            Assert.AreEqual(false, gps.Rounded);
            Assert.AreEqual(1567, gps.Week);
            Assert.AreEqual((4 * 60 + 56) * 60 + 7.89m,
                                    gps.TimeOfWeek % (60m * 60m * 24m) - 15m);

            GpsTime gpsWrapAround = new GpsTime(utcWrapAround);
            Assert.AreEqual(false, gpsWrapAround.Rounded);
            Assert.AreEqual(1024, gpsWrapAround.Week);
            Assert.AreEqual(0, gpsWrapAround.TimeOfWeek);
        }

        [Test]
        public void ToUtc()
        {
            GpsTime gps = new GpsTime(utc);
            Assert.AreEqual(utc, gps.ToUtc());

            GpsTime gpsWrapAround = new GpsTime(1024, 0m);
            Assert.AreEqual(utcWrapAround, gpsWrapAround.ToUtc());
        }

        [Test]
        public void Now()
        {
            GpsTime now = GpsTime.Now;
            TimeSpan dt = DateTime.Now - now.ToLocalTime();
            Assert.True(dt < new TimeSpan(0, 0, 0, 0, 100));
        }

    }
}
