﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using Yubeshi;
using C = YubeshiTest.SampleCoordinates;

namespace YubeshiTest
{
    class EcefCoordinateTest
    {

        [Test]
        public void ToGeodeticCoordinate()
        {
            GeodeticCoordinate geo = C.SkyTreeTop;
            EcefCoordinate ecef = new EcefCoordinate(-3961181.340,
                                                        3346187.629,
                                                        3702487.226);

            GeodeticCoordinate converted = ecef.ToGeodeticCoordinate();

            Assert.AreEqual(geo.Latitude, converted.Latitude, 1e-6);
            Assert.AreEqual(geo.Longitude, converted.Longitude, 1e-6);
            Assert.AreEqual(geo.Altitude, converted.Altitude, 2e-4);

        }
    }
}
