﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using Yubeshi;

namespace YubeshiTest
{
    class DegreeTest
    {

        [Test]
        public void FromDegree()
        {
            Degree d = new Degree(123.45);
            Assert.AreEqual(123.45, (double)d);
        }

        [Test]
        public void FromDMS()
        {
            Degree d = new Degree(123, 45, 6);
            Assert.AreEqual(123.751666666666667, (double)d);
            Assert.AreEqual(123, d.Deg);
            Assert.AreEqual(45, d.Minute);
            Assert.AreEqual(6, d.Second);
        }

        [Test]
        public void FromRadian()
        {
            Degree d = Degree.FromRadian(-1.23);
            Assert.AreEqual(-70.473808801091, (double)d, 1e-10);
        }

        [Test]
        public void Negative()
        {
            Degree d = new Degree(-123, 45, 6);
            Assert.AreEqual(-123.751666666666667, (double)d);

            d = new Degree(-123, -45, -6);
            Assert.AreEqual(-123.751666666666667, (double)d);
        }

        [Test]
        public new void ToString()
        {
            Assert.AreEqual("123°45′6″", new Degree(123, 45, 6).ToString());
            Assert.AreEqual("-123°27′24.12″", 
                                            new Degree(-123.4567).ToString());
        }
    }
}
