﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Ubx
{
    public class NavPosLlh : Packet
    {
        #region constructors

        public NavPosLlh(byte[] sentence, int length)
            : base(sentence, length)
        {
        }

        #endregion

        #region properties

        public decimal TimeOfWeek
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 0) * 1e-3m;
            }
        }

        public GeodeticCoordinate Position
        {
            get
            {
                Degree lon = BitConverter.ToInt32(Raw, 6 + 4) * 1e-7;
                Degree lat = BitConverter.ToInt32(Raw, 6 + 8) * 1e-7;
                double h = BitConverter.ToUInt32(Raw, 6 + 12);
                return new GeodeticCoordinate(lon, lat, h);
            }
        }

        public double MslHeight
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 16);
            }
        }

        public double HorizonalAccuracy
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 20) * 1e-3;
            }
        }

        public double VerticalAccuracy
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 24) * 1e-3;
            }
        }
        #endregion

        #region public methods

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            return TryParse(sentence, out packet, 
                                            MessageID.NavPosLlh, 28, Build);
        }

        #endregion

        #region private methods

        private static Packet Build(byte[] sentence, int length)
        {
            return new NavPosLlh(sentence, length);
        }

        #endregion
    }
}
