/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Nmea
{
    /// <summary>
    ///     Latitude and Longitude, with Time of Position Fix and Status
    /// </summary>
    public class GpGll : Packet
    {
        #region fields

        private static readonly byte[] header;
        private const int elementNum = 7;

        #endregion

        #region constructors
        
        static GpGll()
        {
            header = Encoding.ASCII.GetBytes("$GPGLL,");
        }
        
        public GpGll()
        {
        }

        public GpGll(byte[] sentence)
            : this(sentence, GetElements(sentence, elementNum))
        {
        }

        private GpGll(byte[] sentence, Elements elements)
        { 

        }

        #endregion

        #region public method

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            return TryParse(sentence, out packet, header, elementNum, Build);
        }

        #endregion

        #region private method

        private static Packet Build(byte[] sentence, Elements elements)
        {
            return new GpGll(sentence, elements);
        }

        #endregion
    }
}