﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi
{
    public class Almanac
    {
        #region type definitions
        public enum HealthIndication : byte
        { 
            AllDataOk = 0,
            ParityFailure = 1,
            TlmHowFormatProblem = 2,
            ZCountInHowBad = 3,
            Subframes123 = 4,
            Subframes45 = 5,
            AllUploadedDataBad = 6,
            AllDataBad = 7
        }
        #endregion
        #region properties
        public int ID
        {
            get;
            set;
        }

        public HealthIndication Health
        {
            get;
            set;
        }

        public double Eccentricity
        {
            get;
            set;
        }

        public decimal TimeOfApplicability
        {
            get;
            set;
        }

        public Degree OrbitalInclination
        {
            get;
            set;
        }

        public double RateOfRightAscen
        {
            get;
            set;
        }

        /// <summary>
        ///     Square Root of Semi-Major Axis
        /// </summary>
        public double SqrtA
        {
            get;
            set;
        }

        public Degree RightAscenAtWeek
        {
            get;
            set;
        }

        public Degree ArgumentOfPerigee
        {
            get;
            set;
        }

        public Degree MeanAnom
        {
            get;
            set;
        }

        public double Af0
        {
            get;
            set;
        }

        public double Af1
        {
            get;
            set;
        }

        public int Week
        {
            get;
            set;
        }

        #endregion
    }
}
