class User < ActiveRecord::Base

 private
	validates(:name, format:/\A[A-Z][A-Z0-9@.\-_]*\Z/i, length:{in:1..32})
	validates(:pin, format:/(\A\Z)|(\A[0-9]{4}\Z)/)
	validate do
		self.name = name.upcase
	end

	def self.saltgen
		return (Array("a".."z") + Array("A".."Z") + Array(0..9)).shuffle[0..1].join
	end
	def saltgen
		self.class.saltgen
	end

 public
	def self.add(name, password)
		user = create!(name:name, password:password.crypt(saltgen))
		# プリセットタグ生成
		Tag.create!(user_id:user.id, tag_id:nil, order:0, name:"★")
		Tag.create!(user_id:user.id, tag_id:nil, order:1, name:"★★")
		Tag.create!(user_id:user.id, tag_id:nil, order:2, name:"★★★")
		Tag.create!(user_id:user.id, tag_id:nil, order:3, name:"要トリミング")
		Tag.create!(user_id:user.id, tag_id:nil, order:4, name:"あとで見る")
		Tag.create!(user_id:user.id, tag_id:nil, order:5, name:"あとで印刷")
		Tag.create!(user_id:user.id, tag_id:nil, order:6, name:"可愛い")
		Tag.create!(user_id:user.id, tag_id:nil, order:7, name:"面白い")
		Tag.create!(user_id:user.id, tag_id:nil, order:8, name:"カッコイイ")
		return user
	end

	def self.auth_challenge(name, password)
		user = User.find_by(name:name.upcase)

		if user
			if user.auth_challenge?(password)
				return user
			end
		end

		return nil
	end

	def auth_challenge?(challenge_password)
		if password.blank?
			return false
		end

		if password.start_with?("!") # check disabled user
			return false
		end

		if challenge_password.crypt(password) == password
			return true # OK
		end

		return false
	end

	def chpw!(newpass)
		self.password = newpass.crypt(saltgen)
		save!
	end

	def enable!
		if password.start_with?("!")
			self.password = password[1 .. -1]
			save!
		end
	end

	def disable!
		if !password.start_with?("!")
			self.password = "!" + password
			save!
		end
	end

end
