class Directory
 private
	def initialize(vpath, user_id:nil)
		@user_id = user_id
		@vpath = vpath
		@rpath = vpath2rpath(@vpath, user_id:@user_id)
	end

 protected
	def make_dir_item(vpath, rpath)
		if File.directory?(rpath)
			return {
				type: :dir,
				vpath: vpath,
				datetime: File.mtime(rpath),
			}
		else
			return {
				type: :dir_missing,
				vpath: vpath,
			}
		end
	end

	def make_file_mising_item(vpath)
		return {
			type: :file_missing,
			vpath: vpath,
		}
	end

 public
 	attr_reader :user_id
 	attr_reader :vpath
 	attr_reader :rpath

	def self.factory(vpath, user_id:nil)
		vpath = reg_vpath(vpath)
		first, rest = vpath.split("/", 2)

		case first
		 when nil
			return RootDirectory.new(vpath, user_id:user_id)
		 when "*read"
			nil # TODO
		 when "*bookmark"
			nil # TODO
		 when "*tag"
			nil # TODO
		 else
			return FilesystemDirectory.new(vpath, user_id:user_id)
		end
	end

	def list
#		return [
#			{ type: :dir, vpath:"", datetime: Time.now, size: 0 }
#		]

		return nil
	end
end

############################################################

class RootDirectory < Directory

 public
	def list
		r = [
			{type: :junction, vpath:"*read"},
			{type: :junction, vpath:"*bookmark"},
			{type: :junction, vpath:"*tag"},
		]

		roots(user_id:@user_id).each do |vpath, rpath|
			r << make_dir_item(vpath, rpath)
		end

		r.sort_by! { |v| v[:vpath].to_s }
		return r
	end
end

############################################################

class FilesystemDirectory < Directory

	def make_book_item(vpath, rpath)
		type = Book.type(vpath)
		if type == :images
			datetime = nil
			size = nil
		else
			datetime = File.mtime(rpath)
			size = File.size(rpath)
		end

		return {
			type: type,
			vpath: vpath,
			datetime: datetime,
			size: size,
		}
	end

 public
	def list
		r = []
		img_count = 0
		vpath_glob(@vpath, user_id:@user_id).each do |child_vpath, child_rpath|
			if File.directory?(child_rpath)
				if image_only_dir?(rpath:child_rpath)
					v = reg_vpath(child_vpath, "*img")
					r << make_book_item(v, nil)
				else
					r << make_dir_item(child_vpath, child_rpath)
				end
			elsif File.file?(child_rpath)
				if extname_match?(YOMEYA_IMAGE_EXT, child_vpath)
					img_count += 1
				elsif extname_match?(YOMEYA_ALL_EXT, child_vpath)
					r << make_book_item(child_vpath, child_rpath)
				end
			else
				r << make_file_mising_item(child_vpath)
			end
		end

		if img_count > 0
			v = reg_vpath(@vpath, "*img")
			r << make_book_item(v, nil)
		end

		r.sort_by! { |v| v[:vpath].to_s }
		return r
	end
end

############################################################

#	# 読みかけの本の一覧を作成する
#	def get_filelist_read(vpath)
#		r = []
#		Reading.where(user_id:session[:user_id]).reorder("touch_at desc") do |reading|
#			vpath = reading.vpath
#			type = case
#					when File.basename(vpath) == "*img"
#						:images
#					else
#						:file
#					end
#
#			r << {
#				label: vpath,
#				label2: "",
#				vpath: vpath,
#				type: type,
#			}
#		end
#
#		return r
#	end
