module ApplicationHelper

private
	def vpath_escape(vpath)
		vpath.gsub(/([!"#$%&'?^|`\[\]{}+])/) do |m|
			"%%%02x" % m.ord
		end
	end

public
	def to_path2(tgt_path="", location:nil)
		tgt_path = tgt_path[1 .. -1]  if tgt_path.start_with?("/")
		if location.present?
			return to_path(path:tgt_path, location:location) # vpath_escapeは不要
		else
			return to_path(path:tgt_path) # vpath_escapeは不要
		end
	end

	def filelist_path2(tgt_path="", location:nil)
		tgt_path = tgt_path[1 .. -1]  if tgt_path.start_with?("/")
		if location.present?
			return filelist_path(path:vpath_escape(tgt_path), location:location)
		else
			return filelist_path(path:vpath_escape(tgt_path))
		end
	end

	def viewer_path2(tgt_path, location:nil)
		tgt_path = tgt_path[1 .. -1]  if tgt_path.start_with?("/")
		if location.present?
			return viewer_path(path:vpath_escape(tgt_path), location:location)
		else
			return viewer_path(path:vpath_escape(tgt_path))
		end
	end

	def icon_path2(tgt_path, location:nil)
		tgt_path = tgt_path[1 .. -1]  if tgt_path.start_with?("/")
		if location.present?
			return icon_path(path:vpath_escape(tgt_path), location:location)
		else
			return icon_path(path:vpath_escape(tgt_path))
		end
	end

	def page_path2(tgt_path, location:nil)
		tgt_path = tgt_path[1 .. -1]  if tgt_path.start_with?("/")
		if location.present?
			return page_path(path:vpath_escape(tgt_path), location:location)
		else
			return page_path(path:vpath_escape(tgt_path))
		end
	end

end
