class ViewerController < ApplicationController

 public
	def show
		vpath = reg_vpath(params[:path] || "")
		location = reg_location(params[:location] || "")

		# パラメータの検査
		if !valid_book_path?(vpath)
			return redirect_to(filelist_path)
		end

		# 頁一覧を得る
		pagelist = get_pagelist(vpath)
		if pagelist.empty?
			# 空なら戻る
			vpath = reg_vpath(vpath, "..")
			vpath = reg_vpath(vpath, "..")  if image_only_dir?(vpath:vpath)
			return redirect_to(view_context.to_path2(vpath))
		end

		# 位置の指定がない場合、前回読んでいた場所を得る(初めてなら、先頭から)
		if location.blank?
			reading = Reading.yomeya_find_or_new(session[:user_id], vpath)
			location = reading.location
			location = pagelist.first  if location.blank?  # 空なら先頭の頁
		end

		# model, viewへ情報渡し
		update_page_read(vpath, location)
		@vpath = vpath
		@pagelist = pagelist
		@location = location
	end

	# 頁移動したことを宣言(ajax用)
	# locationだと内部で使われているシンボルと被る
	def loc
		vpath = reg_vpath(params[:path] || "")
		location = reg_location(params[:location] || "")

		# パラメータの検査
		if !valid_page_path?(vpath, location)
			return render(nothing:true, status:400)
		end

		update_page_read(vpath, location)
		render(nothing:true)
	end

	# 終了(filelistに戻る)
	def exit
		path = session[:last_path]
		# まず1つ上の階層に
		path = reg_vpath(path, "..")
		# 画像しかないディレクトリならもう1つ上に
		path = reg_vpath(path, "..")  if image_only_dir?(vpath:path)

		redirect_to(view_context.to_path2(path))
	end

end
