class IconController < ApplicationController
	ICON_W = 48 * 2
	ICON_H = 64 * 2

private
	# 画像データをサイズ調整して返す
	def get_blob(data)
		return nil  if data.blank?

		w, h = ICON_W, ICON_H
		imagelist = Magick::ImageList.new.from_blob(data) do
			self["jpeg", "size"] = "#{w}x#{h}"
		end
		org_format = imagelist.format
		img = imagelist.first
		ww, hh = img.columns, img.rows

#		# 背景を白に
#		bg = Magick::Image.new(ww, hh) do
#			self.background_color = "white"
#		end
#		img.composite!(bg, 0, 0, Magick::DstOverCompositeOp)

		# 拡大縮小率の設定
		ratio = 1
		if Rational(ww, hh) > Rational(w, h)
			ratio = Rational(w, ww)  if ww > w
		else
			ratio = Rational(h, hh)  if hh > h
		end

		# 拡縮実行
		r = img.thumbnail!(ratio).to_blob do
			if org_format == "JPEG"
				self.format = "JPEG"
				self.quality = 96
			else
				self.format = "PNG"
			end
		end
		return r.present? ? r : nil
	end

	# アイコンを得る ディレクトリ用(再帰)
	def get_icon_dir(vpath)
		images, archives, dirs = [], [], []
		vpath_glob(vpath).each do |child_vpath, child_rpath|
			if File.directory?(child_rpath)
				dirs << child_vpath
			elsif extname_match?(YOMEYA_IMAGE_EXT, child_rpath)
				images << child_vpath
			elsif extname_match?(YOMEYA_ARCHIVE_EXT, child_rpath)
				archives << child_vpath
			end
		end

		if !images.empty?
			return get_icon(reg_vpath(vpath, "*img"))
		elsif !archives.empty?
			archives.sort_by! { |v| key4sort(v) }
			return get_icon(archives.first)
		elsif !dirs.empty?
			dirs.sort_by! { |v| key4sort(v) }
			dirs.each do |dir|
				r = get_icon_dir(dir)
				return r  if r.present?
			end
		end

		return nil
	end

	# アイコンを得る キャッシュなし
	def _get_icon(vpath, location)
		rpath = vpath2rpath(vpath)

		if File.directory?(rpath)
			r = get_icon_dir(vpath)
			return r  if r.present?
			return get_blob(asset_image_data("icon_dir.png"))
		else
			r = get_blob(Book.extract_thumbnail(rpath, ICON_W, ICON_H, location))
			return r  if r.present?
			return get_blob(asset_image_data("icon_file_missing.png"))
		end
	end

	# アイコンを得る キャッシュあり
	def get_icon(vpath, location=nil)
		Cache.transaction do
			return Cache.fetch_icon(session[:user_id], vpath, location) do
				_get_icon(vpath, location)
			end
		end
	end

public
	def get
		vpath = reg_vpath(params[:path] || "")
		location = reg_location(params[:location] || "")

		# パラメータの検査
		if !valid_vpath?(vpath)
			return render(nothing:true, status:400)
		end

		# 特殊フォルダの個別アイコン
		case vpath
		 when "*read"
			return redirect_to(view_context.image_path("icon_book.png"))
		 when "*bookmark"
			return redirect_to(view_context.image_path("icon_bookmark.png"))
		 when "*tag"
			return redirect_to(view_context.image_path("icon_tag.png"))
		end

		# その他の通常のアイコン
		r = get_icon(vpath, location)
		if r.blank?
			return redirect_to(view_context.image_path("icon_file_missing.png"))
		end

		send_data(r, type:"image", disposition:"inline")
	end
end
