class FilelistController < ApplicationController

private
	# vpathで示される本の情報を得る
	# 未読ならpageは0
	def get_book_info(vpath)
		user_id = session[:user_id]
		pagelist = get_pagelist(vpath)
		pages = pagelist.count
		page = 0
		location = ""
		start_at = nil
		end_at = nil

		if pages > 0
			reading = Reading.yomeya_find(user_id, vpath)
			if reading
				if reading.location.present?
					location = reading.location
					page = find_pagelist_idx(pagelist, location) + 1
				end
				start_at = reading.start_at
				end_at = reading.end_at
			end
		end

		return {
			pages: pages,
			page: page,
			location: location,
			start_at: start_at,
			end_at: end_at,
		}
	end

	# yyyy/mm/dd 〜 yyyy/mm/dd の形式の文字列を得る
	def span_str(st, ed)	# start, endだとendが予約語でNG
		st = st.localtime  if st.present?
		ed = ed.localtime  if ed.present?

		if !st.present?			# 未読の場合
			r = ""
		elsif !ed.present?		# 読んでいる途中の場合
			r = st.strftime("%Y/%m/%d") + "〜"
		else					# 読了の場合
			if st.year == ed.year
				if st.month == ed.month
					if st.day == ed.day
						r = st.strftime("%Y/%m/%d")
					else
						r = st.strftime("%Y/%m/%d") + "〜" + ed.strftime("%d")
					end
				else
					r = st.strftime("%Y/%m/%d") + "〜" + ed.strftime("%m/%d")
				end
			else
				r = st.strftime("%Y/%m/%d") + "〜" + ed.strftime("%Y/%m/%d")
			end
		end

		return r
	end

	# vpathで示されるディレクトリ等のアイテム一覧を得る
	def get_filelist(vpath)
		user_id = session[:user_id]
		Cache.transaction do
			directory = Directory.factory(vpath, user_id:user_id)
			filelist = directory.list

			filelist.each do |f|
				title = ""
				desc = ""
				indicator1 = []
				indicator2 = []
				sortkey = ""

				case f[:type]
				 when :junction
					case f[:vpath]
					 when "*read"
						title = "読みかけの本"
						desc = "Reading"
						sortkey = "A0"
					 when "*bookmark"
						title = "ブックマーク"
						desc = "Bookmarking"
						sortkey = "A1"
					 when "*tag"
						title = "タグ"
						desc = "Tagging"
						sortkey = "A2"
					end
				 when :images
					d = File.dirname(f[:vpath])
					if d == vpath
						title = "このディレクトリ"
						sortkey = "C"
					else
						title = File.basename(d)
						sortkey = "D" + title
					end
				 when :pdf, :zip
					title = File.basename(f[:vpath], ".*")
					sortkey = "D" + title
				 else
					title = File.basename(f[:vpath])
					sortkey = "D" + title
				end

				if f[:type].is_any_of(:dir, :dir_missing)
					desc = "Directory"
					indicator1 << :dir
					# sortkey = "B" + title
				end

				if f[:type].is_any_of(:images, :pdf, :zip)
					bookinfo = get_book_info(f[:vpath])
					if bookinfo[:start_at].blank?		# 未読の場合
						indicator1 << :unread
					elsif bookinfo[:end_at].blank?		# 読んでいる途中の場合
						indicator1 << :reading
					else				# 読了の場合
						indicator1 << :read
					end

					if indicator1.include?(:unread) ||
							(indicator1.include?(:read) && bookinfo[:page] == bookinfo[:pages])
						desc = ("%dp" % bookinfo[:pages]) +
								" " + span_str(bookinfo[:start_at], bookinfo[:end_at])
					else
						desc = ("%d/%dp" % [bookinfo[:page], bookinfo[:pages]]) +
								" " + span_str(bookinfo[:start_at], bookinfo[:end_at])
					end
				end

				if f[:type].is_any_of(:text, :html)
					desc = File.size(vpath2rpath(f[:vpath])).to_s(:human_size)
				end

				indicator2 << :pdf  if f[:type] == :pdf
				indicator2 << :zip  if f[:type] == :zip

				f[:title] = title
				f[:desc] = desc
				f[:indicator1] = indicator1
				f[:indicator2] = indicator2
				f[:sortkey] = sortkey
			end
			filelist.sort_by! { |v| key4sort(v[:sortkey].to_s) }

			return filelist
		end
	end

public
	def show
		user_id = session[:user_id]
		vpath = reg_vpath(params[:path] || "")

		# パラメータの検査
		if !valid_directory_path?(vpath)
			redirect_to(filelist_path)
			return
		end
		@vpath = vpath

		# @locationのセット
		location = Cache.fetch_location(user_id, vpath)
		location = 0  if location.blank?
		@location = location

		# @parentのセット
		@parent = nil	# rootより上には上がらない
		if vpath.present?
			parent_vpath = reg_vpath(vpath, "..")
			parent_label = File.basename(parent_vpath)
			parent_label = "root"  if parent_label.empty?
			@parent = {label:parent_label, vpath:parent_vpath}
		end

		# @filelistのセット
		@filelist = get_filelist(vpath)

		update_filelist_visit(vpath, location)
		@vpath_from = session[:last_path_from]
	end

	# 移動したことを宣言
	# locationだと内部で使われているシンボルと被る
	def loc
		vpath = reg_vpath(params[:path] || "")
		location = reg_location(params[:location] || "").to_i

		# パラメータの検査
		if !valid_directory_path?(vpath)
			return render(nothing:true, status:400)
		end

		update_filelist_visit(vpath, location)
		render(nothing:true)
	end

end
