class ExecController < ApplicationController

 public
	def rotate(degree)
		user_id = session[:user_id]
		vpath = reg_vpath(params[:path] || "")
		location = reg_location(params[:location] || "")

		# パラメータの検査
		if !valid_page_path?(vpath, location)
			return bad_request
		end

		# 頁を回転
		Book.rotate(vpath2rpath(vpath), location, degree)
		Cache.do_clear(user_id, vpath, location)

		return page_command_epilogue(vpath, [location])
	end

	# 右回転
	def rotate_cw
		rotate(90)
	end

	# 左回転
	def rotate_ccw
		rotate(270)
	end

	def join_page
		user_id = session[:user_id]
		vpath = reg_vpath(params[:path] || "")
		location = reg_location(params[:location] || "")

		# パラメータの検査
		if !valid_page_path?(vpath, location)
			return bad_request
		end

		# 結合する2頁を得る
		rpath = vpath2rpath(vpath)
		pagelist = get_pagelist(vpath)
		loc_idx = find_pagelist_idx(pagelist, location)
		if loc_idx >= 1 && loc_idx < pagelist.size
			prev_location = pagelist[loc_idx - 1]
		else
			return bad_request
		end

		# 結合する方向を得る
		reading_direction = "rl"
		if reading_direction == "rl"
			r_location = prev_location
			l_location = location
		else
			r_location = location
			l_location = prev_location
		end

		# 結合結果を得る
		r_temp = Tempfile.new("yomeya_temp")
		r_temp.binmode
		r_temp.write(Book.extract(rpath, r_location))
		r_temp.flush

		l_temp = Tempfile.new("yomeya_temp")
		l_temp.binmode
		l_temp.write(Book.extract(rpath, l_location))
		l_temp.flush

		o_temp = Tempfile.new("yomeya_temp")
		o_temp.binmode

		cmd = [CONVERT_CMD]
		cmd += ["-quiet", "-background", "black", "-gravity", "center"]
		cmd += ["+append"]
		cmd += [l_temp.path, r_temp.path]
		cmd += [o_temp.path]
		r = system(*cmd)

		if r
			# 旧頁を削除し、新頁を追加
			Book.update(rpath, prev_location, File.binread(o_temp.path))
			Book.delete(rpath, location)
			Cache.do_clear(user_id, vpath)
		end

		r_temp.close!
		l_temp.close!
		o_temp.close!

		return page_command_epilogue(vpath, [prev_location, location])
	end

	def hide_page
		user_id = session[:user_id]
		vpath = reg_vpath(params[:path] || "")
		location = reg_location(params[:location] || "")

		# パラメータの検査
		if !valid_page_path?(vpath, location)
			return bad_request
		end

		# 頁を非表示にする
		Book.delete(vpath2rpath(vpath), location)
		Cache.do_clear(user_id, vpath)

		return page_command_epilogue(vpath, [location])
	end

	def set_unread
		user_id = session[:user_id]
		vpath = reg_vpath(params[:path] || "")

		# パラメータの検査
		if !valid_book_path?(vpath)
			return bad_request
		end

		# 未読に戻す
		reading = Reading.yomeya_find(user_id, vpath)
		if reading
			reading.destroy!
		end

		return page_command_epilogue(vpath)
	end

	def set_read
		user_id = session[:user_id]
		vpath = reg_vpath(params[:path] || "")

		# パラメータの検査
		if !valid_book_path?(vpath)
			return bad_request
		end

		# 読了にする
		reading = Reading.yomeya_find(user_id, vpath)
		if reading
			now = Time.now
			reading.start_at = now  if reading.start_at.blank?
			reading.touch_at = now
			reading.end_at = now  if reading.end_at.blank?
			reading.save!
		end

		return page_command_epilogue(vpath)
	end

	def download_page
		return bad_request
	end

	def download_book
		return bad_request
	end

############################################################

	def page_command_epilogue(vpath, modify=[])
		pagelist = get_pagelist(vpath)
		render(json:{pagelist:pagelist, modify:modify})
	end

	def bad_request
		render(nothing:true, status:400)
	end
end
