# -*- mode:Ruby; tab-width:4; coding:UTF-8; -*-
# vi:set ft=ruby ts=4 fenc=UTF-8 :
#----------------------------------------------------------------
# Yomeya
#
# 2014/01/10 opa
#----------------------------------------------------------------

# constants
YOMEYA_NAME = "Yomeya"
YOMEYA_IMAGES = "*img"
YOMEYA_IMAGE_EXT = %w(jpg jpeg png gif bmp)
YOMEYA_PDF_EXT = %w(pdf)
YOMEYA_ZIP_EXT = %w(zip)
YOMEYA_ARCHIVE_EXT = YOMEYA_PDF_EXT + YOMEYA_ZIP_EXT
YOMEYA_TXT_EXT = %w(txt log)
YOMEYA_HTML_EXT = %w(html)
YOMEYA_AUDIO_EXT = %w(mp3 wav aif aiff)
YOMEYA_VIDEO_EXT = %w(mp4 mov qt)
YOMEYA_OTHER_EXT = YOMEYA_TXT_EXT + YOMEYA_HTML_EXT + YOMEYA_AUDIO_EXT + YOMEYA_VIDEO_EXT
YOMEYA_ALL_EXT = YOMEYA_IMAGE_EXT + YOMEYA_ARCHIVE_EXT + YOMEYA_OTHER_EXT

CONVERT_CMD = "convert"
JPEGTRAN_CMD = "jpegtran"
UNZIP_CMD = "unzip"

# autoload setup
Kernel.autoload(:Open3, "open3")
Kernel.autoload(:Magick, "RMagick")
Kernel.autoload(:Zip, "zip")
module PDF
	Kernel.autoload(:Reader, "pdf/reader")
end

#=====dpk===== Copyright2013
Copyright = "Copyright (c) 2013,2014 by opa"
#=====dpk=====

#=====dpk===== os_is_windows?
# Windows環境下かどうか判定する
module Kernel
 module_function
	if RUBY_PLATFORM =~ /mswin(?!ce)|mingw|cygwin|bccwin|emx/i
		def os_is_windows?; true; end
	else
		def os_is_windows?; false; end
	end
end
#=====dpk=====

if os_is_windows?
	GHOSTSCRIPT_CMD = "gswin32c"
else
	GHOSTSCRIPT_CMD = "gs"
end

#=====dpk===== is_any_of
class Object
	def is_any_of(*v)
		v.each { |v| return true  if v === self }
		false
	end
end
#=====dpk=====

#=====dpk===== Hash.extract
# ハッシュから特定のキー(と値)を抜き出す
class Hash
	def extract(*extract_keys)
		select { |k| k.is_any_of(*extract_keys) }
	end
end
#=====dpk=====

#=====dpk===== Array.join2
# emptyの要素は無視するjoin
class Array
	def join2(sep=$,)
		r = ""
		each do |v|
			v = v.to_s
			if !v.empty?
				r << sep  if !r.empty?
				r << v
			end
		end
		r
	end
end
#=====dpk=====

#=====dpk===== compare4sort
# 記号は先 / 数字は数値順 / 大文字小文字意識しない(全く同じ場合は意識) で比較する
module Kernel
 module_function
	def key4sort(s)
		r = ""
		tmp = s.gsub(/(\d{1,20})/) { ("00000000000000000000" + $1)[-20, 20] }
		tmp.each_char do |c|
			r << case c
			 when /[\s!"\#$%&'()*+,-.\/:;<=>?@\[\\\]^_`{|}~]/;	"a"
			 when /\d/;											"b"
			 when /[a-z]/i;										"c"
			 else;												"z"
			end
			r << c
		end
		t = r.tr(
			"A-ZÄËÏÖÜäëïöü" \
			"〜ァアィイゥウェエォオカガキギクグケゲコゴサザシジスズセゼソゾ" \
			"タダチヂッツヅテデトドナニヌネノハバパヒビピフブプヘベペホボポ" \
			"マミムメモャヤュユョヨラリルレロヮワヰヱヲンヴ",
			"a-zaeiouaeiou" \
			"～ぁあぃいぅうぇえぉおかがきぎくぐけげこごさざしじすずせぜそぞ" \
			"ただちぢっつづてでとどなにぬねのはばぱひびぴふぶぷへべぺほぼぽ" \
			"まみむめもゃやゅゆょよらりるれろゎわゐゑをんゔ"
		)
		return [t, r, s]
	end

	def compare4sort(a, b)
		return key4sort(a) <=> key4sort(b)
	end
end
#=====dpk=====

if os_is_windows?
	module Kernel
		alias :system_verbatim :system
		module_function :system_verbatim

	 module_function
		def system(*arg)
			locale = Encoding.find("locale")
			ival = arg.map do |x|
				x.respond_to?(:encode) ? x.encode(locale) : x
			end
			return system_verbatim(*ival)
		end
	end
end

#def yomeya_text_capture(*cmd)
#	if os_is_windows?
#		locale = Encoding.find("locale")
#		cmd = cmd.map { |x| x.encode(locale) }
#		r = Open3::capture2(*cmd)[0]
#		r.force_encoding(locale)
#		r.encode!
#	else
#		r = Open3::capture2(*cmd)[0]
#	end
#	return r
#end

#def yomeya_binary_capture(*cmd)
#	if os_is_windows?
#		tempfile = Tempfile.new(YOMEYA_NAME)
#
#		system(*cmd, in:File::NULL, out:tempfile.path, err:File::NULL)
#		r = File.binread(tempfile.path)
#
#		tempfile.close!
#	else
#		r = Open3::capture2(*cmd)[0]
#	end
#	return r.force_encoding(Encoding::BINARY)
#end

def wildcard_escape(s)
	return s.gsub(/([*?\[\]{}\\])/) { |m| "\\" + m }
end

# 拡張子(.つけない)の配列からDir.globで使えるワイルドカード文字列を生成する
def wildcard_str(extnames, basename:"*")
	w = Array(extnames).map do |ext|
		w = ""
		ext.each_char do |char|
			u = char.upcase
			d = char.downcase
			w += (u != d) ? "[" + u + d + "]" : char
		end
		w
	end
	case w.count
	 when 0
		return basename
	 when 1
		return basename + "." + w[0]
	 else
		return basename + ".{" + w.join(",") + "}"
	end
end

# 与えられた拡張子と等しいか判定する
def extname_match?(extnames, filename)
	if filename.present?
		Array(extnames).each do |ext|
			if File.fnmatch?(wildcard_str(ext), filename)
				return true
			end
		end
	end

	return false
end

module Yomu
end
