# = #require hammer
# = #require jquery.hammer
# = require message_box
# = require wait_circle

# 使えない文字をエスケープ
yomeya_escape = (s) ->
	return s.replace /([!"#$%&'?^|`\[\]{}+])/g, (s, m) ->
		r = "00" + (m.charCodeAt(0).toString(16))
		return "%" + r.substring(r.length - 2)

# ハッシュから値を削除
hash_delete_by = (h, k) ->
	r = {}
	$.each h, (hk, hv) ->
		if hk != k
			r[hk] = hv
		return true
	return r

# 完了を待つpost
syncPost = (url, data) ->
	show_wait_circle()

	r = jQuery.ajax({
		type: "POST",
		url: url,
		data: data,
		dataType: "json",
		async: false
	})

	hide_wait_circle()
	return r.responseJSON

# Ajaxコマンド実行
ajax_exec_cmd = (cmd, message, skip=0) ->
	Y = window.yomeya
	hide_all_ui()
	message_box message, null, ->
		r = syncPost("/exec/#{cmd}", current_vpath_location())
		Y.pagelist = r.pagelist
		$.each r.modify, (i, v) ->
			delete Y.page_cache[v]
			return true
		show_image(Y.loc_idx + skip)

# vpathとlocationからpageのURLを得る
to_url = (location) ->
	Y = window.yomeya
	url = "/page/" + yomeya_escape(Y.vpath) + "?location=" + yomeya_escape(location)
	return url

# 現在のvpathからなるオブジェクトを得る
current_vpath = ->
	Y = window.yomeya
	return {path:Y.vpath}

# 現在のvpathとlocationからなるオブジェクトを得る
current_vpath_location = ->
	Y = window.yomeya
	return {path:Y.vpath, location:Y.pagelist[Y.loc_idx]}

# 何頁目かを数値で得る
location_to_idx = (location) ->
	Y = window.yomeya
	# まずは完全一致を探す
	i = Y.pagelist.indexOf(location)
	return i  if i >= 0
	# 完全一致がない場合は最も近いもの
	for loc, i in Y.pagelist
		if loc >= location
			return i
	return 0  # 見つからない場合は先頭頁

# 次に何頁をキャッシュに入れるか算出する
get_next_prefetch_loc_idx = ->
	Y = window.yomeya
	for i in [0 .. 1]
		loc_idx = Y.loc_idx
		cache_direction = Y.page_cache_direction
		cache_direction *= -1  if i != 0 # 2周目は逆順
		while true
			loc_idx += cache_direction
			if !(0 <= loc_idx < Y.pagelist.length)
				break
			location = Y.pagelist[loc_idx]
			if !Y.page_cache[location]?
				return loc_idx
	return 0 # 全頁キャッシュ済み

# n頁目の画像オブジェクトを生成
get_image = (loc_idx, prefetch) ->
	Y = window.yomeya
	location = Y.pagelist[loc_idx]
	if location?
		# 既に生成済ならそれを返す (但しロード中かもしれない)
		if Y.page_cache[location]?
			return Y.page_cache[location]

		img = $("<img>").addClass("page").attr("id", "page_" + loc_idx)
		Y.page_cache[location] = img
		img.load ->
			$(this).addClass("loaded")
			if prefetch?
				get_image(get_next_prefetch_loc_idx(), true)
		img.attr("src", to_url(location))
		return img
	return null

# canvasに縦横比を保って内接するようサイズ調整
update_image_size = (canvas, img) ->
	canvas_width = canvas.width()
	canvas_height = canvas.height()
	canvas_aspect_ratio = canvas_width / canvas_height # 大きいほど横長
	img_width = img.width()
	img_height = img.height()
	img_aspect_ratio = img_width / img_height

	if img_aspect_ratio > canvas_aspect_ratio # 画面より横長なら
		new_width = canvas_width
		new_height = canvas_width / img_aspect_ratio
	else
		new_width = canvas_height * img_aspect_ratio
		new_height = canvas_height

	img.width(new_width)
	img.height(new_height)
	img.css("top", (canvas_height - new_height) / 2)
	img.css("left", (canvas_width - new_width) / 2)

# 頁の画像を表示する
show_image = (loc_idx, transition) ->
	Y = window.yomeya
	slideshow("prevent")	# スライドショー遷移を保留
	loc_idx = Y.pagelist.length - 1  if loc_idx >= Y.pagelist.length
	loc_idx = 0  if loc_idx < 0
	img = get_image(loc_idx)
	if !img.hasClass("loaded")
		# 画像のロードがまだ終わっていなければ待つ
		setTimeout ->
			show_image(loc_idx)
		, 50
	else
		canvas = $("#canvas")
		canvas.children().not(".showing").remove() # 今表示しているもの以外は削除
		old = canvas.children() # 今表示しているもの
		old.removeClass("showing")
		img.addClass("showing")

		# ついているクラスを削除してきれいにする
		cls = "cut_out fade_in fade_out right_in right_out left_in left_out"
		old.removeClass(cls)
		img.removeClass(cls)

		# img != old なら画面遷移
		if !old.hasClass("showing")
			# 画面遷移効果
			if transition?
				if transition == "right_in" || transition == "left_in"
					old.css("z-index", -1).addClass("fade_out")
					img.css("z-index", 0).addClass(transition)
				else
					old.css("z-index", 0).addClass(transition)
					img.css("z-index", -1).addClass("fade_in")
			else
				old.css("z-index", 0).addClass("cut_out")
				img.css("z-index", -1)

			# 画面遷移が終わった頃にDOMツリーから削除
			setTimeout ->
				old.remove()  if !old.hasClass("showing")
			, 500

			canvas.prepend(img)
			update_image_size(canvas, img)

		# 内部情報更新
		Y.loc_idx = loc_idx
		# メニュー1の情報更新
		update_menu1()
		# サーバの情報更新
		$.post("/viewer/loc", current_vpath_location())
		# スライドショー中なら
		if slideshow("running?")
			slideshow("next")

# 画面リサイズ時の処理 本体
_onresize_handler = ->
	Y = window.yomeya
	status_height = 0
	w = window.innerWidth
	h = window.innerHeight

	if "ios" in Y.uatype
		status_height = 17
		if window.innerWidth < window.innerHeight
			w = screen.width # 縦長の場合
			h = screen.height
		else
			w = screen.height # 横長の場合
			h = screen.width

	hide_all_ui()
	$('meta[name="viewport"]').attr("content", "width=#{w}px,height=#{h}px")
	$(".tap_panel").width(w).height(h)
	$(".ui_panel").width(w).height(h)
	$("#canvas").width(w).height(h - status_height).css("top", status_height)
	update_image_size($("#canvas"), $(".showing"))

# 画面リサイズ時の処理 元請け
onresize_handler = ->
	Y = window.yomeya
	if Y.onresize_handler_timer?
		clearTimeout(Y.onresize_handler_timer)
	Y.onresize_handler_timer = setTimeout(->
		Y.onresize_handler_timer = null
		_onresize_handler()
	, 100)

# フルスクリーン化
request_fullscreen = ->
	body = document.body
	if body.requestFullScreen?
		body.requestFullScreen()
	else if body.mozRequestFullScreen?
		body.mozRequestFullScreen()
	else if body.webkitRequestFullScreen?
		body.webkitRequestFullScreen()

# キー入力時の処理
onkeydown_handler = (ev) ->
	return true  if $("#menu1").css("display") != "none"

	Y = window.yomeya
	ev.preventDefault()
	w = ev.which
	k = ev.keyCode
	c = ev.charCode

	if k == 37 && c == 0 # ←
		if Y.reading_direction == "lr"
			move_prev_page()
		else
			move_next_page()
	else if k == 38 && c == 0 # ↑
		move_prev_page()
	else if k == 39 && c == 0 # →
		if Y.reading_direction == "lr"
			move_next_page()
		else
			move_prev_page()
	else if k == 40 && c == 0 # ↓
		move_next_page()
	else if k == 8 && c == 0 # [BS]
		close_book()
#	else if k == 0 && c == 102 # [f]
#		request_fullscreen()
#	else
#		alert "w#{w} k#{k} c#{c}"

# マウスホイール回転時の処理
onwheel_handler = (ev) ->
	return true  if $("#menu1").css("display") != "none"

	Y = window.yomeya
	ev.preventDefault()
	dy = ev.originalEvent.deltaY
	if "firefox" in Y.uatype
		dy *= 100.0 / 3.0

	Y.wheelY += dy
	if Y.wheelY <= -100
		move_next_page()
	else if Y.wheelY >= 100
		move_prev_page()
	Y.wheelY %= 100

# 初期設定
$ ->
	# controllerから引数を受け取る & 変数初期化
	Y = window.yomeya = {}
	Y.uatype = $("#Y").data("uatype")
	Y.vpath = $("#Y").data("vpath")
	Y.pagelist = $("#Y").data("pagelist")
	Y.loc_idx = location_to_idx($("#Y").data("location"))
	Y.reading_direction = "rl"
	Y.wheelY = 0
	Y.page_cache = {}
	Y.page_cache_direction = 1

	# 一部を除きスクロール禁止
	$(document).on "touchmove", (e) ->
		e.preventDefault()
	$(".scrollable").on "touchmove", (e) ->
		e.stopPropagation()

	# ハンドラ設定
	$.each [
		[".tap_close_book", close_book]
		[".tap_first", cmd_first_page]
		[".tap_last", cmd_last_page]
		[".tap_next", tap_next]
		[".tap_prev", tap_prev]
		[".tap_show_menu1", show_menu1]
		[".tap_show_menu2", show_menu2]
		["#cmd_first_page", cmd_first_page]
		["#cmd_last_page", cmd_last_page]
		["#cmd_close_book", close_book]
		["#cmd_close_menu", hide_menu1]
		["#cmd_next", -> cmd_moveto(1)]
		["#cmd_next10", -> cmd_moveto(10)]
		["#cmd_prev", -> cmd_moveto(-1)]
		["#cmd_prev10", -> cmd_moveto(-10)]
		["#cmd_pagelist", cmd_pagelist]
	], (_, v) ->
		# 反応のいいclickイベントハンドラを追加する
		$(v[0]).off().on "click touchstart", (ev) ->
			ev.preventDefault()
			v[1]()

	# メニュー1の情報更新
	update_menu1()

	# フック
	_onresize_handler()
	$(window).on("orientationchange resize", onresize_handler)
	if "pc" in Y.uatype
		$(window).on("keydown", onkeydown_handler)
		$(window).on("wheel", onwheel_handler)
#	else
#		$(".tap_panel").hammer().on "swiperight", (ev) ->
#			ev.preventDefault()
#			tap_next()
#		$(".tap_panel").hammer().on "swipeleft", (ev) ->
#			ev.preventDefault()
#			tap_prev()

	# 画像を表示 & プリフェッチ開始
	get_image(Y.loc_idx, true)
	show_image(Y.loc_idx)
	hide_wait_circle()

############################################################

# スライドショーを行う処理
slideshow = (action) ->
	Y = window.yomeya
	if action == "start"
		Y.slideshow_interval = 3000
		slideshow("next")
	else if action == "stop"
		Y.slideshow_interval = null
		if Y.slideshow_timer?
			clearTimeout(Y.slideshow_timer)
			Y.slideshow_timer = null
	else if action == "next"
		if Y.loc_idx < Y.pagelist.length - 1
			Y.slideshow_timer =
				setTimeout(move_next_page, Y.slideshow_interval)
		else
			Y.slideshow_timer = setTimeout ->
				notice("スライドショー終了")
			, Y.slideshow_interval
			Y.slideshow_interval = null
	else if action == "running?"
		return Y.slideshow_interval?
	else if action == "prevent"
		if Y.slideshow_timer?
			clearTimeout(Y.slideshow_timer)
			Y.slideshow_timer = null

############################################################

# 頁移動
move_page_to = (loc_idx, transition) ->
	Y = window.yomeya
	if loc_idx >= Y.pagelist.length
		loc_idx = Y.pagelist.length - 1
		notice("最後の頁です")
	if loc_idx < 0
		loc_idx = 0
		notice("先頭の頁です")

	show_image(loc_idx, transition)

move_first_page = ->
	move_page_to(0)

move_last_page = ->
	move_page_to(window.yomeya.pagelist.length - 1)

# 相対頁移動
move_page_relative = (offset) ->
	Y = window.yomeya
	loc_idx = Y.loc_idx + offset
	Y.page_cache_direction = if offset >= 0 then 1 else -1

	transition = null
	if Y.reading_direction == "rl"
		if offset > 0
			transition = "right_out"
		else if offset < 0
			transition = "right_in"
	else if Y.reading_direction == "lr"
		if offset > 0
			transition = "left_out"
		else if offset < 0
			transition = "left_in"

	move_page_to(loc_idx, transition)

move_next_page = ->
	move_page_relative(1)

move_prev_page = ->
	move_page_relative(-1)

############################################################

show_menu1 = ->
	Y = window.yomeya
	slideshow("stop") # とりあえずスライドショーを停止
	tap = $(".tap_panel .tap")
	if tap.css("opacity") != 0
		tap.css("opacity", 0)

	# メニューアイテムの設定
	$("#menu1_cmds li").remove()
	cmds = [
		["cmd_pageinfo",	cmd_pageinfo,		"この頁の情報を表示"]
		["cmd_set_tag",		cmd_set_tag,		"タグをつける"]
		["cmd_show_tag",	cmd_show_tag,		"つけたタグ"]
		["cmd_start_slideshow",	cmd_start_slideshow,	"スライドショー"]
		["cmd_rotate_page_cw",	cmd_rotate_page_cw,	"この頁を右90度回転"]
		["cmd_rotate_page_ccw",	cmd_rotate_page_ccw,	"この頁を左90度回転"]
		["cmd_join_page",	cmd_join_page,		"前の頁と見開きにする"]
		["cmd_hide_page",	cmd_hide_page,		"この頁を非表示にする"]
		["cmd_set_unread",	cmd_set_unread,		"この本を未読にする"]
		["cmd_set_read",	cmd_set_read,		"この本を読了にする"]
		["cmd_download_page",	cmd_download_page,	"この頁をダウンロード"]
		["cmd_download_book",	cmd_download_book,	"この本をダウンロード"]
		["cmd_fullscreen",	cmd_fullscreen,		"フルスクリーン表示"]
		["cmd_toggle_tap",	cmd_toggle_tap,		"画面タップのガイドを表示"]
		["cmd_setting",		cmd_setting,		"設定"]
	]
	$.each cmds, (_, cmd) ->
		icon = $("<div>").addClass("icon").attr("id", cmd[0])
		text = $("<div>").text(cmd[2])
		tr = $("<tr>").append($("<td>").append(icon)).append($("<td>").append(text))
		li = $("<li>").addClass(cmd[0]).append($("<table>").append(tr))
		$("#menu1_cmds").append(li)
		li.on "click", (ev) ->
			ev.preventDefault()
			cmd[1]()

	# アイコン画像を設定
	src = "url(/assets/cmd.png)"
	if $("#menu1 .icon").css("background-image") != src
		# convert -strip +append cmd_*.png cmd.png
		$("#menu1 .icon").css("background-image", src)
		pos = 0
		for el in [
			"#cmd_close_book",	"#cmd_close_menu",	"#cmd_download_book",	"#cmd_download_page"
			"#cmd_first_page",	"#cmd_hide_page",	"#cmd_join_page",	"#cmd_last_page"
			"#cmd_next",		"#cmd_next10",		"#cmd_pagelist",	"#cmd_prev"
			"#cmd_prev10",		"#cmd_rotate_page_ccw",	"#cmd_rotate_page_cw",	"#cmd_set_read"
			"#cmd_set_tag",		"#cmd_set_unread",	"#cmd_setting",		"#cmd_show_tag"
			"#cmd_start_slideshow",	"#cmd_toggle_tap"
		]
			$(el).css("background-position", "#{pos}px 0")
			pos -= $(el).width()

	# 不要なメニューアイテムを非表示にする
	if true
		$("#cmd_set_tag").parents("li").css("display", "none")
		$("#cmd_show_tag").parents("li").css("display", "none")
	unless "pc" in Y.uatype
		$("#cmd_download_page").parents("li").css("display", "none")
		$("#cmd_download_book").parents("li").css("display", "none")
		$("#cmd_fullscreen").parents("li").css("display", "none")

	hide_all_ui()
	$(".tap_panel").hide()
	$("#menu1").show()

	# メニューコマンドの幅を設定
	ul = $("#menu1 ul")
	li = $("#menu1 ul li")
	if li.length > 0
		menu1_columns = Math.floor(ul[0].clientWidth / 260)
		li.width(ul[0].clientWidth / menu1_columns)
	ul.height(window.innerHeight - $("#menu1_head").height() - $("#menu1_foot").height() - 2) # 2はborder

hide_menu1 = ->
	$(".tap_panel").show()
	$("#menu1").fadeOut("fast")

update_menu1 = ->
	Y = window.yomeya
	$("#menu1_vpath").text(Y.vpath.replace(/\/\*img$/, "/"))
	$("#menu1_location").text(Y.pagelist[Y.loc_idx])
	$("#menu1_posbar").css("width", "#{Y.loc_idx / (Y.pagelist.length-1) * 100}%")
	$("#menu1_pages_count").text("#{Y.loc_idx+1} / #{Y.pagelist.length}")

show_menu2 = ->

# notice(画面上部 長)を表示
notice = (msg) ->
	Y = window.yomeya
	if Y.notice_timer?
		clearTimeout(Y.notice_timer)
		Y.notice_timer = null
	$("#notice").stop(true, true).text(msg).show()
	Y.notice_timer = setTimeout ->
		Y.notice_timer = null
		$("#notice").fadeOut("slow")
	, 1500

# notice2(画面中央 短)を表示
notice2 = (msg) ->
	Y = window.yomeya
	if Y.notice2_timer?
		clearTimeout(Y.notice2_timer)
		Y.notice2_timer = null
	$("#notice2").stop(true, true).text(msg).show()
	Y.notice2_timer = setTimeout ->
		Y.notice2_timer = null
		$("#notice2").fadeOut("fast")
	, 400

hide_all_ui = ->
	hide_menu1()

############################################################

tap_next = ->
#	notice2("次の頁")
	move_next_page()

tap_prev = ->
#	notice2("前の頁")
	move_prev_page()

close_book = ->
	show_wait_circle()
	location.href = "/viewer/exit"

cmd_first_page = ->
	notice2("先頭の頁")
	move_first_page()

cmd_last_page = ->
	notice2("最後の頁")
	move_last_page()

cmd_pageinfo = ->
	# TODO

cmd_set_tag = ->
	Y = window.yomeya
	cmd = "set_tag"

cmd_show_tag = ->
	Y = window.yomeya
	cmd = "show_tag"

cmd_start_slideshow = ->
	hide_all_ui()
	if slideshow("running?")
		slideshow("stop")
	else
		slideshow("start")

cmd_rotate_page = (degree) ->
	cmd = if degree == 90 then "rotate_cw" else "rotate_ccw"
	ajax_exec_cmd(cmd, "この頁を回転します")

cmd_rotate_page_cw = ->
	cmd_rotate_page(90)

cmd_rotate_page_ccw = ->
	cmd_rotate_page(270)

cmd_join_page = ->
	ajax_exec_cmd("join_page", "前の頁と結合して見開きにします", -1)

cmd_hide_page = ->
	ajax_exec_cmd("hide_page", "この頁を非表示にします")

cmd_set_unread = ->
	cmd = "set_unread"
	message_box "この本を未読にします", null, ->
		syncPost("/exec/#{cmd}", current_vpath())
		close_book()

cmd_set_read = ->
	cmd = "set_read"
	message_box "この本を読了にします", null, ->
		syncPost("/exec/#{cmd}", current_vpath())
		close_book()

cmd_fullscreen = ->
	request_fullscreen()

cmd_download_page = ->
	ajax_exec_cmd("download_page", "download_page")

cmd_download_book = ->
	ajax_exec_cmd("download_book", "download_book")

cmd_toggle_tap = ->
	hide_all_ui()
	tap = $(".tap_panel .tap")
	tap.css("opacity", 1.0)

cmd_setting = ->
	show_wait_circle()
	location.href = "/setting"

cmd_moveto = (offset) ->
	if offset >= 0
		if offset == 1
			notice2("次の頁")
		else
			notice2("#{offset}頁進む")
	else
		if offset == -1
			notice2("前の頁")
		else
			notice2("#{-offset}頁戻る")
	move_page_relative(offset)

cmd_pagelist = ->
	show_wait_circle()
	location.href = "/pagelist"
