# サムネイル画像の遅延ロード
load_thumbnail = ->
	Y = window.yomeya
	image = null

	# 表示領域の中央に最も近い頁を優先してロード
	v_middle = $("html").scrollTop() + $("body").scrollTop() + window.innerHeight / 2
	nearest = null
	for img in Y.imagelist
		e = $("##{img[0]}")
		if e.hasClass("defer")
			e_middle = e.offset().top + e.height() / 2
			dist = Math.abs(v_middle - e_middle)
			if nearest == null || nearest > dist
				nearest = dist
				image = img

	# ロードを行う
	if image?
		id = image[0]
		src = image[2]
		$("##{id}").removeClass("defer").load( ->
			setTimeout(load_thumbnail, 0)
		).attr("src", src)

set_scroll_top = ->
	Y = window.yomeya
	v_height = window.innerHeight

	image = null
	for img in Y.imagelist
		if img[1] == Y.location
			image = img
			break

	if image?
		e = $("##{image[0]}")
		e_top = e.offset().top
		e_bottom = e_top + e.height()
		$("html,body").scrollTop((e_top + e_bottom) / 2 - v_height / 2)

@moveto = (url) ->
	location.href = url

# 初期設定
$ ->
	# controllerから引数を受け取る & 変数初期化
	Y = window.yomeya = {}
	Y.vpath = $("#Y").data("vpath")
	Y.location = $("#Y").data("location")
	Y.imagelist = $("#Y").data("imagelist")

	set_scroll_top()

	# サムネイル画像のロード開始 パラで
	for i in [1 .. 8]
		setTimeout(load_thumbnail, i * 30)
