# = #require hammer
# = #require jquery.hammer
# = require wait_circle

# アイテムの高さの設定
update_listitem_height = ->
	max_height = 0
	$(".icon_area, .desc_area").each ->
		height = $(this).height()
		if height > max_height
			max_height = height
		return true
	$(".icon_area").height(max_height)

# サムネイル画像のロード
load_thumbnail = ->
	Y = window.yomeya
	image = null

	# 表示領域の中央に最も近い頁を優先してロード
	v_middle = $("html").scrollTop() + $("body").scrollTop() + Y.window_inner_height / 2
	nearest = null
	for img in Y.imagelist
		e = $("##{img[0]}")
		if e.hasClass("defer")
			e_middle = e.offset().top + e.height() / 2
			dist = Math.abs(v_middle - e_middle)
			if nearest == null || nearest > dist
				nearest = dist
				image = img

	# ロードを行う
	if image?
		id = image[0]
		src = image[1]
		$("##{id}").removeClass("defer").load( ->
			$(this).addClass("thumbnail")  if $(this).height() > 32 || $(this).width() > 32
			setTimeout(->
				update_listitem_height()
				set_scroll_top()
				load_thumbnail()
			, 0)
		).attr("src", src)

# 前回のスクロール位置を再現
set_scroll_top = ->
	Y = window.yomeya
	location = Y.location
	if location?
		# ユーザが自らスクロールを行った場合は位置変更しない
		scrolltop = $("html").scrollTop() + $("body").scrollTop()
		if Y.last_scrolltop? && scrolltop != Y.last_scrolltop
			Y.last_scrolltop = -1
		else
			# 前回のスクロールと同じになる高さを算出
			li_height = $("li").height()
			row = Math.floor(location / li_height)
			loc = Math.floor(row / Y.columns) * li_height
			loc += location - (row * li_height)

			# 但し、ハイライトアイテムが画面からはみ出す場合は画面内におさめる
			hle = $(".highlight")
			if hle.size() > 0
				hle_top = hle.position().top
				hle_bottom = hle_top + hle.height()
				if hle_top < loc
					loc = hle_top
				else if hle_bottom > loc + Y.window_inner_height
					loc = hle_bottom - Y.window_inner_height

			$("html,body").scrollTop(loc)
			Y.last_scrolltop = $("html").scrollTop() + $("body").scrollTop()

# 現在位置を保存して遷移
@moveto = (new_vpath) ->
	Y = window.yomeya

	# 1段表示だったときの現在位置を逆算
	scrolltop = $("html").scrollTop() + $("body").scrollTop()
	li_height = $("li").height()
	row = Math.floor(scrolltop / li_height)
	loc = row * li_height * Y.columns
	loc += scrolltop - (row * li_height)

	show_wait_circle()

	$.post "/filelist/loc", {path:Y.vpath, location:loc}, ->
		window.location.href = new_vpath

# 画面リサイズ時の処理 本体
_onresize_handler = ->
	Y.window_inner_height = window.innerHeight
	# アイテムの幅の設定
	if $("li").length > 0
		filelist_width = $("#filelist").innerWidth()
		listitem_width = 320
		window.yomeya.columns = columns = Math.floor(filelist_width / listitem_width)
		new_listitem_width = Math.floor(filelist_width / columns)
		$("li").width(new_listitem_width)
		desc_area = $(".desc_area")
		desc_area.css("max-width", new_listitem_width - desc_area.position().left)

# 画面リサイズ時の処理 元請け
onresize_handler = ->
	Y = window.yomeya
	if Y.onresize_handler_timer?
		clearTimeout(Y.onresize_handler_timer)
	Y.onresize_handler_timer = setTimeout(->
		Y.onresize_handler_timer = null
		_onresize_handler()
	, 100)

# 初期設定
onload_handler = ->
	# controllerから引数を受け取る & 変数初期化
	Y = window.yomeya = {}
	Y.uatype = $("#Y").data("uatype")
	Y.vpath = $("#Y").data("vpath")
	Y.location = $("#Y").data("location")
	Y.imagelist = $("#Y").data("imagelist")
	Y.parent = $("#Y").data("parent")
	Y.columns = 1
	Y.last_scrolltop = 0
	Y.window_inner_height = window.innerHeight

	# ヘッダの高さに合わせて詰め物の高さを調整
	$("#header_padding").height($("#filelist_header").outerHeight())

	# フック
	_onresize_handler()
	$(window).on("orientationchange resize", onresize_handler)
#	$(window).hammer().on "swiperight", ->
#		moveto(Y.parent)  if Y.parent?

	set_scroll_top()
	hide_wait_circle()

	# サムネイル画像のロード開始 パラで
	for i in [1 .. 8]
		setTimeout(load_thumbnail, i * 30)

# 頁遷移時にハンドラを実行
$(document).on("page:load", onload_handler)
$(onload_handler)
