class ToController < ApplicationController

 private
	# パスが表すものの種類に応じて分岐
	def to_dispatch(vpath, location=nil)
		if valid_book_path?(vpath)
			return redirect_to(view_context.viewer_path2(vpath, location:location))
		elsif valid_directory_path?(vpath)
			return redirect_to(view_context.filelist_path2(vpath, location:location))
		end

		return redirect_to(filelist_path) # いずれでもない場合、ルートへ
	end

 public
	# パラメタで与えられたところへ移動
	def index
		vpath = Vpath(session[:user_id], params[:path] || "")
		location = Vpath.reg_location(params[:location] || "")
		return to_dispatch(vpath, location)
	end

	# 前回表示していたところへ移動
	def last
		vpath = Vpath(session[:user_id], session[:last_path] || "")
		return to_dispatch(vpath)
	end

	# ひとつ上の階層へ移動
	def parent
		vpath = Vpath(session[:user_id], session[:last_path] || "")
		# まず1つ上の階層に
		vpath = vpath.parent
		# 画像しかないディレクトリならもう1つ上に
		vpath = vpath.parent  if image_only_dir?(vpath)
		return to_dispatch(vpath)
	end

end
