//= require wait_circle

# 画面サイズ変更時の処理
onresize_handler = ->
	bg_width = 640
	bg_height = 312
	bg_ratio = window.innerWidth / bg_width
	bg_top_offset = (window.innerHeight - bg_height * bg_ratio) / 2

	$("html,body").height(window.innerHeight)
	$("body").css("background-position", "center #{bg_top_offset}px")

# 画面表示時の処理
onload_handler = ->
	hide_wait_circle()
	onresize_handler()

# 画面表示時/リサイズ時にハンドラを実行
$(window).on("orientationchange resize", onresize_handler)
$(document).on("page:load", onload_handler)
$(onload_handler)

# よそへ移動
goto = (url) ->
	show_wait_circle()
	location.href = url
