package jp.xet.eclipse.strictjava.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

import jp.xet.eclipse.strictjava.StrictJavaPlugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

/**
 * TODO for daisuke
 * 
 * @since 1.0.0
 * @version $Id: StrictJavaProjectWizard.java 135 2009-10-15 01:58:06Z daisuke_m $
 * @author daisuke
 */
@SuppressWarnings("restriction")
public class StrictJavaProjectWizard extends NewElementWizard implements IExecutableExtension {
	
	private NewStrictJavaProjectWizardPage page;
	
	private IConfigurationElement fConfigElement;
	

	/**
	 * インスタンスを生成する。
	 */
	public StrictJavaProjectWizard() {
		setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWJPRJ);
		setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
		setWindowTitle(NewWizardMessages.JavaProjectWizard_title);
	}
	
	@Override
	public void addPages() {
		page = new NewStrictJavaProjectWizardPage();
		addPage(page);
		
		page.init(getSelection(), getActivePart());
	}
	
	@Override
	public IJavaElement getCreatedElement() {
		return page.getJavaProject();
	}
	
	@Override
	public boolean performCancel() {
		page.performCancel();
		return super.performCancel();
	}
	
	@Override
	public boolean performFinish() {
		boolean res = super.performFinish();
		final IJavaProject javaProject = page.getJavaProject();
		final IWorkingSet[] workingSets = page.getWorkingSets();
		
		final Map<String, String> replace = new HashMap<String, String>();
		replace.put("${projectName}", javaProject.getProject().getName());
		replace.put("${groupId}", page.getGroupId()); // TODO
		replace.put("${currentYear}", String.valueOf(Calendar.getInstance().get(Calendar.YEAR)));
		replace.put("${copyrightHolder}", page.getCopyrightHolder());
		
		if (res) {
			new Job("create strict Java project") {
				
				@Override
				protected IStatus run(IProgressMonitor monitor) {
					monitor.beginTask("creating strict Java project", 4);
					
					StrictJavaPlugin.makeStrict(javaProject, replace, new SubProgressMonitor(monitor, 1));
					
					final IJavaElement newElement = getCreatedElement();
					
					if (workingSets.length > 0) {
						PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets(newElement, workingSets);
					}
					monitor.worked(1);
					
					BasicNewProjectResourceWizard.updatePerspective(fConfigElement);
					selectAndReveal(javaProject.getProject());
					
					monitor.worked(1);
					
					Display.getDefault().asyncExec(new Runnable() {
						
						public void run() {
							IWorkbenchPart activePart = getActivePart();
							if (activePart instanceof IPackagesViewPart) {
								PackageExplorerPart view = PackageExplorerPart.openInActivePerspective();
								view.tryToReveal(newElement);
							}
						}
					});
					monitor.worked(1);
					return Status.OK_STATUS;
				}
			}.schedule();
		}
		return res;
	}
	
	/*
	 * Stores the configuration element for the wizard.  The config element will be used
	 * in <code>performFinish</code> to set the result perspective.
	 */
	public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
		fConfigElement = cfig;
	}
	
	@Override
	protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
		page.performFinish(monitor); // use the full progress monitor
	}
	
	@Override
	protected void handleFinishException(Shell shell, InvocationTargetException e) {
		String title = NewWizardMessages.JavaProjectWizard_op_error_title;
		String message = NewWizardMessages.JavaProjectWizard_op_error_create_message;
		ExceptionHandler.handle(e, getShell(), title, message);
	}
	
	private IWorkbenchPart getActivePart() {
		IWorkbenchWindow activeWindow = getWorkbench().getActiveWorkbenchWindow();
		if (activeWindow != null) {
			IWorkbenchPage activePage = activeWindow.getActivePage();
			if (activePage != null) {
				return activePage.getActivePart();
			}
		}
		return null;
	}
}
