package jp.xet.eclipse.strictjava.actions;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

import jp.xet.eclipse.strictjava.StrictJavaPlugin;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;

public class SettingAction extends ActionDelegate implements IObjectActionDelegate {
	
	private IStructuredSelection selection;
	
	@SuppressWarnings("unused")
	private IWorkbenchPart targetPart;
	

	@Override
	public void run(IAction action) {
		final Object[] elements = selection.toArray();
		final Map<String, String> replace = new HashMap<String, String>();
		replace.put("${groupId}", "com.example"); // TODO
		replace.put("${currentYear}", String.valueOf(Calendar.getInstance().get(Calendar.YEAR)));
		replace.put("${copyrightHolder}", "${user)");
		new Job("make java project strict") {
			
			@Override
			protected IStatus run(IProgressMonitor monitor) {
				monitor.beginTask("making java project strict", elements.length);
				for (Object element : elements) {
					if (element instanceof IJavaProject) {
						IJavaProject project = (IJavaProject) element;
						replace.put("${projectName}", project.getJavaProject().getProject().getName());
						StrictJavaPlugin.makeStrict(project, replace, new SubProgressMonitor(monitor, 1));
					}
					monitor.worked(1);
				}
				return Status.OK_STATUS;
			}
		}.schedule();
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			this.selection = (IStructuredSelection) selection;
		}
	}
	
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.targetPart = targetPart;
	}
	
	/**
	 * @param object a target resource
	 * @param directory if object is a file, then return its parent path.
	 * @return
	 */
	protected String getPath(Object object, boolean directory) {
		
		if (object instanceof IAdaptable) {
			IResource resource = (IResource) ((IAdaptable) object).getAdapter(IResource.class);
			if (resource == null) {
				return null;
			}
			
			if (directory) {
				if (resource.getType() == IResource.FILE) {
					return resource.getParent().getLocation().toOSString();
				}
			}
			
			return resource.getLocation().toOSString();
		}
		
		return null;
	}
	
}
