package jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.view;

import java.util.Collection;

import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.view.column.ClassJavadocColumn;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.view.column.FieldAverageColumn;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.view.column.FileColumn;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.view.column.JavadocColumn;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.view.column.MethodAverageColumn;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.view.column.TotalJavadocColumn;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;

public class JavadocCountView extends ViewPart {
    
    private TableViewer viewer = null;
    
    private JavadocColumn[] columns = {
            new FileColumn(),
            new TotalJavadocColumn(),
            new ClassJavadocColumn(),
            new MethodAverageColumn(),
            new FieldAverageColumn()
    };
    
    public JavadocCountView() {
    }

    public void createPartControl(Composite parent) {
        Table table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL | SWT.SINGLE | SWT.FULL_SELECTION);
        viewer = new TableViewer(table);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayout(new TableLayout());
        
        for (int i = 0; i < columns.length; i++) {
            TableColumn column = new TableColumn(table, columns[i].getStyle(), i);
            column.setText(columns[i].getColumnText());
            column.setResizable(true);
            column.setWidth(columns[i].getWidth());
        }
        
        viewer.setContentProvider(new ArrayContentProvider());
        viewer.setLabelProvider(new JavadocLabelProvider(columns));
    }

    public void setFocus() {
        
    }
    
    public void updateView(Collection countResult) {
        viewer.setInput(countResult);
    }
    
}
