package jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.count;

import java.util.Iterator;
import java.util.List;

import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.vo.CountElementVo;
import jp.gr.java_conf.ykhr.eclipse.plugin.jdcounter.vo.CountVo;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;


public class JavadocCounter {
    
    public CountVo count(ICompilationUnit comp, String typeName) throws JavaModelException {
        ASTParser parser = ASTParser.newParser(AST.JLS3);
        parser.setKind(ASTParser.K_COMPILATION_UNIT);
        parser.setSource(comp);
        CompilationUnit cu = (CompilationUnit) parser.createAST(null);

        CountVo cuCount = new CountVo(comp);
        cuCount.setTotalJavadocLines(getCompilationUnitDocLines(cu));
        
        List types = cu.types();
        if (types.size() < 1) {
            return cuCount;
        }
        
        for (Iterator typeIt = types.iterator(); typeIt.hasNext(); ) {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration) typeIt.next();
            
            if (typeName.equals(declaration.getName().getIdentifier())) {
                cuCount.setJavadocLines(getLineLength(cu, declaration.getJavadoc()));
                
                if (declaration instanceof TypeDeclaration) {
                    TypeDeclaration type = (TypeDeclaration) declaration;
                    countFields(cu, cuCount, type);
                    countMethods(cu, cuCount, type);
                }
                
                break;
            }

        }
        
        return cuCount;
    }
    
    public CountVo count(ICompilationUnit comp) throws JavaModelException {
        String elemenetName = comp.getElementName();
        String fileName = elemenetName.substring(0, elemenetName.length() - 5);
        return count(comp, fileName);
    }

    private void countMethods(CompilationUnit cu, CountVo cuCount, TypeDeclaration type) {
        MethodDeclaration[] methods = type.getMethods();
        for (int i = 0; i < methods.length; i++) {
            int line = getLineLength(cu, methods[i].getJavadoc());
            CountElementVo methodCount = new CountElementVo(null, methods[i].getName().getIdentifier(), line);
            cuCount.addMethod(methodCount);
        }
    }

    private void countFields(CompilationUnit cu, CountVo cuCount, TypeDeclaration type) {
        FieldDeclaration[] fields = type.getFields();
        for (int i = 0; i < fields.length; i++) {
            List list = fields[i].fragments();
            StringBuffer sb = new StringBuffer();
            int fieldNum = 0;
            for (Iterator iter = list.iterator(); iter.hasNext(); fieldNum++) {
                VariableDeclarationFragment vbf = (VariableDeclarationFragment) iter.next();
                sb.append(vbf.getName() + ",");
            }
            sb.setLength(sb.length() - 1);
            
            int line = getLineLength(cu, fields[i].getJavadoc());
            CountElementVo fieldCount = new CountElementVo(sb.toString(), line, fieldNum);
            cuCount.addField(fieldCount);
        }
    }
    
    private int getCompilationUnitDocLines(CompilationUnit cu) {
        int lines = 0;
        List comments = cu.getCommentList();
        
        for (Iterator iter = comments.iterator(); iter.hasNext(); ) {
            Comment com = (Comment) iter.next();
            if (com.isDocComment()) {
                lines += getLineLength(cu, com);
            }
        }
        
        return lines;
    }
    
    private int getLineLength(CompilationUnit cu, ASTNode node) {
        if (node == null) {
            return 0;
        }
        
        int start = cu.getLineNumber(node.getStartPosition());
        int end = cu.getLineNumber(node.getStartPosition() + node.getLength());
        return end - start + 1;
    }

}
