package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.vo;



public class TestCaseVO {
    
    public static final int TEST_SUCCESS = 1;
    public static final int TEST_ERROR = 2;
    public static final int TEST_FAILURE = 3;
    
    private String className;
    private String name;
    private int testResult;
    
    private String trace;
    private long time;
    
    public TestCaseVO(String className, String methodName, int testResult, String trace, long time) {
        this.className = className;
        this.name = methodName;
        this.testResult = testResult;
        this.trace = trace;
        this.time = time;
    }
    
    public String getName() {
        return name;
    }
    
    public String getClassName() {
        return className;
    }
    
    public long getTime() {
        return time;
    }
    
    public double getTimeInSecond() {
        return time / 1000.;
    }
    
    public boolean isSuccess() {
        return testResult == TEST_SUCCESS;
    }
    
    public boolean isError() {
        return testResult == TEST_ERROR;
    }
    
    public boolean isFailure() {
        return testResult == TEST_FAILURE;
    }
    
    public String getMessage() {
        String line = traceFirstLine();
        int index = line.indexOf(':');
        if (index == -1) {
            return null;
        }
        return line.substring(index + 1).trim();
    }
    
    public String getType() {
        String line = traceFirstLine();
        int index = line.indexOf(':');
        if (index == -1) {
            return line;
        }
        return line.substring(0, index);
    }
    
    public String getTrace() {
        return trace;
    }
    
    private String traceFirstLine() {
        int index = trace.indexOf('\n');
        if (index != -1) {
            return trace.substring(0, index);
        }
        return trace;
    }

}
