package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.vo.TestCaseVO;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.vo.TestSuiteVO;

import org.eclipse.jdt.internal.junit.model.ITestRunSessionListener;
import org.eclipse.jdt.internal.junit.model.ITestSessionListener;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jdt.internal.junit.model.TestElement.Status;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.ui.IStartup;


public class TestListener implements IStartup {
    
    private static TestListener instance;
    
    private Hashtable testResults = new Hashtable();
    private boolean testRunning = false;
    
    private class TestRunSessionListener implements ITestRunSessionListener {
        
        private ITestSessionListener testSession = new TestSessionListener();
        
        public void sessionAdded(TestRunSession testRunSession) {
            if (testRunSession == null) {
                return;
            }
            
            testRunSession.addTestSessionListener(testSession);
        }
        public void sessionRemoved(TestRunSession testRunSession) {
            if (testRunSession == null) {
                return;
            }
            testRunSession.removeTestSessionListener(testSession);
        }
    }
    
    private class TestSessionListener implements ITestSessionListener {
        private Map testTimes = new HashMap();
        
        public void sessionEnded(long elapsedTime) {
            setTestRunning(false);
        }
        
        public void sessionStarted() {
            clearTestResult();
            setTestRunning(true);
        }
        
        public void sessionStopped(long elapsedTime) {
            setTestRunning(false);
        }
        
        public void sessionTerminated() {
        }
        
        public void testAdded(TestElement testElement) {
        }
        
        public boolean acceptsSwapToDisk() {
            return false;
        }
        
        public void runningBegins() {
        }
        
        public void testEnded(TestCaseElement testCaseElement) {
            Long startTime = (Long) testTimes.get(testCaseElement.getId());
            long start = 0;
            
            if (startTime != null) {
                start = startTime.longValue();
                testTimes.remove(testCaseElement.getId());
            } else {
                start = System.currentTimeMillis();
            }
            long end = System.currentTimeMillis();
            long testTime = end - start;
            cacheTestResult(testCaseElement, testTime);
        }
        
        public void testStarted(TestCaseElement testCaseElement) {
            testTimes.put(testCaseElement.getId(), new Long(System.currentTimeMillis()));
        }
        
        public void testFailed(TestElement testElement, Status status, String trace, String expected, String actual) {
        }
        
        public void testReran(TestCaseElement testCaseElement, Status status, String trace, String expectedResult, String actualResult) {
        }
        
    }
    
    private void cacheTestResult(TestCaseElement test, long time) {
        TestSuiteElement parent = test.getParent();
        
        TestSuiteVO suite = (TestSuiteVO) testResults.get(parent.getId());
        if (suite == null) {
            suite = new TestSuiteVO(parent.getId(), parent.getTestName());
            testResults.put(parent.getId(), suite);
        }
        
        int testResult = 0;
        Status status = test.getStatus();
        if (status.isOK()) {
            testResult = TestCaseVO.TEST_SUCCESS;
        } else if (status.isError()) {
            testResult = TestCaseVO.TEST_ERROR;
        } else if (status.isFailure()) {
            testResult = TestCaseVO.TEST_FAILURE;
        }
        
        TestCaseVO testCase = new TestCaseVO(test.getClassName(), test.getTestMethodName(), testResult, test.getTrace(), time);
        suite.addTestCase(testCase);
    }
    
    public Map getTestResults() {
        return (Map) testResults.clone();
    }
    
    private void clearTestResult() {
        testResults.clear();
    }
    
    public boolean isTestRunning() {
        return testRunning;
    }
    
    private void setTestRunning(boolean testRunning) {
        this.testRunning = testRunning;
    }
    
    public void earlyStartup() {
        instance = this;
        JUnitPlugin.getModel().addTestRunSessionListener(new TestRunSessionListener());
    }
    
    public static TestListener getInstance() {
        return instance;
    }
    
}
