package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter;

import java.util.Map;

import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.main.IReporterCommand;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.main.ReporterCommand;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.main.ReporterJob;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;


public class ReporterAction implements IViewActionDelegate {
    
    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        TestListener test = TestListener.getInstance();
        if (test.isTestRunning()) {
            // TODO
            return;
        }
        
        Map testResults = test.getTestResults();
        if (testResults.isEmpty()) {
            // TODO
            return;
        }
        
        ReportProperty prop = ReportPropertyHelper.createReportProperty();
        IReporterCommand command = ReporterCommand.getCommand(testResults, prop);
        new ReporterJob(command).schedule();
    }
    
    public void selectionChanged(IAction action, ISelection selection) {
    }
    
}
