package jp.gr.java_conf.ykhr.eclipse.plugin.chocoxslt;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class XsltAction implements IObjectActionDelegate{

    protected ISelection selection;
    
    /**
     * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
     */
    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
    
    protected String toSystemPath(IProject project, String path) {
        if (isEmpty(path)) { 
            return null;
        }
        
        IPath p = project.getLocation().append(path);
        return p.toOSString();
    }
    
    protected boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
    
    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
    
}