package jp.gr.java_conf.ykhr.eclipse.plugin.chocoxslt;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IActionDelegate;

public class RunXsltAction extends XsltAction {

    /**
     * @see IActionDelegate#run(IAction)
     */
    public void run(IAction action) {
        IFile xslFile = (IFile) ((IStructuredSelection) selection).getFirstElement();
        
        InputCache cache = new InputCache(xslFile);
        XsltDialog dialog = new XsltDialog(Activator.getShell(), xslFile, cache);
        
        int code = dialog.open();
        if (code != Window.OK) {
            return;
        }
        
        if (isEmpty(dialog.getInput())) {
            return;
        }

        IProject project = xslFile.getProject();
        RunDescription desc = new RunDescription();
        desc.setXsl(xslFile.getLocation().toOSString());
        desc.setInput(toSystemPath(project, dialog.getInput()));
        desc.setOutput(toSystemPath(project, dialog.getOutput()));
        desc.setProperty(toSystemPath(project, dialog.getProperty()));
        new RunXsltJob(desc).schedule();
    }

}
