package jp.xet.eclipse.memopad;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class MemopadPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "jp.xet.eclipse.memopad";
	
	public static final String VIEW_ID = "jp.xet.eclipse.memopad.views.MemopadView";

	// The shared instance
	private static MemopadPlugin plugin;
	
	/**
	 * The constructor
	 */
	public MemopadPlugin() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static MemopadPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}

    
    /**
     * error log.
     * @param t
     */
    public static void logError(Throwable t) {
        log(new Status(IStatus.ERROR, PLUGIN_ID, IStatus.INFO, t.getMessage(), t));
    }
    
    /**
     * log.
     * @param status
     */
    public static void log(IStatus status) {
        getDefault().getLog().log(status);
    }
	
}
