package jp.gr.java_conf.ykhr.common.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

import jp.gr.java_conf.ykhr.csvutil.core.CSVElement;


public class Utils {
    
    public static final Comparator<CSVElement> PRIORITY_COMP = new Comparator<CSVElement>() {
        public int compare(CSVElement o1, CSVElement o2) {
            if (o1.priority() < o2.priority()) {
                return -1;
            } else if (o1.priority() > o2.priority()) {
                return 1;
            }
            return compareStr(o1.value(), o2.value());
        }
        
        private int compareStr(String o1, String o2) {
            boolean o1IsNull = o1 == null;
            boolean o2IsNUll = o2 == null;
            
            if (o1IsNull && o2IsNUll) {
                return 0;
            } else if (o1IsNull) {
                return 1;
            } else if (o2IsNUll) {
                return -1;
            }
            
            return o1.compareTo(o2);
        }
        
    };
    
    public static Map<CSVElement, PropertyDescriptor>
    createCsvToPropertyInfo(Class<?> clazz) throws IntrospectionException {
        
        Map<CSVElement, PropertyDescriptor> result 
            = new HashMap<CSVElement, PropertyDescriptor>();
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
        
        for (int i = 0; i < propDescs.length; i++) {
            String name = propDescs[i].getName();
            
            Field field = getPropertyField(clazz, name);
            if (field == null) {
                continue;
            }
            
            CSVElement csvAnnotation = field.getAnnotation(CSVElement.class);
            if (csvAnnotation != null) {
                result.put(csvAnnotation, propDescs[i]);
            }
        }
        
        return result;
    }
    
    public static Map<String, PropertyDescriptor>
    createCsvNameToProperty(Class<?> clazz) throws IntrospectionException {
        
        Map<CSVElement, PropertyDescriptor> map = createCsvToPropertyInfo(clazz);
        Map<String, PropertyDescriptor> result = new HashMap<String, PropertyDescriptor>();
        
        for (Map.Entry<CSVElement, PropertyDescriptor> entry : map.entrySet()) {
            result.put(entry.getKey().value(), entry.getValue());
        }
        
        return result;
    }
    
    private static Field getPropertyField(Class<?> clazz, String name) {
        if (clazz == null) {
            return null;
        }
        
        try {
            Field field = clazz.getDeclaredField(name);
            return field;
        } catch (NoSuchFieldException ignore) {
        }
        
        return getPropertyField(clazz.getSuperclass(), name);
    }
    
    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            } catch (IOException ignore) {
            }
        }
    }
    
}
