package jp.gr.java_conf.ykhr.common.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

import jp.gr.java_conf.ykhr.common.ex.ReadException;

public class ReaderUtils {
    
    public static void setObject(Object bean, Method method, Object param) 
    throws ReadException {
        try {
            method.invoke(bean, new Object[]{param});
        } catch (IllegalAccessException e) {
            throw new ReadException(e);
        } catch (InvocationTargetException e) {
            throw new ReadException(e);
        }
    }
    
    public static <T>T createBeanInstance(Class<T> clazz) throws ReadException {
        try {
            return clazz.newInstance();
        } catch (InstantiationException e) {
            throw new ReadException(e);
        } catch (IllegalAccessException e) {
            throw new ReadException(e);
        }
    }
    
    public static Object convertType(String value, Type type) {
        if (isEmpty(value)) {
            return null;
        }
        
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return Integer.valueOf(value);
        } else if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return Double.valueOf(value);
        } else if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return Long.valueOf(value);
        } else if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf(value);
        } else if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return Boolean.valueOf(value);
        } else if (type.equals(Character.TYPE) || type.equals(Character.class)) {
            return Character.valueOf(value.charAt(0));
        }else if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return Byte.valueOf(value);
        } 
        
        return value;
    }
    
    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
    
}
