package jp.xet.eclipse.activitytracker;

import jp.xet.eclipse.activitytracker.views.UserActivityView;

import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/**
 * Key listener.
 * 
 * @author daisuke
 */
public class UserActivityListener implements Listener {
	
	private UserActivityView view;
	
	private Event prev = new Event();
	

	public void handleEvent(Event e) {
		if (view == null) {
			return;
		}
		
		if (e.type == SWT.MouseDown) {
			view.println("Mouse Down");
			return;
		}
		if (e.type == SWT.MouseUp) {
			view.println("Mouse Up");
			return;
		}
		
		// あーカッコ悪い…。
		if (e.time == prev.time && prev.keyCode == e.keyCode) {
			return;
		}
		if (e.time - prev.time < 200 && prev.keyCode == e.keyCode) {
			if (prev.type == SWT.Traverse && e.type == SWT.KeyDown) {
				return;
			}
			if (prev.type == SWT.Traverse && e.type == SWT.KeyUp) {
				return;
			}
			if (prev.type == SWT.KeyDown && e.type == SWT.KeyUp) {
				return;
			}
		}
		prev = e;
		// カッコ悪いゾーン終了
		
		int accelerator = SWTKeySupport.convertEventToModifiedAccelerator(e);
		KeyStroke stroke = SWTKeySupport.convertAcceleratorToKeyStroke(accelerator);
		KeySequence keySequence = KeySequence.getInstance(stroke);
		String text = stroke.format().trim();
		
		if (keySequence.isComplete() && text.length() > 0) {
			view.println(text);
		}
	}
	
	/**
	 * Set the view to output.
	 * 
	 * @param view the view to output
	 */
	public void setOutput(UserActivityView view) {
		this.view = view;
	}
}
