package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.preference;

import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.JUnitReporterActivator;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.ReportPropertyHelper;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JUnitReporterPreferencePage extends PreferencePage implements
        IWorkbenchPreferencePage {
    
    private Button kindNoFrame;
    private Button kindFrame;
    private Button kindCustom;
    private Composite custom;
    private Text xsltPath;
    private Button typeFile;
    private Button typeDir;
    
    public JUnitReporterPreferencePage() {
        super();
    }
    
    public JUnitReporterPreferencePage(String title) {
        super(title);
    }

    public JUnitReporterPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        noDefaultAndApplyButton();
        create(parent);
        initValue();
        return null;
    }
    
    private void initValue() {
        IPreferenceStore store = JUnitReporterActivator.getDefault().getPreferenceStore();
        int kind = store.getInt(ReportPropertyHelper.KEY_XSLT_KIND);
        
        if (kind == ReportPropertyHelper.XSLT_KIND_NOFRAME) {
            kindNoFrame.setSelection(true);
            changeCustomEnable(false);
        } else if (kind == ReportPropertyHelper.XSLT_KIND_FRAME) {
            kindFrame.setSelection(true);
            changeCustomEnable(false);
        } else if (kind == ReportPropertyHelper.XSLT_KIND_CUSTOM) {
            kindCustom.setSelection(true);
            xsltPath.setText(store.getString(ReportPropertyHelper.KEY_CUSTOM_PATH));
            int type = store.getInt(ReportPropertyHelper.KEY_CUSTOM_TYPE);
            
            if (type == ReportPropertyHelper.TYPE_FILE) {
                typeFile.setSelection(true);
            } else if (type == ReportPropertyHelper.TYPE_DIR) {
                typeDir.setSelection(true);
            }
            changeCustomEnable(true);
        }
    }

    private void create(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new GridLayout(1, true));
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
        
        Group group = new Group(composite, SWT.NONE);
        group.setText("select report style");
        group.setLayout(new GridLayout(1, true));
        group.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        kindNoFrame = new Button(group, SWT.RADIO);
        kindNoFrame.setText("Ant no-frame");
        
        kindFrame = new Button(group, SWT.RADIO);
        kindFrame.setText("Ant frames");
        
        kindCustom = new Button(group, SWT.RADIO);
        kindCustom.setText("custom");
        
        kindCustom.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                changeCustomEnable(kindCustom.getSelection());
            }
        });
        
        custom = new Composite(group, SWT.NONE);
        custom.setLayout(new GridLayout(5, true));
        GridData customCompData = new GridData(GridData.FILL_BOTH);
        customCompData.horizontalIndent = 10;
        custom.setLayoutData(customCompData);
        
        xsltPath = new Text(custom, SWT.SINGLE | SWT.BORDER);
        GridData pathData = new GridData(GridData.FILL_HORIZONTAL);
        pathData.horizontalSpan = 4;
        xsltPath.setLayoutData(pathData);
        
        Button dialogButton = new Button(custom, SWT.PUSH);
        dialogButton.setText("file...");
        dialogButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        dialogButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(JUnitReporterActivator.getShell(), SWT.OPEN);
                String path = dialog.open();
                
                if (path == null) {
                    return;
                }
                
                xsltPath.setText(path);
            }
        });
        
        typeFile = new Button(custom, SWT.RADIO);
        typeFile.setText("file type");
        typeDir = new Button(custom, SWT.RADIO);
        typeDir.setText("dir type");
    }
    
    private void changeCustomEnable(boolean enable) {
        custom.setEnabled(enable);
    }
    
    public boolean performOk() {
        // TODO validate
        
        IPreferenceStore store = JUnitReporterActivator.getDefault().getPreferenceStore();
        int xsltKind = 0;
        if (kindNoFrame.getSelection()) {
            xsltKind = ReportPropertyHelper.XSLT_KIND_NOFRAME;
        } else if (kindFrame.getSelection()) {
            xsltKind = ReportPropertyHelper.XSLT_KIND_FRAME;
        } else if (kindCustom.getSelection()) {
            xsltKind = ReportPropertyHelper.XSLT_KIND_CUSTOM;
        }
        
        store.setValue(ReportPropertyHelper.KEY_XSLT_KIND, xsltKind);
        if (kindCustom.getSelection()) {
            store.setValue(ReportPropertyHelper.KEY_CUSTOM_PATH, xsltPath.getText());
            int type = 0;
            if (typeFile.getSelection()) {
                type = ReportPropertyHelper.TYPE_FILE;
            } else {
                type = ReportPropertyHelper.TYPE_DIR;
            }
            store.setValue(ReportPropertyHelper.KEY_CUSTOM_TYPE, type);
        }
        
        JUnitReporterActivator.getDefault().savePluginPreferences();
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

}
