package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.main;

import java.io.File;

import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.ReportProperty;



public class SingleHtmlConverter extends HtmlConverter {
    
    public SingleHtmlConverter(String xml, String dest, ReportProperty prop) {
        super(xml, dest, prop);
    }
    
    protected void postConvert() {
        // do nothing
    }
    
    protected void preConvert() {
        File outputFile = new File(dest);
        File outputDir = outputFile.getParentFile();
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
    }
    
    protected Result getTransformResult() {
        return new StreamResult(new File(dest));
    }
    
}
