/**
 * The MIT License
 * 
 * Copyright (c) 2009 kyozi0x7c00@gmail.com
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package jp.sourceforge.hhcp.statement.impl;

import jp.sourceforge.hhcp.mining.IStatementVisitor;

import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class MethodStatement extends IStatementImpl {
	IMethodBinding _binding;

	public MethodStatement(IMethodBinding binding) {
		_binding = binding;
	}

	@Override
	public void accept(IStatementVisitor visitor) {
		visitor.visit(this);
	}

	@Override
	public String toString() {
		String parameters = "";
		StringBuffer buffer = new StringBuffer();
		for (ITypeBinding param : _binding.getParameterTypes()) {
			if (param.getPackage() != null) {
				buffer.append(param.getPackage().getName() + ".");
			}
			buffer.append(param.getName() + ", ");
		}
		if (buffer.length() != 0) {
			int lastComma = buffer.lastIndexOf(", ");
			parameters = buffer.substring(0, lastComma);
		}

		// get returnType
		StringBuffer returnType = new StringBuffer();
		if (_binding.getReturnType().getPackage() != null) {
			returnType.append(_binding.getReturnType().getPackage().getName() + ".");
		}
		returnType.append(_binding.getReturnType().getName());

		return _binding.getName() + "(" + parameters + ")" + ":" + returnType.toString();
	}
	
	public IMethodBinding getBinding() {
		return _binding;
	}
}
