package jp.sourceforge.hhcp.mining;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import jp.sourceforge.hhcp.statement.IMethodDeclaration;
import jp.sourceforge.hhcp.statement.IStatement;
import jp.sourceforge.hhcp.statement.StatementFactory;
import jp.sourceforge.hhcp.statement.impl.ExpressionStatement;
import jp.sourceforge.hhcp.statement.impl.IfStatement;
import jp.sourceforge.hhcp.statement.impl.LoopStatement;
import jp.sourceforge.hhcp.statement.impl.MethodDeclaration;
import jp.sourceforge.hhcp.statement.impl.MethodStatement;
import jp.sourceforge.hhcp.statement.impl.TryStatement;

public class ProjectedStatement extends AbstractProjectedStatement {
	StatementFactory _factory;
	List<IStatement> _prefixList;
	List<IStatement> _projectedList;
	List<IMethodDeclaration> _prefixMethods;
	List<IMethodDeclaration> _projectedMethods;

	public ProjectedStatement(List<IMethodDeclaration> prefixMethods) {
		_factory = new StatementFactory();
		_prefixList = Collections.synchronizedList(new ArrayList());
		_projectedList = Collections.synchronizedList(new ArrayList());
		_prefixMethods = prefixMethods;
		_projectedMethods = Collections.synchronizedList(new ArrayList());
	}

	@Override
	public void visit(ExpressionStatement statement) {
	}

	@Override
	public void visit(IfStatement statement) {
		statement.getExpressionStatement().accept(this);
		if (statement.getThenStatement() != null) {
			statementIterator(statement.getThenStatement());
		}
		if (statement.getElseStatement() != null) {
			statementIterator(statement.getElseStatement());
		}
		
		ExpressionStatement expression = statement.getExpressionStatement();
		List<IStatement> thenStatement = statement.getThenStatement();
		List<IStatement> elseStatement = statement.getElseStatement();
		if (_keySet.contains(expression.toString())) {
			addPrefix(_factory.newIfStatement(expression, null, null));
			addProjected(_factory.newIfStatement(expression, thenStatement, elseStatement));
		}

	}

	@Override
	public void visit(LoopStatement statement) {
		statement.getExpressionStatement().accept(this);
		if (statement.getStatement() != null) {
			statementIterator(statement.getStatement());
		}
	}

	@Override
	public void visit(MethodDeclaration statement) {
		statementIterator(statement.getStatement());		
	}

	@Override
	public void visit(MethodStatement statement) {
		if (_keySet.contains(statement.toString())) {
			addPrefix(_factory.newMethodStatement(statement.getBinding()));
		}
	}

	@Override
	public void visit(TryStatement statement) {
	}
	
	private void statementIterator(List<IStatement> iteratable) {
		Iterator<IStatement> it = iteratable.iterator();
		while (it.hasNext()) {
			((IAcceptable) it.next()).accept(this);
		}
	}
	
	private void addPrefix(IStatement statement) {
		_prefixList.add(statement);
	}
	
	private void addProjected(IStatement statement) {
		_projectedList.add(statement);
	}
	
	public List<IMethodDeclaration> getPrefixMethods() {
		return _prefixMethods;
	}
	
	public void setPrefixMethods(List<IMethodDeclaration> prefixMethods) {
		_prefixMethods = prefixMethods;
	}

	public List<IMethodDeclaration> getProjectedMethods() {
		return _projectedMethods;
	}
}
