﻿/**
 * The MIT License
 * 
 * Copyright (c) 2009 kyozi0x7c00@gmail.com
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package jp.sourceforge.hhcp.mining;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import jp.sourceforge.hhcp.statement.IMethodDeclaration;
import jp.sourceforge.hhcp.statement.impl.MethodDeclaration;

public class PrefixSpan {
	private int _minSupport;
	private int _minLength;
	private FrequentSet _frequentSet;
	private AbstractProjectedStatement _projectedStatement;
	List<IMethodDeclaration> _newPrefixDatabase;
	List<IMethodDeclaration> _newProjectedDatabase;
	

	public PrefixSpan(int minSupport, int minLength) {
		_minSupport = minSupport;
		_minLength = minLength;
	}

	public void prefixSpan(List<IMethodDeclaration> prefixProjectedDatabase) {
		_frequentSet = new FrequentSet();
		_projectedStatement = null;
		_newPrefixDatabase = Collections.synchronizedList(new ArrayList<IMethodDeclaration>());
		_newProjectedDatabase = Collections.synchronizedList(new ArrayList<IMethodDeclaration>());		
		doPrefixSpan(null, prefixProjectedDatabase);
	}

	private void doPrefixSpan(List<IMethodDeclaration> prefix, List<IMethodDeclaration> prefixProjectedDatabase) {
		if (prefixProjectedDatabase == null)
			return;
		if (prefixProjectedDatabase.size() == 0)
			return;
		
		Set<String> keySet = getKeySet(prefixProjectedDatabase);
//		System.out.println(frequentMap);

		_newPrefixDatabase.clear();
		_newProjectedDatabase.clear();
		Iterator<IMethodDeclaration> methodIter = prefixProjectedDatabase.iterator();
		if (prefix == null) {
			while (methodIter.hasNext()) {
				_projectedStatement = new NullProjectedStatement(keySet);
				MethodDeclaration method = (MethodDeclaration) methodIter.next();
				_projectedStatement.visit(method);
				if (((NullProjectedStatement) _projectedStatement).getPrefixMethod() != null
						&& ((NullProjectedStatement) _projectedStatement).getProjectedMethod() != null) {
					_newPrefixDatabase.add(((NullProjectedStatement) _projectedStatement).getPrefixMethod());
					_newProjectedDatabase.add(((NullProjectedStatement) _projectedStatement).getProjectedMethod());
				}
			}	
		} else {
			_projectedStatement = new ProjectedStatement(prefix);
			while (methodIter.hasNext()) {
				MethodDeclaration method = (MethodDeclaration) methodIter.next();
				_projectedStatement.visit(method);
			}	
			_newPrefixDatabase.addAll(((ProjectedStatement) _projectedStatement).getPrefixMethods());
			_newProjectedDatabase.addAll(((ProjectedStatement) _projectedStatement).getProjectedMethods());
		}
		

		doPrefixSpan(_newPrefixDatabase, _newProjectedDatabase);
	}

	private Set<String> getKeySet(List<IMethodDeclaration> prefixProjectedDatabase) {
		Map<String, Integer> map = Collections.synchronizedMap(new HashMap<String, Integer>());
		Iterator<IMethodDeclaration> methodIter = prefixProjectedDatabase.iterator();
		while (methodIter.hasNext()) {
			_frequentSet.clear();
			MethodDeclaration method = (MethodDeclaration) methodIter.next();
			_frequentSet.visit(method);

			// create frequentSet
			Iterator<String> it = _frequentSet.iterator();
			while (it.hasNext()) {
				String key = it.next();
				if (map.containsKey(key)) {
					map.put(key, map.get(key)+1);
				} else {
					map.put(key, 1);
				}
			}
		}

		// delete statement if map(freq) < minSupport
		Iterator<String> it = map.keySet().iterator();
		while (it.hasNext()) {
			Integer support = map.get(it.next());
			if (support.intValue() < _minSupport) {
				it.remove();
			}
		}

		return map.keySet();
	}
	
	public int getLength() {
		return _minLength;
	}
}