/**
 * The MIT License
 * 
 * Copyright (c) 2009 K.Takahashi
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
 * @author K.Takahashi (kyozi0x7c00@gmail.com)
 */
package jp.sourceforge.geneticalgorithm.travelingsalesmanproblem;

import java.util.ArrayList;

import jp.sourceforge.geneticalgorithm.Gene;
import jp.sourceforge.geneticalgorithm.Individual;

public class TspIndividual extends Individual {
	private int _chromosomeSize = 8;
	
	@Override
	public void createGeen() {
		_chromosome = new ArrayList<Gene>(_chromosomeSize);
		int limit = _chromosomeSize;
		for (int i = 0; i < _chromosomeSize; i++) {
			_chromosome.add(new Gene((int) (Math.random() * limit)));
			limit--;
		}
		this.evaluation();
	}
	
	@Override
	public void mutation() {
		int index1 = (int) (Math.random() * _chromosomeSize);
		int index2 = (int) (Math.random() * _chromosomeSize);
		Gene gene1 = _chromosome.get(index1);
		Gene gene2 = _chromosome.get(index2);
		Gene tmp = new Gene(gene1.getGene());
		_chromosome.set(index1, gene2);
		_chromosome.set(index2, tmp);
	}
		
	@Override
	public void evaluation() {
		int pheno[];
		int end;
		
		pheno = this.decodeChromosome();
		
		double dtotal = 0.0;
		for (int start = 0; start < _chromosomeSize; start++) {
			end = start + 1;
			if (end == _chromosomeSize) {
				end = 0;
			}
			dtotal += TravelingSalesmanProblem.COST_MATRIX[pheno[start]][pheno[end]];
	    }
		_rawFitness = dtotal;
		_fitness = dtotal;
	}
	
	private int[] decodeChromosome() {
		// Ordinal Repesentation
		int order[] = new int[_chromosomeSize];
		int pheno[] = new int[_chromosomeSize];
		int i;
		int j;
		int n;

		for (i = 0; i < _chromosomeSize; i++) {
			order[i] = i;
		}

		for (i = 0; i < _chromosomeSize; i++) {
			Gene gene = _chromosome.get(i); 
			n = gene.getGene();
			pheno[i] = order[n];
			for (j = n; j < _chromosomeSize - i - 1; j++) {
				order[j] = order[j+1];
			}
		}
		
		return pheno;
	}
	
	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		int[] pheno = this.decodeChromosome();
		
		sb.append("[");
		for (int n : pheno) {
			sb.append(n + ", ");
		}
		sb.delete(sb.lastIndexOf(", "), sb.length());
		sb.append("]:[" + getFitness() + "]");
		sb.append("\n");
		
		return sb.toString();
	}
}
