/**
 * The MIT License
 * 
 * Copyright (c) 2009 K.Takahashi
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
 * @author K.Takahashi (kyozi0x7c00@gmail.com)
 */
package jp.sourceforge.geneticalgorithm;

public class GeneticAlgorithm {
	private GeneticPool _geneticPool;
	
	public void execute() {
		boolean state = false;
		_geneticPool = new GeneticPool();
		_geneticPool.initializePopulation();
		_geneticPool.takeStatistic();
		do {
			state = doExecute();
			_geneticPool.takeStatistic();
		} while (!state);
	}
	
	private boolean findGoal;
	
	private boolean doExecute() {
		boolean ret;

		findGoal = false;
		if (_geneticPool.getCurrentGenerationNumber() < _geneticPool.getGenerationNumber()) {
			_geneticPool.nextGeneration();
			ret = false;
		} else {
			ret = true;
		}
		
		if (findGoal) {
			ret = true;
		}

		return ret;
	}
}
